/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.containers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.competition.TransitionController;
import mc.alk.arena.controllers.messaging.MessageHandler;
import mc.alk.arena.events.BAEvent;
import mc.alk.arena.events.players.ArenaPlayerLeaveEvent;
import mc.alk.arena.events.players.ArenaPlayerLeaveLobbyEvent;
import mc.alk.arena.events.players.ArenaPlayerTeleportEvent;
import mc.alk.arena.listeners.PlayerHolder;
import mc.alk.arena.listeners.custom.MethodController;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.ContainerState;
import mc.alk.arena.objects.LocationType;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.options.StateOptions;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.teams.TeamHandler;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.TeamUtil;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAreaContainer
implements PlayerHolder,
TeamHandler {
    public static final AbstractAreaContainer HOMECONTAINER = new AbstractAreaContainer("home"){

        public LocationType getLocationType() {
            return LocationType.HOME;
        }

        public ArenaTeam getTeam(ArenaPlayer player) {
            return null;
        }
    };
    protected String name;
    protected String displayName;
    protected MatchParams params;
    ContainerState state;
    boolean disabledAllCommands;
    Set<String> disabledCommands;
    Set<String> enabledCommands;
    private final MethodController methodController;
    protected final Set<UUID> players;
    protected final List<List<SpawnLocation>> spawns;
    protected List<SpawnLocation> allSpawns;
    SpawnLocation mainSpawn;
    protected final List<ArenaTeam> teams;
    final Map<ArenaTeam, Integer> teamIndexes;
    static final Random r = new Random();

    public AbstractAreaContainer(String name) {
        block2: {
            this.state = ContainerState.OPEN;
            this.players = new HashSet<UUID>();
            this.spawns = new ArrayList<List<SpawnLocation>>();
            this.mainSpawn = null;
            this.teams = Collections.synchronizedList(new ArrayList());
            this.teamIndexes = new ConcurrentHashMap<ArenaTeam, Integer>();
            this.methodController = new MethodController("AAC " + name);
            this.methodController.addAllEvents(this);
            try {
                Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BattleArena.getSelf());
            }
            catch (Exception e) {
                if (Defaults.TESTSERVER) break block2;
                Log.printStackTrace(e);
            }
        }
        this.name = name;
    }

    @Override
    public void callEvent(BAEvent event) {
        this.methodController.callEvent(event);
    }

    public void playerLeaving(ArenaPlayer player) {
        this.methodController.updateEvents(MatchState.ONLEAVE, player);
    }

    protected void playerJoining(ArenaPlayer player) {
        this.methodController.updateEvents(MatchState.ONENTER, player);
    }

    protected void updateBukkitEvents(MatchState matchState, ArenaPlayer player) {
        this.methodController.updateEvents(matchState, player);
    }

    protected void teamLeaving(ArenaTeam team) {
        if (this.teams.remove(team)) {
            this.methodController.updateEvents(MatchState.ONLEAVE, team.getPlayers());
        }
    }

    public boolean teamJoining(ArenaTeam team) {
        this.teams.add(team);
        this.teamIndexes.put(team, this.teams.size());
        for (ArenaPlayer ap : team.getPlayers()) {
            this.doTransition(MatchState.ONJOIN, ap, team, true);
        }
        return true;
    }

    @ArenaEventHandler
    public void onArenaPlayerLeaveEvent(ArenaPlayerLeaveEvent event) {
        this._onArenaPlayerLeaveEvent(event);
    }

    @EventHandler
    public void _onArenaPlayerLeaveEvent(ArenaPlayerLeaveEvent event) {
        if (this.players.remove(event.getPlayer().getID())) {
            this.updateBukkitEvents(MatchState.ONLEAVE, event.getPlayer());
            this.callEvent(new ArenaPlayerLeaveLobbyEvent(event.getPlayer(), event.getTeam()));
            event.addMessage(MessageHandler.getSystemMessage("you_left_competition", this.params.getName()));
            event.getPlayer().reset();
        }
    }

    protected void doTransition(MatchState state, ArenaPlayer player, ArenaTeam team, boolean onlyInMatch) {
        if (player != null) {
            TransitionController.transition((PlayerHolder)this, (CompetitionState)state, player, team, onlyInMatch);
        } else {
            TransitionController.transition((PlayerHolder)this, (CompetitionState)state, team, onlyInMatch);
        }
    }

    @Override
    public boolean canLeave(ArenaPlayer p) {
        return false;
    }

    @Override
    public boolean leave(ArenaPlayer p) {
        return this.players.remove(p.getID());
    }

    @Override
    public void addArenaListener(ArenaListener arenaListener) {
        this.methodController.addListener(arenaListener);
    }

    @Override
    public boolean removeArenaListener(ArenaListener arenaListener) {
        return this.methodController.removeListener(arenaListener);
    }

    @Override
    public MatchParams getParams() {
        return this.params;
    }

    public void setParams(MatchParams mp) {
        this.params = mp;
    }

    @Override
    public MatchState getMatchState() {
        return MatchState.INLOBBY;
    }

    @Override
    public boolean isHandled(ArenaPlayer player) {
        return this.players.contains(player.getID());
    }

    @Override
    public CompetitionState getState() {
        return MatchState.NONE;
    }

    @Override
    public boolean checkReady(ArenaPlayer player, ArenaTeam team, StateOptions mo, boolean b) {
        return this.params.getStateGraph().playerReady(player, null);
    }

    @Override
    public SpawnLocation getSpawn(int index, boolean random) {
        if (index == Integer.MAX_VALUE) {
            return this.mainSpawn != null ? this.mainSpawn : (this.spawns.size() == 1 ? this.spawns.get(0).get(0) : null);
        }
        if (random) {
            if (this.allSpawns == null) {
                this.buildAllSpawns();
            }
            return this.allSpawns == null ? null : this.allSpawns.get(r.nextInt(this.allSpawns.size()));
        }
        List<SpawnLocation> l = index >= this.spawns.size() ? this.spawns.get(index % this.spawns.size()) : this.spawns.get(index);
        return l.get(r.nextInt(l.size()));
    }

    public SpawnLocation getSpawn(int teamIndex, int spawnIndex) {
        List<SpawnLocation> l = teamIndex >= this.spawns.size() ? null : this.spawns.get(teamIndex);
        return l == null || spawnIndex >= l.size() ? null : l.get(spawnIndex);
    }

    private void buildAllSpawns() {
        if (this.spawns.isEmpty()) {
            return;
        }
        this.allSpawns = new ArrayList<SpawnLocation>();
        for (List<SpawnLocation> spawn : this.spawns) {
            this.allSpawns.addAll(spawn);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSpawnLoc(int teamIndex, int spawnIndex, SpawnLocation loc) throws IllegalStateException {
        if (teamIndex == Integer.MAX_VALUE) {
            this.mainSpawn = loc;
            return;
        } else if (this.spawns.size() > teamIndex) {
            List<SpawnLocation> list = this.spawns.get(teamIndex);
            if (list.size() > spawnIndex) {
                list.set(spawnIndex, loc);
                return;
            } else {
                if (list.size() != spawnIndex) throw new IllegalStateException("You must set team spawn " + (list.size() + 1) + " first");
                list.add(loc);
            }
            return;
        } else {
            if (this.spawns.size() != teamIndex) throw new IllegalStateException("You must set spawn " + (this.spawns.size() + 1) + " first");
            ArrayList<SpawnLocation> list = new ArrayList<SpawnLocation>();
            if (list.size() < spawnIndex) {
                throw new IllegalStateException("You must set spawn #" + (list.size() + 1) + " for the " + TeamUtil.getTeamName(teamIndex) + " team first");
            }
            list.add(loc);
            this.spawns.add(list);
        }
    }

    public boolean validIndex(int index) {
        return this.spawns.size() < index;
    }

    public List<List<SpawnLocation>> getSpawns() {
        return this.spawns;
    }

    public SpawnLocation getMainSpawn() {
        return this.mainSpawn;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.name : this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public void onPreJoin(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPostJoin(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPreQuit(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPostQuit(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPreEnter(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPostEnter(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPreLeave(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPostLeave(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    public void setContainerState(ContainerState state) {
        this.state = state;
    }

    public ContainerState getContainerState() {
        return this.state;
    }

    public boolean isOpen() {
        return this.state.isOpen();
    }

    public boolean isClosed() {
        return this.state.isClosed();
    }

    public String getContainerMessage() {
        return this.state.getMsg();
    }

    @Override
    public boolean hasOption(StateOption option) {
        return this.getParams().hasOptionAt(this.getState(), option);
    }
}

