/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.containers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mc.alk.arena.Defaults;
import mc.alk.arena.competition.match.ArenaMatch;
import mc.alk.arena.controllers.containers.AbstractAreaContainer;
import mc.alk.arena.events.players.ArenaPlayerTeleportEvent;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.LocationType;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.PlayerUtil;
import mc.alk.arena.util.Util;
import org.bukkit.Material;
import org.bukkit.event.player.PlayerInteractEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaContainer
extends AbstractAreaContainer {
    Map<UUID, Integer> respawnTimer = null;
    final LocationType type;

    public AreaContainer(String name, LocationType type) {
        super(name);
        this.type = type;
    }

    public AreaContainer(String name, MatchParams params, LocationType type) {
        super(name);
        this.setParams(params);
        this.type = type;
    }

    @Override
    public LocationType getLocationType() {
        return LocationType.LOBBY;
    }

    public void cancel() {
        this.players.clear();
    }

    public Collection<UUID> getInsidePlayers() {
        return this.players;
    }

    @Override
    public ArenaTeam getTeam(ArenaPlayer player) {
        return player.getTeam();
    }

    @ArenaEventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelled() || event.getClickedBlock() == null) {
            return;
        }
        if (event.getClickedBlock().getType().equals((Object)Material.SIGN_POST) || event.getClickedBlock().getType().equals((Object)Material.WALL_SIGN)) {
            ArenaMatch.signClick(event, this);
        } else if (event.getClickedBlock().getType().equals((Object)Defaults.READY_BLOCK)) {
            if (this.respawnTimer == null) {
                this.respawnTimer = new HashMap<UUID, Integer>();
            }
            if (this.respawnTimer.containsKey(PlayerUtil.getID(event.getPlayer()))) {
                ArenaMatch.respawnClick(event, this, this.respawnTimer);
            }
        }
    }

    public boolean hasSpawns() {
        return !this.spawns.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPlayer(ArenaPlayer player) {
        boolean added = false;
        AreaContainer areaContainer = this;
        synchronized (areaContainer) {
            if (this.players.add(player.getID())) {
                added = true;
            }
        }
        if (added) {
            this.updateBukkitEvents(MatchState.ONENTER, player);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePlayer(ArenaPlayer player) {
        boolean removed = false;
        AreaContainer areaContainer = this;
        synchronized (areaContainer) {
            if (this.players.remove(player.getID())) {
                removed = true;
            }
        }
        if (removed) {
            this.updateBukkitEvents(MatchState.ONLEAVE, player);
        }
        return removed;
    }

    @Override
    public void onPreJoin(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        this.onPostEnter(player, apte);
    }

    @Override
    public void onPostJoin(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        this.addPlayer(player);
    }

    @Override
    public void onPreQuit(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPostQuit(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPreEnter(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPostEnter(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        this.addPlayer(player);
    }

    @Override
    public void onPreLeave(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        this.removePlayer(player);
    }

    @Override
    public void onPostLeave(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    public String getSpawnLocationString() {
        StringBuilder sb = new StringBuilder();
        List<List<SpawnLocation>> locs = this.getSpawns();
        for (int i = 0; i < locs.size(); ++i) {
            if (locs.get(i) == null) continue;
            for (SpawnLocation loc : locs.get(i)) {
                sb.append("[").append(i + 1).append(":").append(Util.getLocString(loc)).append("] ");
            }
        }
        return sb.toString();
    }
}

