/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.containers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.competition.TransitionController;
import mc.alk.arena.controllers.PlayerStoreController;
import mc.alk.arena.controllers.plugins.EssentialsController;
import mc.alk.arena.events.BAEvent;
import mc.alk.arena.events.players.ArenaPlayerEnterMatchEvent;
import mc.alk.arena.events.players.ArenaPlayerLeaveEvent;
import mc.alk.arena.events.players.ArenaPlayerLeaveMatchEvent;
import mc.alk.arena.events.players.ArenaPlayerTeleportEvent;
import mc.alk.arena.listeners.BAPlayerListener;
import mc.alk.arena.listeners.PlayerHolder;
import mc.alk.arena.listeners.custom.MethodController;
import mc.alk.arena.objects.ArenaLocation;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.LocationType;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.arenas.ArenaType;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.events.EventPriority;
import mc.alk.arena.objects.options.StateOptions;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.PlayerUtil;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class GameManager
implements PlayerHolder {
    static final HashMap<ArenaType, GameManager> map = new HashMap();
    final MatchParams params;
    final Set<ArenaPlayer> handled = new HashSet<ArenaPlayer>();
    MethodController methodController;

    public static GameManager getGameManager(MatchParams mp) {
        if (map.containsKey(mp.getType())) {
            return map.get(mp.getType());
        }
        GameManager gm = new GameManager(mp);
        map.put(mp.getType(), gm);
        return gm;
    }

    protected void updateBukkitEvents(MatchState matchState, ArenaPlayer player) {
        this.methodController.updateEvents(matchState, player);
    }

    private GameManager(MatchParams params) {
        this.params = params;
        this.methodController = new MethodController("GM " + params.getName());
        this.methodController.addAllEvents(this);
        if (Defaults.TESTSERVER) {
            Log.info("GameManager Testing");
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BattleArena.getSelf());
    }

    public void addArenaListener(ArenaListener arenaListener) {
        this.methodController.addListener(arenaListener);
    }

    public boolean removeArenaListener(ArenaListener arenaListener) {
        return this.methodController.removeListener(arenaListener);
    }

    @ArenaEventHandler(priority=EventPriority.HIGHEST)
    public void onArenaPlayerLeaveEvent(ArenaPlayerLeaveEvent event) {
        if (this.handled.contains(event.getPlayer()) && !event.isHandledQuit()) {
            ArenaPlayer player = event.getPlayer();
            ArenaTeam t = this.getTeam(player);
            TransitionController.transition((PlayerHolder)this, (CompetitionState)MatchState.ONCANCEL, player, t, false);
        }
    }

    private void quitting(ArenaPlayer player) {
        if (this.handled.remove(player)) {
            TransitionController.transition((PlayerHolder)this, (CompetitionState)MatchState.ONLEAVE, player, null, false);
            this.updateBukkitEvents(MatchState.ONLEAVE, player);
            player.reset();
        }
    }

    private void cancel() {
        ArrayList<ArenaPlayer> col = new ArrayList<ArenaPlayer>(this.handled);
        for (ArenaPlayer player : col) {
            ArenaTeam t = this.getTeam(player);
            TransitionController.transition((PlayerHolder)this, (CompetitionState)MatchState.ONCANCEL, player, t, false);
        }
    }

    public MatchParams getParams() {
        return this.params;
    }

    public CompetitionState getState() {
        return MatchState.NONE;
    }

    public MatchState getMatchState() {
        return MatchState.NONE;
    }

    public boolean isHandled(ArenaPlayer player) {
        return this.handled.contains(player);
    }

    public boolean checkReady(ArenaPlayer player, ArenaTeam team, StateOptions mo, boolean b) {
        return false;
    }

    public void callEvent(BAEvent event) {
        this.methodController.callEvent(event);
    }

    public SpawnLocation getSpawn(int index, boolean random) {
        return null;
    }

    public LocationType getLocationType() {
        return null;
    }

    public ArenaTeam getTeam(ArenaPlayer player) {
        return null;
    }

    public void onPreJoin(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        if (this.handled.add(player)) {
            PlayerStoreController.getPlayerStoreController().storeScoreboard(player);
            TransitionController.transition((PlayerHolder)this, (CompetitionState)MatchState.ONENTER, player, null, false);
            this.updateBukkitEvents(MatchState.ONENTER, player);
            if (EssentialsController.enabled()) {
                BAPlayerListener.setBackLocation(player, EssentialsController.getBackLocation(player.getName()));
            }
            PlayerUtil.setGameMode(player.getPlayer(), GameMode.SURVIVAL);
            EssentialsController.setGod(player.getPlayer(), false);
            this.callEvent(new ArenaPlayerEnterMatchEvent(player, player.getTeam()));
        }
    }

    public void onPostJoin(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        player.getMetaData().setJoining(false);
    }

    public void onPreQuit(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    public void onPostQuit(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        this.quitting(player);
        this.callEvent(new ArenaPlayerLeaveMatchEvent(player, player.getTeam()));
        if (EssentialsController.enabled()) {
            BAPlayerListener.setBackLocation(player, null);
        }
        PlayerStoreController.getPlayerStoreController().restoreScoreboard(player);
    }

    public void onPreEnter(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    public void onPostEnter(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    public void onPreLeave(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    public void onPostLeave(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    public boolean hasOption(StateOption option) {
        return this.params.hasOptionAt(this.getState(), option);
    }

    public boolean hasPlayer(ArenaPlayer player) {
        return this.handled.contains(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelAll() {
        HashMap<ArenaType, GameManager> hashMap = map;
        synchronized (hashMap) {
            for (GameManager gm : map.values()) {
                gm.cancel();
            }
        }
    }

    public void setTeleportTime(ArenaPlayer player, ArenaLocation location) {
    }
}

