/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.containers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import mc.alk.arena.controllers.containers.RoomContainer;
import mc.alk.arena.events.players.ArenaPlayerTeleportEvent;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.LocationType;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.arenas.Arena;

public class LobbyContainer
extends RoomContainer {
    Map<ArenaPlayer, Arena> votedFor = new HashMap<ArenaPlayer, Arena>();
    Map<Arena, Integer> arenaVotes = new ConcurrentHashMap<Arena, Integer>();
    Set<ArenaPlayer> waitingForMatch = new HashSet<ArenaPlayer>();

    public LobbyContainer(String name, LocationType type) {
        super(name, type);
    }

    public LobbyContainer(String name, MatchParams params, LocationType type) {
        super(name, params, type);
    }

    public void castVote(ArenaPlayer ap, MatchParams mp, Arena arena) {
        if (!this.waitingForMatch.contains(ap)) {
            return;
        }
        Arena a = this.votedFor.remove(ap);
        if (a != null) {
            this.decrementVote(a);
        }
        Integer nVotes = this.incrementVote(arena);
    }

    private Integer incrementVote(Arena arena) {
        Integer count = this.arenaVotes.get(arena);
        if (count == null) {
            count = 1;
            this.arenaVotes.put(arena, count);
        } else {
            count = count + 1;
            this.arenaVotes.put(arena, count);
        }
        return count;
    }

    private void decrementVote(Arena arena) {
        Integer count = this.arenaVotes.get(arena);
        if (count != null) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count - 1);
            this.arenaVotes.put(arena, count);
        }
    }

    public void onPostEnter(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        super.onPostEnter(player, apte);
        if (apte.getSrcType() == LocationType.HOME) {
            this.waitingForMatch.add(player);
        }
    }

    public void onPostLeave(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        super.onPostLeave(player, apte);
        this.waitingForMatch.remove(player);
    }
}

