/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.joining;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import mc.alk.arena.Defaults;
import mc.alk.arena.competition.Competition;
import mc.alk.arena.controllers.joining.scoreboard.CutoffScoreboard;
import mc.alk.arena.controllers.joining.scoreboard.FullScoreboard;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.joining.JoinHandler;
import mc.alk.arena.objects.joining.TeamJoinObject;
import mc.alk.arena.objects.scoreboard.WaitingScoreboard;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.teams.TeamFactory;
import mc.alk.arena.objects.teams.TeamHandler;
import mc.alk.arena.util.Log;
import mc.alk.scoreboardapi.api.SAPI;
import mc.alk.scoreboardapi.api.SAPIFactory;
import mc.alk.scoreboardapi.api.SScoreboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJoinHandler
implements JoinHandler,
TeamHandler {
    public static final TeamJoinResult CANTFIT = new TeamJoinResult(TeamJoinStatus.CANT_FIT, -1, null);
    final MatchParams matchParams;
    final List<ArenaTeam> teams = new CopyOnWriteArrayList<ArenaTeam>();
    final int minTeams;
    final int maxTeams;
    Competition competition;
    WaitingScoreboard scoreboard;
    int nPlayers;

    public Collection<ArenaPlayer> getPlayers() {
        ArrayList<ArenaPlayer> players = new ArrayList<ArenaPlayer>();
        for (ArenaTeam at : this.teams) {
            players.addAll(at.getPlayers());
        }
        return players;
    }

    public void joiningPlayer(ArenaPlayer player) {
        ArenaTeam ct = TeamFactory.createCompositeTeam(this.teams.size(), this.matchParams);
        this.addTeam(ct);
        ct.addPlayer(player);
        this.addToTeam(ct, player);
    }

    public void useWaitingScoreboard() {
        if (this.scoreboard == null) {
            return;
        }
        for (ArenaTeam at : this.teams) {
            for (ArenaPlayer ap : at.getPlayers()) {
                this.scoreboard.getScoreboard().setScoreboard(ap.getPlayer());
            }
        }
    }

    public void setWaitingScoreboardTime(int seconds) {
        if (this.scoreboard == null) {
            return;
        }
        this.scoreboard.setRemainingSeconds(seconds);
    }

    public AbstractJoinHandler(MatchParams params, Competition competition) {
        this.matchParams = params;
        this.minTeams = params.getMinTeams();
        this.maxTeams = params.getMaxTeams();
        this.setCompetition(competition);
        if (Defaults.USE_SCOREBOARD && SAPI.hasBukkitScoreboard()) {
            this.initWaitingScoreboard();
        }
    }

    private void initWaitingScoreboard() {
        ArrayList<ArenaTeam> teams = new ArrayList<ArenaTeam>();
        try {
            if (this.maxTeams <= 16) {
                int needed = 0;
                int optional = 0;
                for (int i = 0; i < this.maxTeams; ++i) {
                    ArenaTeam team = TeamFactory.createCompositeTeam(i, this.matchParams);
                    if (team.getMinPlayers() < 16) {
                        needed += team.getMinPlayers();
                        if (team.getMinPlayers() != team.getMaxPlayers()) {
                            optional += team.getMaxPlayers() < 1000 ? team.getMaxPlayers() - team.getMinPlayers() : 1000;
                        }
                    }
                    teams.add(team);
                }
                if (needed + optional <= 16) {
                    this.scoreboard = new FullScoreboard(this.matchParams, teams);
                    return;
                }
            }
        }
        catch (Throwable e) {
            Log.printStackTrace(e);
        }
        this.scoreboard = new CutoffScoreboard(this.matchParams, teams);
    }

    public abstract boolean switchTeams(ArenaPlayer var1, Integer var2, boolean var3);

    public void setCompetition(Competition comp) {
        this.competition = comp;
    }

    public void transferOldScoreboards(SScoreboard newScoreboard) {
        if (this.scoreboard == null) {
            return;
        }
        SAPIFactory.transferOldScoreboards(this.scoreboard.getScoreboard() != null ? this.scoreboard.getScoreboard().getBScoreboard() : this.scoreboard.getScoreboard(), newScoreboard);
    }

    protected ArenaTeam addToPreviouslyLeftTeam(ArenaPlayer player) {
        for (ArenaTeam t : this.teams) {
            if (!t.hasLeft(player)) continue;
            t.addPlayer(player);
            ++this.nPlayers;
            if (this.competition != null) {
                this.competition.addedToTeam(t, player);
            }
            if (this.scoreboard != null) {
                this.scoreboard.addedToTeam(t, player);
            }
            return t;
        }
        return null;
    }

    @Override
    public void addToTeam(ArenaTeam team, Collection<ArenaPlayer> players) {
        team.addPlayers(players);
        for (ArenaPlayer ap : players) {
            ap.setTeam(team);
        }
        this.nPlayers += players.size();
        if (this.competition != null) {
            this.competition.addedToTeam(team, players);
        }
        if (this.scoreboard != null) {
            this.scoreboard.addedToTeam(team, players);
        }
    }

    @Override
    public boolean addToTeam(ArenaTeam team, ArenaPlayer player) {
        team.addPlayer(player);
        player.setTeam(team);
        ++this.nPlayers;
        if (this.competition != null) {
            this.competition.addedToTeam(team, player);
        }
        if (this.scoreboard != null) {
            this.scoreboard.addedToTeam(team, player);
        }
        return true;
    }

    @Override
    public boolean removeFromTeam(ArenaTeam team, ArenaPlayer player) {
        team.removePlayer(player);
        player.setTeam(null);
        --this.nPlayers;
        if (this.competition != null) {
            this.competition.removedFromTeam(team, player);
        }
        if (this.scoreboard != null) {
            this.scoreboard.removedFromTeam(team, player);
        }
        return true;
    }

    @Override
    public void removeFromTeam(ArenaTeam team, Collection<ArenaPlayer> players) {
        for (ArenaPlayer ap : players) {
            this.removeFromTeam(team, ap);
        }
    }

    @Override
    public boolean removeTeam(ArenaTeam team) {
        return true;
    }

    @Override
    public boolean addTeam(ArenaTeam team) {
        this.nPlayers += team.size();
        team.setIndex(this.teams.size());
        this.teams.add(team);
        if (this.competition != null) {
            this.competition.addedTeam(team);
        }
        if (this.scoreboard != null) {
            this.scoreboard.addedTeam(team);
        }
        return true;
    }

    public abstract TeamJoinResult joiningTeam(TeamJoinObject var1);

    @Override
    public boolean canLeave(ArenaPlayer p) {
        return true;
    }

    @Override
    public boolean leave(ArenaPlayer p) {
        for (ArenaTeam t : this.teams) {
            if (!t.hasMember(p)) continue;
            --this.nPlayers;
            t.removePlayer(p);
            if (this.competition != null) {
                this.competition.removedFromTeam(t, p);
            }
            if (this.scoreboard != null) {
                this.scoreboard.removedFromTeam(t, p);
            }
            return true;
        }
        return false;
    }

    public Set<ArenaPlayer> getExcludedPlayers() {
        HashSet<ArenaPlayer> tplayers = new HashSet<ArenaPlayer>();
        for (ArenaTeam t : this.teams) {
            if (t.size() >= t.getMinPlayers()) continue;
            tplayers.addAll(t.getPlayers());
        }
        return tplayers;
    }

    public List<ArenaTeam> removeImproperTeams() {
        ArrayList<ArenaTeam> improper = new ArrayList<ArenaTeam>();
        for (ArenaTeam t : this.teams) {
            if (t.size() >= t.getMinPlayers() && t.size() <= t.getMaxPlayers()) continue;
            improper.add(t);
            this.nPlayers -= t.size();
        }
        this.teams.removeAll(improper);
        return improper;
    }

    public boolean hasEnough(int allowedTeamSizeDifference) {
        int teamssize = this.teams.size();
        if (teamssize < this.minTeams) {
            return false;
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int valid = 0;
        for (ArenaTeam t : this.teams) {
            int tsize = t.size();
            if (tsize == 0) continue;
            if (tsize < min) {
                min = tsize;
            }
            if (tsize > max) {
                max = tsize;
            }
            if (max - min > allowedTeamSizeDifference) {
                return false;
            }
            if (tsize < t.getMinPlayers() || tsize > t.getMaxPlayers()) continue;
            ++valid;
        }
        return valid >= this.minTeams && valid <= this.maxTeams;
    }

    public boolean isFull() {
        if (this.maxTeams == Integer.MAX_VALUE) {
            return false;
        }
        if (this.maxTeams > this.teams.size()) {
            return false;
        }
        for (ArenaTeam t : this.teams) {
            if (t.size() >= t.getMaxPlayers()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        if (this.teams.isEmpty()) {
            return true;
        }
        for (ArenaTeam t : this.teams) {
            if (t.size() == 0) continue;
            return false;
        }
        return true;
    }

    public List<ArenaTeam> getTeams() {
        return this.teams;
    }

    public int getnPlayers() {
        return this.nPlayers;
    }

    public String toString() {
        return "[TJH " + this.hashCode() + "]";
    }

    public static class TeamJoinResult {
        public final TeamJoinStatus status;
        public final int remaining;
        public final ArenaTeam team;

        public TeamJoinResult(TeamJoinStatus status, int remaining, ArenaTeam team) {
            this.status = status;
            this.remaining = remaining;
            this.team = team;
        }

        public TeamJoinStatus getEventType() {
            return this.status;
        }

        public int getRemaining() {
            return this.remaining;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TeamJoinStatus {
        ADDED,
        CANT_FIT,
        ADDED_TO_EXISTING,
        ADDED_STILL_NEEDS_PLAYERS;

    }
}

