/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.joining;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import mc.alk.arena.competition.Competition;
import mc.alk.arena.competition.events.Event;
import mc.alk.arena.controllers.joining.AbstractJoinHandler;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.exceptions.NeverWouldJoinException;
import mc.alk.arena.objects.joining.TeamJoinObject;
import mc.alk.arena.objects.options.JoinOptions;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.teams.TeamFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddToLeastFullTeam
extends AbstractJoinHandler {
    public AddToLeastFullTeam(MatchParams params, Competition competition, Collection<ArenaTeam> newTeams) throws NeverWouldJoinException {
        super(params, competition);
        if (this.minTeams == Integer.MAX_VALUE || this.maxTeams == Integer.MAX_VALUE) {
            throw new NeverWouldJoinException("If you add players by adding them to the next team in the list, there must be a finite number of players");
        }
        if (this.minTeams > 1000) {
            throw new NeverWouldJoinException("You can't make more than 1000 teams");
        }
        if (newTeams != null) {
            for (ArenaTeam at : newTeams) {
                this.addTeam(at);
            }
        }
        for (int i = this.teams.size(); i < this.minTeams; ++i) {
            ArenaTeam team = TeamFactory.createCompositeTeam(i, params);
            this.addTeam(team);
        }
    }

    @Override
    public boolean switchTeams(ArenaPlayer player, Integer toTeamIndex, boolean checkSizes) {
        ArenaTeam oldTeam = player.getTeam();
        if (oldTeam == null || toTeamIndex >= this.maxTeams) {
            return false;
        }
        if (checkSizes) {
            if (oldTeam.size() - 1 < oldTeam.getMinPlayers()) {
                return false;
            }
            ArenaTeam team = this.addToPreviouslyLeftTeam(player);
            if (team != null) {
                return true;
            }
            team = (ArenaTeam)this.teams.get(toTeamIndex);
            if (team.size() + 1 <= team.getMaxPlayers()) {
                this.removeFromTeam(oldTeam, player);
                this.addToTeam(team, player);
                return true;
            }
            return false;
        }
        ArenaTeam team = (ArenaTeam)this.teams.get(toTeamIndex);
        this.removeFromTeam(oldTeam, player);
        this.addToTeam(team, player);
        return true;
    }

    @Override
    public AbstractJoinHandler.TeamJoinResult joiningTeam(TeamJoinObject tqo) {
        ArenaTeam baseTeam;
        AbstractJoinHandler.TeamJoinResult tjr;
        Integer index;
        ArenaTeam oldTeam;
        ArenaTeam team = tqo.getTeam();
        if (team.size() == 1 && (oldTeam = this.addToPreviouslyLeftTeam(team.getPlayers().iterator().next())) != null) {
            team.setIndex(oldTeam.getIndex());
            return new AbstractJoinHandler.TeamJoinResult(AbstractJoinHandler.TeamJoinStatus.ADDED_TO_EXISTING, oldTeam.getMinPlayers() - oldTeam.size(), oldTeam);
        }
        JoinOptions jo = tqo.getJoinOptions();
        if (jo != null && jo.hasOption(JoinOptions.JoinOption.TEAM) && (index = (Integer)jo.getOption(JoinOptions.JoinOption.TEAM)) < this.maxTeams && (tjr = this.teamFits(baseTeam = (ArenaTeam)this.teams.get(index), team)) != CANTFIT) {
            return tjr;
        }
        boolean hasZero = false;
        for (ArenaTeam t : this.teams) {
            if (t.size() != 0) continue;
            hasZero = true;
            break;
        }
        if (!hasZero && this.teams.size() < this.maxTeams) {
            ArenaTeam ct = TeamFactory.createCompositeTeam(this.teams.size(), this.matchParams);
            ct.setCurrentParams(tqo.getMatchParams());
            ct.addPlayers(team.getPlayers());
            team.setIndex(ct.getIndex());
            if (ct.size() <= ct.getMaxPlayers()) {
                this.addTeam(ct);
                if (ct.size() >= ct.getMinPlayers()) {
                    return new AbstractJoinHandler.TeamJoinResult(AbstractJoinHandler.TeamJoinStatus.ADDED, ct.getMinPlayers() - ct.size(), ct);
                }
                return new AbstractJoinHandler.TeamJoinResult(AbstractJoinHandler.TeamJoinStatus.ADDED_STILL_NEEDS_PLAYERS, ct.getMinPlayers() - ct.size(), ct);
            }
        }
        ArrayList sortedBySize = new ArrayList(this.teams);
        Collections.sort(sortedBySize, new Event.TeamSizeComparator());
        for (ArenaTeam baseTeam2 : sortedBySize) {
            AbstractJoinHandler.TeamJoinResult tjr2 = this.teamFits(baseTeam2, team);
            if (tjr2 == CANTFIT) continue;
            return tjr2;
        }
        return CANTFIT;
    }

    private AbstractJoinHandler.TeamJoinResult teamFits(ArenaTeam baseTeam, ArenaTeam team) {
        if (baseTeam.size() + team.size() <= baseTeam.getMaxPlayers()) {
            team.setIndex(baseTeam.getIndex());
            this.addToTeam(baseTeam, team.getPlayers());
            if (baseTeam.size() == 0) {
                return new AbstractJoinHandler.TeamJoinResult(AbstractJoinHandler.TeamJoinStatus.ADDED, baseTeam.getMinPlayers() - baseTeam.size(), baseTeam);
            }
            return new AbstractJoinHandler.TeamJoinResult(AbstractJoinHandler.TeamJoinStatus.ADDED_TO_EXISTING, baseTeam.getMinPlayers() - baseTeam.size(), baseTeam);
        }
        return CANTFIT;
    }

    @Override
    public String toString() {
        return "[" + this.competition.getParams().getName() + ":JH:AddToLeast]";
    }
}

