/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.joining;

import java.util.Collection;
import java.util.Set;
import mc.alk.arena.competition.Competition;
import mc.alk.arena.controllers.joining.AbstractJoinHandler;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.exceptions.NeverWouldJoinException;
import mc.alk.arena.objects.joining.TeamJoinObject;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.teams.TeamFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinPackAdd
extends AbstractJoinHandler {
    boolean full = false;

    public BinPackAdd(MatchParams params, Competition competition, Collection<ArenaTeam> newTeams) throws NeverWouldJoinException {
        super(params, competition);
        if (newTeams != null) {
            for (ArenaTeam at : newTeams) {
                this.addTeam(at);
            }
        }
    }

    @Override
    public boolean switchTeams(ArenaPlayer player, Integer toTeamIndex, boolean checkSizes) {
        ArenaTeam oldTeam = player.getTeam();
        if (oldTeam == null || toTeamIndex >= this.maxTeams) {
            return false;
        }
        if (checkSizes) {
            if (oldTeam.size() - 1 < oldTeam.getMinPlayers()) {
                return false;
            }
            ArenaTeam team = this.addToPreviouslyLeftTeam(player);
            if (team != null) {
                return true;
            }
            team = (ArenaTeam)this.teams.get(toTeamIndex);
            if (team.size() + 1 <= team.getMaxPlayers()) {
                this.removeFromTeam(oldTeam, player);
                this.addToTeam(team, player);
                return true;
            }
            return false;
        }
        ArenaTeam team = (ArenaTeam)this.teams.get(toTeamIndex);
        this.removeFromTeam(oldTeam, player);
        this.addToTeam(team, player);
        return true;
    }

    @Override
    public AbstractJoinHandler.TeamJoinResult joiningTeam(TeamJoinObject tqo) {
        ArenaTeam oldTeam;
        ArenaTeam team = tqo.getTeam();
        if (team.size() == 1 && (oldTeam = this.addToPreviouslyLeftTeam(team.getPlayers().iterator().next())) != null) {
            team.setIndex(oldTeam.getIndex());
            return new AbstractJoinHandler.TeamJoinResult(AbstractJoinHandler.TeamJoinStatus.ADDED_TO_EXISTING, oldTeam.getMinPlayers() - oldTeam.size(), oldTeam);
        }
        if (this.teams.size() < this.maxTeams) {
            Set<ArenaPlayer> players = team.getPlayers();
            for (ArenaTeam t : this.teams) {
                if (t.size() != 0 || players.size() != t.getMaxPlayers()) continue;
                this.addToTeam(t, players);
                return new AbstractJoinHandler.TeamJoinResult(AbstractJoinHandler.TeamJoinStatus.ADDED_TO_EXISTING, t.getMinPlayers() - t.size(), t);
            }
            ArenaTeam ct = TeamFactory.createCompositeTeam(this.teams.size(), this.matchParams);
            ct.addPlayers(team.getPlayers());
            team.setIndex(ct.getIndex());
            if (ct.size() <= ct.getMaxPlayers()) {
                this.addTeam(ct);
                if (ct.size() >= ct.getMinPlayers()) {
                    return new AbstractJoinHandler.TeamJoinResult(AbstractJoinHandler.TeamJoinStatus.ADDED, ct.getMinPlayers() - ct.size(), ct);
                }
                return new AbstractJoinHandler.TeamJoinResult(AbstractJoinHandler.TeamJoinStatus.ADDED_STILL_NEEDS_PLAYERS, ct.getMinPlayers() - ct.size(), ct);
            }
        }
        for (ArenaTeam t : this.teams) {
            int size = t.size() + team.size();
            if (size > t.getMaxPlayers()) continue;
            t.addPlayers(team.getPlayers());
            if (size >= t.getMinPlayers()) {
                team.setIndex(t.getIndex());
                this.addToTeam(t, team.getPlayers());
                return new AbstractJoinHandler.TeamJoinResult(AbstractJoinHandler.TeamJoinStatus.ADDED, 0, t);
            }
            return new AbstractJoinHandler.TeamJoinResult(AbstractJoinHandler.TeamJoinStatus.ADDED_STILL_NEEDS_PLAYERS, t.getMinPlayers() - t.size(), t);
        }
        return CANTFIT;
    }

    @Override
    public String toString() {
        return (this.competition == null ? " null" : "[" + this.competition.getParams().getName()) + ":JH:BinPackAdd]";
    }
}

