/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.joining;

import java.util.Collection;
import mc.alk.arena.competition.Competition;
import mc.alk.arena.controllers.joining.AbstractJoinHandler;
import mc.alk.arena.controllers.joining.AddToLeastFullTeam;
import mc.alk.arena.controllers.joining.BinPackAdd;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.exceptions.NeverWouldJoinException;
import mc.alk.arena.objects.teams.ArenaTeam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamJoinFactory {
    public static AbstractJoinHandler createTeamJoinHandler(MatchParams params) throws NeverWouldJoinException {
        return TeamJoinFactory.createTeamJoinHandler(params, null, null);
    }

    public static AbstractJoinHandler createTeamJoinHandler(MatchParams params, Competition competition) throws NeverWouldJoinException {
        return TeamJoinFactory.createTeamJoinHandler(params, competition, null);
    }

    public static AbstractJoinHandler createTeamJoinHandler(MatchParams params, Collection<ArenaTeam> teams) throws NeverWouldJoinException {
        AbstractJoinHandler as = TeamJoinFactory.createTeamJoinHandler(params, null, teams);
        return as;
    }

    public static AbstractJoinHandler createTeamJoinHandler(MatchParams params, Competition competition, Collection<ArenaTeam> teams) throws NeverWouldJoinException {
        if (params.getMaxTeams() <= 1000) {
            return new AddToLeastFullTeam(params, competition, teams);
        }
        return new BinPackAdd(params, competition, teams);
    }
}

