/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.joining.scoreboard;

import java.util.Collection;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.scoreboard.ArenaObjective;
import mc.alk.arena.objects.scoreboard.ArenaScoreboard;
import mc.alk.arena.objects.scoreboard.ScoreboardFactory;
import mc.alk.arena.objects.scoreboard.WaitingScoreboard;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.scoreboardapi.api.STeam;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbridgedScoreboard
implements WaitingScoreboard {
    final ArenaScoreboard scoreboard;
    final ArenaObjective ao;

    public AbridgedScoreboard(MatchParams params) {
        this.scoreboard = ScoreboardFactory.createScoreboard(String.valueOf(this.hashCode()), params);
        this.ao = this.scoreboard.createObjective("waiting", "Queue Players", "&6Waiting Players", SAPIDisplaySlot.SIDEBAR, 100);
        this.ao.setDisplayPlayers(false);
    }

    @Override
    public void addedToTeam(ArenaTeam team, ArenaPlayer player) {
        STeam t = this.scoreboard.addedToTeam(team, player);
        this.scoreboard.setScoreboard(player.getPlayer());
        this.setTeamSuffix(team, t);
        this.ao.setTeamPoints(t, team.size());
    }

    @Override
    public void addedToTeam(ArenaTeam team, Collection<ArenaPlayer> players) {
        STeam t = this.scoreboard.getTeam(team.getIDString());
        for (ArenaPlayer player : players) {
            this.scoreboard.addedToTeam(team, player);
            this.scoreboard.setScoreboard(player.getPlayer());
            this.setTeamSuffix(team, t);
        }
        this.ao.setTeamPoints(t, team.size());
    }

    @Override
    public void removedFromTeam(ArenaTeam team, ArenaPlayer player) {
        STeam t = this.scoreboard.getTeam(team.getIDString());
        this.scoreboard.removedFromTeam(team, player);
        this.setTeamSuffix(team, t);
        this.ao.setTeamPoints(t, team.size());
    }

    @Override
    public void removedFromTeam(ArenaTeam team, Collection<ArenaPlayer> players) {
        STeam t = this.scoreboard.getTeam(team.getIDString());
        for (ArenaPlayer player : players) {
            this.scoreboard.removedFromTeam(team, player);
            this.setTeamSuffix(team, t);
        }
        this.ao.setTeamPoints(t, team.size());
    }

    private void setTeamSuffix(ArenaTeam team, STeam t) {
        String s = team.getMinPlayers() == team.getMaxPlayers() ? " " + team.size() + "/" + team.getMinPlayers() : " " + team.size() + "/" + team.getMinPlayers() + "/" + team.getMaxPlayers();
        this.scoreboard.setEntryNameSuffix(t, s);
    }

    @Override
    public boolean addedTeam(ArenaTeam team) {
        STeam t = this.scoreboard.addTeam(team);
        this.setTeamSuffix(team, t);
        return true;
    }

    @Override
    public boolean removedTeam(ArenaTeam team) {
        STeam t = this.scoreboard.getTeam(team.getIDString());
        this.scoreboard.removeEntry(t);
        return false;
    }

    @Override
    public ArenaScoreboard getScoreboard() {
        return this.scoreboard;
    }

    @Override
    public void setRemainingSeconds(int seconds) {
    }
}

