/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.joining.scoreboard;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mc.alk.arena.BattleArena;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.scoreboard.ArenaObjective;
import mc.alk.arena.objects.scoreboard.ArenaScoreboard;
import mc.alk.arena.objects.scoreboard.ScoreboardFactory;
import mc.alk.arena.objects.scoreboard.WaitingScoreboard;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.teams.TeamFactory;
import mc.alk.arena.util.Countdown;
import mc.alk.arena.util.TeamUtil;
import mc.alk.scoreboardapi.api.SEntry;
import mc.alk.scoreboardapi.api.STeam;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullScoreboard
implements WaitingScoreboard {
    Map<Integer, LinkedList<SEntry>> reqPlaceHolderPlayers = new HashMap<Integer, LinkedList<SEntry>>();
    Map<Integer, LinkedList<SEntry>> opPlaceHolderPlayers = new HashMap<Integer, LinkedList<SEntry>>();
    ArenaScoreboard scoreboard;
    ArenaObjective ao;
    final int minTeams;
    Countdown countdown;

    public FullScoreboard(MatchParams params, List<ArenaTeam> teams) {
        this.scoreboard = ScoreboardFactory.createScoreboard(String.valueOf(this.hashCode()), params);
        this.ao = this.scoreboard.createObjective("waiting", "Queue Players", "&6Waiting Players", SAPIDisplaySlot.SIDEBAR, 100);
        this.ao.setDisplayTeams(false);
        this.minTeams = params.getMinTeams();
        int maxTeams = params.getMaxTeams();
        for (int i = 0; i < maxTeams; ++i) {
            ArenaTeam team = i < teams.size() ? teams.get(i) : TeamFactory.createCompositeTeam(i, params);
            team.setIDString(String.valueOf(team.getIndex()));
            STeam t = this.scoreboard.addTeam(team);
            for (int j = 0; j < team.getMaxPlayers(); ++j) {
                this.addPlaceholder(team, t, i >= this.minTeams);
            }
        }
        if (params.getForceStartTime() > 0 && params.getForceStartTime() != Integer.MAX_VALUE && !params.getMaxPlayers().equals(params.getMinPlayers())) {
            this.countdown = new Countdown((Plugin)BattleArena.getSelf(), params.getForceStartTime(), 1, (Countdown.CountdownCallback)new DisplayCountdown());
        }
    }

    private int getReqSize(int teamIndex) {
        return this.reqPlaceHolderPlayers.containsKey(teamIndex) ? this.reqPlaceHolderPlayers.get(teamIndex).size() : 0;
    }

    private void addPlaceholder(ArenaTeam team, STeam t, boolean optionalTeam) {
        int index;
        int points;
        String name;
        LinkedList<SEntry> r;
        if (!optionalTeam && this.getReqSize(team.getIndex()) < team.getMinPlayers()) {
            r = this.reqPlaceHolderPlayers.get(team.getIndex());
            if (r == null) {
                r = new LinkedList();
                this.reqPlaceHolderPlayers.put(team.getIndex(), r);
            }
            name = "needed";
            points = 1;
            index = r.size();
        } else {
            r = this.opPlaceHolderPlayers.get(team.getIndex());
            if (r == null) {
                r = new LinkedList();
                this.opPlaceHolderPlayers.put(team.getIndex(), r);
            }
            name = "open";
            points = 0;
            index = optionalTeam ? r.size() : team.getMinPlayers() + r.size();
        }
        String dis = "- " + name + " -" + team.getTeamChatColor() + TeamUtil.getTeamChatColor(index);
        SEntry e = this.scoreboard.getEntry(dis);
        if (e == null) {
            e = this.scoreboard.createEntry(Bukkit.getOfflinePlayer((String)dis), dis);
            this.ao.addEntry(e, points);
        } else {
            this.ao.setPoints(e, points);
        }
        r.addLast(e);
        t.addPlayer(e.getOfflinePlayer());
    }

    private void removePlaceHolder(int teamIndex) {
        LinkedList<SEntry> list = this.reqPlaceHolderPlayers.get(teamIndex);
        if (list == null || list.isEmpty()) {
            list = this.opPlaceHolderPlayers.get(teamIndex);
        }
        if (list == null || list.isEmpty()) {
            return;
        }
        SEntry e = list.removeLast();
        this.scoreboard.removeEntry(e);
    }

    @Override
    public void addedToTeam(ArenaTeam team, ArenaPlayer player) {
        this.removePlaceHolder(team.getIndex());
        STeam t = this.scoreboard.getTeam(String.valueOf(team.getIndex()));
        this.scoreboard.addedToTeam(t, player);
        this.ao.setPoints(player, 10);
    }

    @Override
    public void addedToTeam(ArenaTeam team, Collection<ArenaPlayer> players) {
        for (ArenaPlayer player : players) {
            this.addedToTeam(team, player);
        }
    }

    @Override
    public void removedFromTeam(ArenaTeam team, ArenaPlayer player) {
        STeam t = this.scoreboard.getTeam(String.valueOf(team.getIndex()));
        this.scoreboard.removedFromTeam(t, player);
        this.addPlaceholder(team, t, team.getIndex() >= this.minTeams);
    }

    @Override
    public void removedFromTeam(ArenaTeam team, Collection<ArenaPlayer> players) {
        STeam t = this.scoreboard.getTeam(String.valueOf(team.getIndex()));
        for (ArenaPlayer player : players) {
            this.scoreboard.removedFromTeam(team, player);
            this.addPlaceholder(team, t, team.getIndex() >= this.minTeams);
        }
    }

    @Override
    public boolean addedTeam(ArenaTeam team) {
        this.scoreboard.createTeamEntry(String.valueOf(team.getIndex()), "");
        for (ArenaPlayer ap : team.getPlayers()) {
            this.addedToTeam(team, ap);
        }
        return true;
    }

    @Override
    public boolean removedTeam(ArenaTeam team) {
        STeam t = this.scoreboard.getTeam(String.valueOf(team.getIndex()));
        this.scoreboard.removeEntry(t);
        return false;
    }

    @Override
    public ArenaScoreboard getScoreboard() {
        return this.scoreboard;
    }

    @Override
    public void setRemainingSeconds(int seconds) {
        if (this.countdown != null) {
            this.countdown.stop();
        }
        this.countdown = new Countdown((Plugin)BattleArena.getSelf(), seconds, 1, (Countdown.CountdownCallback)new DisplayCountdown());
    }

    class DisplayCountdown
    implements Countdown.CountdownCallback {
        DisplayCountdown() {
        }

        public boolean intervalTick(int secondsRemaining) {
            if (secondsRemaining == 0) {
                FullScoreboard.this.ao.setDisplayNameSuffix("");
            } else {
                FullScoreboard.this.ao.setDisplayNameSuffix(" &e(" + secondsRemaining + ")");
            }
            return true;
        }
    }
}

