/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.messaging;

import java.util.Collection;
import java.util.Set;
import mc.alk.arena.competition.events.Event;
import mc.alk.arena.controllers.messaging.MessageFormatter;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.messaging.Channel;
import mc.alk.arena.objects.messaging.Channels;
import mc.alk.arena.objects.messaging.EventMessageHandler;
import mc.alk.arena.objects.messaging.Message;
import mc.alk.arena.objects.messaging.MessageOptions;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.serializers.MessageSerializer;
import mc.alk.arena.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventMessageImpl
extends MessageSerializer
implements EventMessageHandler {
    final MatchParams mp;
    final Event event;

    public EventMessageImpl(Event e) {
        super(e.getParams().getName(), e.getParams());
        this.mp = e.getParams();
        this.event = e;
    }

    @Override
    public void sendCountdownTillEvent(Channel serverChannel, int seconds) {
        Message message = this.getNodeMessage("event.countdownTillEvent");
        Message serverMessage = this.getNodeMessage("event.server_countdownTillEvent");
        Set<MessageOptions.MessageOption> ops = message.getOptions();
        if (serverChannel != Channels.NullChannel) {
            ops.addAll(serverMessage.getOptions());
        }
        MessageFormatter msgf = new MessageFormatter(this, this.event.getParams(), 0, message, ops);
        msgf.formatCommonOptions(null, seconds);
        if (serverChannel != Channels.NullChannel) {
            String msg = msgf.getFormattedMessage(serverMessage);
            serverChannel.broadcast(msg);
        }
    }

    @Override
    public void sendEventStarting(Channel serverChannel, Collection<ArenaTeam> teams) {
        String nTeamPath = EventMessageImpl.getStringPathFromSize(teams.size());
        Message message = this.getNodeMessage("event." + nTeamPath + ".start");
        Message serverMessage = this.getNodeMessage("event." + nTeamPath + ".server_start");
        this.formatAndSend(serverChannel, teams, message, serverMessage);
    }

    @Override
    public void sendEventVictory(Channel serverChannel, Collection<ArenaTeam> victors, Collection<ArenaTeam> losers) {
        String nTeamPath = EventMessageImpl.getStringPathFromSize(losers.size() + 1);
        this.sendVictory(serverChannel, victors, losers, this.mp, "event." + nTeamPath + ".victory", "event." + nTeamPath + ".loss", "event." + nTeamPath + ".server_victory");
    }

    @Override
    public void sendEventOpenMsg(Channel serverChannel) {
        if (serverChannel == Channels.NullChannel) {
            return;
        }
        String nTeamPath = EventMessageImpl.getStringPathFromSize(this.mp.getMinTeams());
        Message serverMessage = this.mp.getMinTeamSize() > 1 ? this.getNodeMessage("event." + nTeamPath + ".server_open_teamSizeGreaterThanOne") : this.getNodeMessage("event." + nTeamPath + ".server_open");
        Set<MessageOptions.MessageOption> ops = serverMessage.getOptions();
        MessageFormatter msgf = new MessageFormatter(this, this.event.getParams(), 0, serverMessage, ops);
        msgf.formatCommonOptions(null);
        String msg = msgf.getFormattedMessage(serverMessage);
        serverChannel.broadcast(msg);
    }

    @Override
    public void sendEventCancelledDueToLackOfPlayers(Channel serverChannel, Set<ArenaPlayer> competingPlayers) {
        MessageUtil.sendMessage(competingPlayers, this.mp.getPrefix() + "&e The Event has been cancelled b/c there weren't enough players");
    }

    @Override
    public void sendEventCancelled(Channel serverChannel, Collection<ArenaTeam> teams) {
        Message message = this.getNodeMessage("event.team_cancelled");
        Message serverMessage = this.getNodeMessage("event.server_cancelled");
        this.formatAndSend(serverChannel, teams, message, serverMessage);
    }

    private void formatAndSend(Channel serverChannel, Collection<ArenaTeam> teams, Message message, Message serverMessage) {
        Set<MessageOptions.MessageOption> ops = message.getOptions();
        if (serverChannel != Channels.NullChannel) {
            ops.addAll(serverMessage.getOptions());
        }
        MessageFormatter msgf = new MessageFormatter(this, this.mp, teams.size(), message, ops);
        msgf.formatCommonOptions(teams);
        for (ArenaTeam t : teams) {
            msgf.formatTeamOptions(t, false);
            msgf.formatTeams(teams);
            String newmsg = msgf.getFormattedMessage(message);
            t.sendMessage(newmsg);
        }
        if (serverChannel != Channels.NullChannel) {
            String msg = msgf.getFormattedMessage(serverMessage);
            serverChannel.broadcast(msg);
        }
    }

    @Override
    public void sendCantFitTeam(ArenaTeam t) {
        t.sendMessage("&cThe &6" + this.event.getDisplayName() + "&c is full");
    }

    @Override
    public void sendWaitingForMorePlayers(ArenaTeam team, int remaining) {
        team.sendMessage("&eYou have joined the &6" + this.event.getDisplayName());
        team.sendMessage("&eYou will enter the Event when &6" + remaining + "&e more " + MessageUtil.playerOrPlayers(remaining) + "&e have joined to make your team");
    }

    @Override
    public void sendEventDraw(Channel serverChannel, Collection<ArenaTeam> participants, Collection<ArenaTeam> losers) {
        String nTeamPath = EventMessageImpl.getStringPathFromSize(participants.size());
        this.sendVictory(serverChannel, null, participants, this.mp, "event." + nTeamPath + ".draw", "event." + nTeamPath + ".draw", "event." + nTeamPath + ".server_draw");
    }
}

