/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.messaging;

import java.util.Collection;
import java.util.Set;
import mc.alk.arena.competition.events.Event;
import mc.alk.arena.controllers.messaging.EventMessageImpl;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.messaging.AnnouncementOptions;
import mc.alk.arena.objects.messaging.Channel;
import mc.alk.arena.objects.messaging.Channels;
import mc.alk.arena.objects.messaging.EventMessageHandler;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventMessager {
    EventMessageHandler impl;
    final AnnouncementOptions bos;
    boolean silent = false;

    public EventMessager(Event event) {
        this.impl = new EventMessageImpl(event);
        this.bos = event.getParams().getAnnouncementOptions();
    }

    protected Channel getChannel(MatchState state) {
        if (this.silent) {
            return Channels.NullChannel;
        }
        return this.bos != null && this.bos.hasOption(false, state) ? this.bos.getChannel(false, state) : AnnouncementOptions.getDefaultChannel(false, state);
    }

    public void setMessageHandler(EventMessageHandler handler) {
        this.impl = handler;
    }

    public EventMessageHandler getMessageHandler() {
        return this.impl;
    }

    public void sendCountdownTillEvent(int seconds) {
        try {
            this.impl.sendCountdownTillEvent(this.getChannel(MatchState.ONCOUNTDOWNTOEVENT), seconds);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendEventStarting(Collection<ArenaTeam> teams) {
        try {
            this.impl.sendEventStarting(this.getChannel(MatchState.ONSTART), teams);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendEventOpenMsg() {
        try {
            this.impl.sendEventOpenMsg(this.getChannel(MatchState.ONOPEN));
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendEventCancelledDueToLackOfPlayers(Set<ArenaPlayer> competingPlayers) {
        try {
            this.impl.sendEventCancelledDueToLackOfPlayers(this.getChannel(MatchState.ONCANCEL), competingPlayers);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendEventCancelled(Collection<ArenaTeam> teams) {
        try {
            this.impl.sendEventCancelled(this.getChannel(MatchState.ONCANCEL), teams);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendCantFitTeam(ArenaTeam t) {
        try {
            this.impl.sendCantFitTeam(t);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendWaitingForMorePlayers(ArenaTeam t, int remaining) {
        try {
            this.impl.sendWaitingForMorePlayers(t, remaining);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void sendEventVictory(Collection<ArenaTeam> victors, Collection<ArenaTeam> losers) {
        try {
            this.impl.sendEventVictory(this.getChannel(MatchState.ONVICTORY), victors, losers);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendEventDraw(Collection<ArenaTeam> drawers, Collection<ArenaTeam> losers) {
        try {
            this.impl.sendEventDraw(this.getChannel(MatchState.ONVICTORY), drawers, losers);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendTeamJoined(ArenaTeam team) {
        try {
            this.impl.sendTeamJoinedEvent(this.getChannel(MatchState.ONJOIN), team);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }
}

