/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.messaging;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.controllers.messaging.MessageFormatter;
import mc.alk.arena.events.matches.messages.MatchIntervalMessageEvent;
import mc.alk.arena.events.matches.messages.MatchTimeExpiredMessageEvent;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.messaging.Channel;
import mc.alk.arena.objects.messaging.Channels;
import mc.alk.arena.objects.messaging.MatchMessageHandler;
import mc.alk.arena.objects.messaging.Message;
import mc.alk.arena.objects.messaging.MessageOptions;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.victoryconditions.VictoryCondition;
import mc.alk.arena.objects.victoryconditions.interfaces.DefinesLeaderRanking;
import mc.alk.arena.serializers.MessageSerializer;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.TeamUtil;
import mc.alk.arena.util.TimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchMessageImpl
extends MessageSerializer
implements MatchMessageHandler {
    final Match match;
    final String typeName;
    final String typedot;

    public MatchMessageImpl(Match m) {
        super(ParamController.getMatchParams(m.getParams()).getName(), m.getParams());
        this.match = m;
        this.typeName = this.mp.getName();
        this.typedot = "match.";
    }

    @Override
    public void sendOnBeginMsg(Channel serverChannel, Collection<ArenaTeam> teams) {
        this.sendMessageToTeams(serverChannel, teams, "onbegin", "server_onbegin", this.mp.getSecondsTillMatch());
    }

    @Override
    public void sendOnPreStartMsg(Channel serverChannel, Collection<ArenaTeam> teams) {
        this.sendMessageToTeams(serverChannel, teams, "prestart", "server_prestart", this.mp.getSecondsTillMatch());
    }

    @Override
    public void sendOnStartMsg(Channel serverChannel, Collection<ArenaTeam> teams) {
        this.sendMessageToTeams(serverChannel, teams, "start", "server_start", null);
    }

    private void sendMessageToTeams(Channel serverChannel, Collection<ArenaTeam> teams, String path, String serverpath, Integer seconds) {
        String nTeamPath = MatchMessageImpl.getStringPathFromSize(teams.size());
        Message message = this.getNodeMessage(this.typedot + nTeamPath + "." + path);
        Message serverMessage = this.getNodeMessage(this.typedot + nTeamPath + "." + serverpath);
        Set<MessageOptions.MessageOption> ops = message.getOptions();
        if (serverChannel != Channels.NullChannel) {
            ops.addAll(serverMessage.getOptions());
        }
        MessageFormatter msgf = new MessageFormatter(this, this.match.getParams(), teams.size(), message, ops);
        msgf.formatCommonOptions(teams, seconds);
        for (ArenaTeam t : teams) {
            msgf.formatTeamOptions(t, false);
            msgf.formatTwoTeamsOptions(t, teams);
            msgf.formatTeams(teams);
            String newmsg = msgf.getFormattedMessage(message);
            t.sendMessage(newmsg);
        }
        if (serverChannel != Channels.NullChannel) {
            String msg = msgf.getFormattedMessage(serverMessage);
            serverChannel.broadcast(msg);
        }
    }

    @Override
    public void sendOnVictoryMsg(Channel serverChannel, Collection<ArenaTeam> victors, Collection<ArenaTeam> losers) {
        int size = (victors != null ? victors.size() : 0) + (losers != null ? losers.size() : 0);
        String nTeamPath = MatchMessageImpl.getStringPathFromSize(size);
        for (VictoryCondition vc : this.match.getVictoryConditions()) {
            List<ArenaTeam> leaders;
            if (!(vc instanceof DefinesLeaderRanking) || (leaders = ((DefinesLeaderRanking)((Object)vc)).getLeaders()) == null) continue;
            int max = Math.min(leaders.size(), 4);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < max; ++i) {
                sb.append("&6").append(i + 1).append("&e : ").append(TeamUtil.formatName(leaders.get(i))).append("\n");
            }
            String leaderStr = sb.toString();
            if (victors != null) {
                for (ArenaTeam t : victors) {
                    t.sendMessage(leaderStr);
                }
            }
            if (losers == null) break;
            for (ArenaTeam t : losers) {
                t.sendMessage(leaderStr);
            }
        }
        this.sendVictory(serverChannel, victors, losers, this.mp, this.typedot + nTeamPath + ".victory", this.typedot + nTeamPath + ".loss", this.typedot + nTeamPath + ".server_victory");
    }

    @Override
    public void sendOnDrawMsg(Channel serverChannel, Collection<ArenaTeam> drawers, Collection<ArenaTeam> losers) {
        int size = (drawers != null ? drawers.size() : 0) + (losers != null ? losers.size() : 0);
        String nTeamPath = MatchMessageImpl.getStringPathFromSize(size);
        this.sendVictory(serverChannel, null, drawers, this.mp, this.typedot + nTeamPath + ".draw", this.typedot + nTeamPath + ".draw", this.typedot + nTeamPath + ".server_draw");
    }

    @Override
    public void sendYourTeamNotReadyMsg(ArenaTeam t1) {
        Message message = this.getNodeMessage("match" + this.typeName + ".your_team_not_ready");
        Set<MessageOptions.MessageOption> ops = message.getOptions();
        MessageFormatter msgf = new MessageFormatter(this, this.match.getParams(), 1, message, ops);
        msgf.formatTeamOptions(t1, false);
        t1.sendMessage(msgf.getFormattedMessage(message));
    }

    @Override
    public void sendOtherTeamNotReadyMsg(ArenaTeam t1) {
        Message message = this.getNodeMessage(this.typedot + this.typeName + ".other_team_not_ready");
        Set<MessageOptions.MessageOption> ops = message.getOptions();
        MessageFormatter msgf = new MessageFormatter(this, this.match.getParams(), 1, message, ops);
        msgf.formatTeamOptions(t1, false);
        t1.sendMessage(msgf.getFormattedMessage(message));
    }

    @Override
    public void sendAddedToTeam(ArenaTeam team, ArenaPlayer player) {
        Message message = this.getNodeMessage("common.added_to_team");
        Set<MessageOptions.MessageOption> ops = message.getOptions();
        MessageFormatter msgf = new MessageFormatter(this, this.match.getParams(), 1, message, ops);
        msgf.formatTeamOptions(team, false);
        msgf.formatPlayerOptions(player);
        team.sendToOtherMembers(player, msgf.getFormattedMessage(message));
    }

    @Override
    public void sendOnIntervalMsg(Channel serverChannel, Collection<ArenaTeam> currentLeaders, int remaining) {
        TimeUtil.testClock();
        Message message = this.getNodeMessage("match.interval_update");
        Set<MessageOptions.MessageOption> ops = message.getOptions();
        MessageFormatter msgf = new MessageFormatter(this, this.match.getParams(), currentLeaders.size(), message, ops);
        msgf.formatCommonOptions(currentLeaders, remaining);
        String msg = msgf.getFormattedMessage(message);
        if (currentLeaders != null && !currentLeaders.isEmpty()) {
            Message message2;
            if (currentLeaders.size() == 1) {
                ArenaTeam currentLeader = currentLeaders.iterator().next();
                message2 = this.getNodeMessage("match.interval_update_winning");
                ops = message2.getOptions();
                msgf = new MessageFormatter(this, this.match.getParams(), currentLeaders.size(), message2, ops);
                msgf.formatCommonOptions(currentLeaders, remaining);
                msgf.formatTeamOptions(currentLeader, true);
                msg = msg + msgf.getFormattedMessage(message2);
                if (msg.contains("{winnerpointsfor}")) {
                    msg = msg.replaceAll("\\{winnerpointsfor\\}", currentLeader.getNKills() + "");
                }
                if (msg.contains("{winnerpointsagainst}")) {
                    msg = msg.replaceAll("\\{winnerpointsagainst\\}", currentLeader.getNDeaths() + "");
                }
            } else {
                String teamStr = MessageUtil.joinTeams(currentLeaders, "&e and ");
                message2 = this.getNodeMessage("match.interval_update_tied");
                msgf = new MessageFormatter(this, this.match.getParams(), currentLeaders.size(), message2, ops);
                msgf.formatCommonOptions(currentLeaders, remaining);
                msg = msg + msgf.getFormattedMessage(message2);
                if (msg.contains("{teams}")) {
                    msg = msg.replaceAll("\\{teams\\}", teamStr);
                }
            }
        }
        MatchIntervalMessageEvent event = new MatchIntervalMessageEvent(this.match, MatchState.ONMATCHINTERVAL, serverChannel, "", msg, remaining);
        this.match.callEvent(event);
        String emessage = event.getMatchMessage();
        if (emessage != null && !emessage.isEmpty()) {
            this.match.sendMessage(emessage);
        }
        emessage = event.getServerMessage();
        if (event.getServerChannel() != Channels.NullChannel && emessage != null && !emessage.isEmpty()) {
            event.getServerChannel().broadcast(emessage);
        }
    }

    @Override
    public void sendTimeExpired(Channel serverChannel) {
        MatchTimeExpiredMessageEvent event = new MatchTimeExpiredMessageEvent(this.match, MatchState.ONMATCHTIMEEXPIRED, serverChannel, "", "");
        this.match.callEvent(event);
        String message = event.getMatchMessage();
        if (message != null && !message.isEmpty()) {
            this.match.sendMessage(message);
        }
        message = event.getServerMessage();
        if (event.getServerChannel() != Channels.NullChannel && message != null && !message.isEmpty()) {
            event.getServerChannel().broadcast(message);
        }
    }

    @Override
    public String getMessage(String node) {
        return this.getMessage(node, null);
    }

    @Override
    public String getMessage(String node, Map<String, String> params) {
        String text = this.getNodeText(node);
        return text == null ? null : this.format(text, params);
    }

    @Override
    public void sendMessage(String node) {
        this.sendMessage(node, null);
    }

    @Override
    public void sendMessage(String node, Map<String, String> params) {
        String msg = this.getMessage(node, params);
        if (msg != null && !msg.isEmpty()) {
            this.match.sendMessage(msg);
        }
    }

    @Override
    public String format(String text, Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return text;
        }
        String[] searchList = new String[params.size()];
        String[] replaceList = new String[params.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            searchList[i] = entry.getKey();
            replaceList[i] = entry.getValue();
            ++i;
        }
        return MessageFormatter.replaceEach(text, searchList, replaceList);
    }

    @Override
    public void sendCountdownTillPrestart(Channel serverChannel, int seconds) {
        Message message = this.getNodeMessage("event.countdownTillEvent");
        Message serverMessage = this.getNodeMessage("event.server_countdownTillEvent");
        Set<MessageOptions.MessageOption> ops = message.getOptions();
        if (serverChannel != Channels.NullChannel) {
            ops.addAll(serverMessage.getOptions());
        }
        MessageFormatter msgf = new MessageFormatter(this, this.match.getParams(), 0, message, ops);
        msgf.formatCommonOptions(null, seconds);
        if (serverChannel != Channels.NullChannel) {
            String msg = msgf.getFormattedMessage(serverMessage);
            serverChannel.broadcast(msg);
        }
    }
}

