/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.messaging;

import java.util.Collection;
import java.util.List;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.controllers.messaging.MatchMessageImpl;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.messaging.AnnouncementOptions;
import mc.alk.arena.objects.messaging.Channel;
import mc.alk.arena.objects.messaging.Channels;
import mc.alk.arena.objects.messaging.MatchMessageHandler;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchMessager {
    MatchMessageHandler impl;
    final AnnouncementOptions bos;
    boolean silent = false;

    public MatchMessager(Match match) {
        this.impl = new MatchMessageImpl(match);
        this.bos = match.getParams().getAnnouncementOptions();
    }

    private Channel getChannel(MatchState state) {
        if (this.silent) {
            return Channels.NullChannel;
        }
        return this.bos != null && this.bos.hasOption(true, state) ? this.bos.getChannel(true, state) : AnnouncementOptions.getDefaultChannel(true, state);
    }

    public void sendOnBeginMsg(List<ArenaTeam> teams) {
        try {
            this.impl.sendOnBeginMsg(this.getChannel(MatchState.ONBEGIN), teams);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendOnPreStartMsg(List<ArenaTeam> teams) {
        this.sendOnPreStartMsg(teams, this.getChannel(MatchState.ONPRESTART));
    }

    public void sendOnPreStartMsg(List<ArenaTeam> teams, Channel serverChannel) {
        try {
            this.impl.sendOnPreStartMsg(serverChannel, teams);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendOnStartMsg(List<ArenaTeam> teams) {
        try {
            this.impl.sendOnStartMsg(this.getChannel(MatchState.ONSTART), teams);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendOnVictoryMsg(Collection<ArenaTeam> winners, Collection<ArenaTeam> losers) {
        try {
            this.impl.sendOnVictoryMsg(this.getChannel(MatchState.ONVICTORY), winners, losers);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendOnDrawMessage(Collection<ArenaTeam> drawers, Collection<ArenaTeam> losers) {
        try {
            this.impl.sendOnDrawMsg(this.getChannel(MatchState.ONVICTORY), drawers, losers);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendYourTeamNotReadyMsg(ArenaTeam t1) {
        try {
            this.impl.sendYourTeamNotReadyMsg(t1);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendOtherTeamNotReadyMsg(ArenaTeam t1) {
        try {
            this.impl.sendOtherTeamNotReadyMsg(t1);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendOnIntervalMsg(int remaining, Collection<ArenaTeam> currentLeaders) {
        try {
            this.impl.sendOnIntervalMsg(this.getChannel(MatchState.ONMATCHINTERVAL), currentLeaders, remaining);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendTimeExpired() {
        try {
            this.impl.sendTimeExpired(this.getChannel(MatchState.ONMATCHTIMEEXPIRED));
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void setMessageHandler(MatchMessageHandler mc) {
        this.impl = mc;
    }

    public MatchMessageHandler getMessageHandler() {
        return this.impl;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void sendAddedToTeam(ArenaTeam team, ArenaPlayer player) {
        try {
            this.impl.sendAddedToTeam(team, player);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendCountdownTillPrestart(int remaining) {
        try {
            this.impl.sendCountdownTillPrestart(this.getChannel(MatchState.ONCOUNTDOWNTOEVENT), remaining);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }
}

