/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.messaging;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import mc.alk.arena.controllers.plugins.TrackerController;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.messaging.Message;
import mc.alk.arena.objects.messaging.MessageOptions;
import mc.alk.arena.objects.stats.ArenaStat;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.serializers.MessageSerializer;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.TimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFormatter {
    final String[] searchList;
    final String[] replaceList;
    final TrackerController sc;
    final Set<MessageOptions.MessageOption> ops;
    final Message msg;
    final HashMap<Integer, TeamNames> tns;
    final MatchParams mp;
    final String typeName;
    final MessageSerializer impl;
    int commonIndex = 0;
    int teamIndex = 0;
    int curIndex = 0;

    public MessageFormatter(MessageSerializer impl, MatchParams mp, int nTeams, Message message, Set<MessageOptions.MessageOption> ops) {
        int size = ops.size();
        this.searchList = new String[size];
        this.replaceList = new String[size];
        this.msg = message;
        this.ops = ops;
        this.tns = new HashMap(nTeams);
        this.mp = mp;
        this.typeName = mp.getType().getName();
        this.sc = new TrackerController(mp);
        this.impl = impl;
    }

    public void formatCommonOptions(Collection<ArenaTeam> teams) {
        this.formatCommonOptions(teams, null);
    }

    public void formatCommonOptions(Collection<ArenaTeam> teams, Integer seconds) {
        int i = 0;
        ArenaTeam t1 = null;
        ArenaTeam t2 = null;
        if (teams != null) {
            int j = 0;
            for (ArenaTeam t : teams) {
                if (j == 0) {
                    t1 = t;
                } else {
                    if (j != true) break;
                    t2 = t;
                }
                ++j;
            }
        }
        for (MessageOptions.MessageOption mop : this.ops) {
            block34: {
                if (mop == null) continue;
                try {
                    switch (mop) {
                        case CMD: {
                            this.replaceList[i] = this.mp.getCommand();
                            break block34;
                        }
                        case PREFIX: 
                        case MATCHPREFIX: 
                        case EVENTPREFIX: {
                            this.replaceList[i] = this.mp.getPrefix();
                            break block34;
                        }
                        case COMPNAME: 
                        case EVENTNAME: 
                        case MATCHNAME: {
                            this.replaceList[i] = this.mp.getName();
                            break block34;
                        }
                        case SECONDS: {
                            this.replaceList[i] = seconds != null ? seconds.toString() : null;
                            break block34;
                        }
                        case TIME: {
                            this.replaceList[i] = seconds != null ? TimeUtil.convertSecondsToString(seconds.intValue()) : null;
                            break block34;
                        }
                        case TEAM1: {
                            this.replaceList[i] = this.formatTeamName(this.impl.getNodeMessage("common.team"), t1);
                            break block34;
                        }
                        case TEAM2: {
                            this.replaceList[i] = this.formatTeamName(this.impl.getNodeMessage("common.team"), t2);
                            break block34;
                        }
                        case TEAMSHORT1: {
                            this.replaceList[i] = this.formatTeamName(this.impl.getNodeMessage("common.teamshort"), t1);
                            break block34;
                        }
                        case TEAMSHORT2: {
                            this.replaceList[i] = this.formatTeamName(this.impl.getNodeMessage("common.teamshort"), t2);
                            break block34;
                        }
                        case TEAMLONG1: {
                            this.replaceList[i] = this.formatTeamName(this.impl.getNodeMessage("common.teamlong"), t1);
                            break block34;
                        }
                        case TEAMLONG2: {
                            this.replaceList[i] = this.formatTeamName(this.impl.getNodeMessage("common.teamlong"), t2);
                            break block34;
                        }
                        case NTEAMS: {
                            this.replaceList[i] = teams != null ? teams.size() + "" : "0";
                            break block34;
                        }
                        case PLAYERORTEAM: {
                            this.replaceList[i] = teams != null ? MessageUtil.getTeamsOrPlayers(this.mp.getMaxTeamSize()) : "teams";
                            break block34;
                        }
                        case PARTICIPANTS: {
                            if (teams != null) {
                                StringBuilder sb = new StringBuilder();
                                boolean first = true;
                                for (ArenaTeam t : teams) {
                                    TeamNames tn;
                                    if (!first) {
                                        sb.append(", ");
                                    }
                                    if ((tn = this.getTeamNames(t)) == null) {
                                        sb.append(t.getDisplayName());
                                    } else if (tn.longName != null) {
                                        sb.append(tn.longName);
                                    } else if (tn.shortName != null) {
                                        sb.append(tn.shortName);
                                    } else if (tn.name != null) {
                                        sb.append(tn.name);
                                    } else {
                                        sb.append(t.getDisplayName());
                                    }
                                    first = false;
                                }
                                this.replaceList[i] = sb.toString();
                            }
                            break block34;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
            this.searchList[i] = mop.getReplaceString();
            ++i;
        }
        this.commonIndex = i;
    }

    public void formatPlayerOptions(ArenaPlayer player) {
        int i = this.commonIndex;
        block3: for (MessageOptions.MessageOption mop : this.ops) {
            if (mop == null) continue;
            switch (mop) {
                case PLAYERNAME: {
                    this.replaceList[i] = player.getDisplayName();
                    break;
                }
                default: {
                    continue block3;
                }
            }
            this.searchList[i] = mop.getReplaceString();
            ++i;
        }
        this.teamIndex = i;
        this.curIndex = i;
    }

    public void formatTeamOptions(ArenaTeam team, boolean isWinner) {
        int i = this.commonIndex;
        TeamNames tn = this.getTeamNames(team);
        block12: for (MessageOptions.MessageOption mop : this.ops) {
            if (mop == null) continue;
            switch (mop) {
                case WINNER: {
                    this.replaceList[i] = isWinner ? team.getDisplayName() : "";
                    break;
                }
                case LOSER: {
                    this.replaceList[i] = !isWinner ? team.getDisplayName() : "";
                    break;
                }
                case NAME: {
                    this.replaceList[i] = team.getDisplayName();
                    break;
                }
                case TEAM: {
                    this.replaceList[i] = tn.name;
                    break;
                }
                case TEAMSHORT: {
                    this.replaceList[i] = tn.shortName;
                    break;
                }
                case TEAMLONG: {
                    this.replaceList[i] = tn.longName;
                    break;
                }
                case WINS: {
                    this.replaceList[i] = team.getStat().getWins() + "";
                    break;
                }
                case LOSSES: {
                    this.replaceList[i] = team.getStat().getLosses() + "";
                    break;
                }
                case RANKING: {
                    this.replaceList[i] = team.getStat().getRanking() + "";
                    break;
                }
                case RATING: {
                    this.replaceList[i] = team.getStat().getRating() + "";
                    break;
                }
                default: {
                    continue block12;
                }
            }
            this.searchList[i] = mop.getReplaceString();
            ++i;
        }
        this.teamIndex = i;
        this.curIndex = i;
    }

    public void formatTwoTeamsOptions(ArenaTeam t, Collection<ArenaTeam> teams) {
        ArenaStat st1 = t.getStat();
        int i = this.teamIndex;
        block9: for (MessageOptions.MessageOption mop : this.ops) {
            if (mop == null) continue;
            String repl = null;
            switch (mop) {
                case OTHERTEAM: {
                    ArenaTeam oteam = this.getOtherTeam(t, teams);
                    if (oteam == null) break;
                    repl = oteam.getDisplayName();
                    break;
                }
                case WINSAGAINST: {
                    ArenaStat st2;
                    ArenaTeam oteam;
                    try {
                        oteam = this.getOtherTeam(t, teams);
                        if (oteam != null) {
                            st2 = oteam.getStat();
                            repl = st1.getWinsVersus(st2) + "";
                            break;
                        }
                        repl = "0";
                    }
                    catch (Exception e) {
                        Log.printStackTrace(e);
                    }
                    break;
                }
                case LOSSESAGAINST: {
                    ArenaStat st2;
                    ArenaTeam oteam;
                    try {
                        st1 = t.getStat();
                        oteam = this.getOtherTeam(t, teams);
                        if (oteam != null) {
                            st2 = oteam.getStat();
                            repl = st1.getLossesVersus(st2) + "";
                            break;
                        }
                        repl = "0";
                    }
                    catch (Exception e) {
                        Log.printStackTrace(e);
                    }
                    break;
                }
                default: {
                    continue block9;
                }
            }
            this.searchList[i] = mop.getReplaceString();
            this.replaceList[i] = repl;
            ++i;
        }
        this.curIndex = i;
    }

    public void formatTeams(Collection<ArenaTeam> teams) {
        if (this.ops.contains((Object)MessageOptions.MessageOption.TEAMS)) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (ArenaTeam team : teams) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(team.getDisplayName());
            }
            this.replaceList[this.curIndex] = sb.toString();
            this.searchList[this.curIndex] = MessageOptions.MessageOption.TEAMS.getReplaceString();
            ++this.curIndex;
        }
    }

    public void formatWinnerOptions(ArenaTeam team, boolean isWinner) {
        int i = this.curIndex;
        TeamNames tn = this.getTeamNames(team);
        block9: for (MessageOptions.MessageOption mop : this.ops) {
            if (mop == null) continue;
            switch (mop) {
                case WINNER: {
                    if (!isWinner) continue block9;
                    this.replaceList[i] = tn.name;
                    break;
                }
                case WINNERSHORT: {
                    if (!isWinner) continue block9;
                    this.replaceList[i] = tn.shortName;
                    break;
                }
                case WINNERLONG: {
                    if (!isWinner) continue block9;
                    this.replaceList[i] = tn.longName;
                    break;
                }
                case LOSER: {
                    if (isWinner) continue block9;
                    this.replaceList[i] = tn.name;
                    break;
                }
                case LOSERSHORT: {
                    if (isWinner) continue block9;
                    this.replaceList[i] = tn.shortName;
                    break;
                }
                case LOSERLONG: {
                    if (isWinner) continue block9;
                    this.replaceList[i] = tn.longName;
                    break;
                }
                case LIFELEFT: {
                    if (!isWinner) continue block9;
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    for (ArenaPlayer ap : team.getLivingPlayers()) {
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append("&6").append(ap.getDisplayName()).append("&e(&4").append(ap.getHealth()).append("&e)");
                        first = false;
                    }
                    for (ArenaPlayer ap : team.getDeadPlayers()) {
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append("&6").append(ap.getDisplayName()).append("&e(&8Dead&e)");
                        first = false;
                    }
                    this.replaceList[i] = sb.toString();
                    break;
                }
                default: {
                    continue block9;
                }
            }
            this.searchList[i] = mop.getReplaceString();
            ++i;
        }
        this.curIndex = i;
    }

    private TeamNames getTeamNames(ArenaTeam t) {
        if (this.tns.containsKey(t.getId())) {
            return this.tns.get(t.getId());
        }
        TeamNames tn = new TeamNames();
        this.formatTeamNames(this.ops, t, tn);
        this.tns.put(t.getId(), tn);
        return tn;
    }

    private ArenaTeam getOtherTeam(ArenaTeam t, Collection<ArenaTeam> teams) {
        for (ArenaTeam oteam : teams) {
            if (oteam.getId() == t.getId()) continue;
            return oteam;
        }
        return null;
    }

    private String formatTeamName(Message message, ArenaTeam t) {
        if (t == null) {
            return null;
        }
        Set<MessageOptions.MessageOption> ops = message.getOptions();
        String[] searchList = new String[ops.size()];
        String[] replaceList = new String[ops.size()];
        int i = 0;
        block7: for (MessageOptions.MessageOption mop : ops) {
            String repl;
            if (mop == null) continue;
            switch (mop) {
                case NAME: {
                    repl = t.getDisplayName();
                    break;
                }
                case WINS: {
                    repl = t.getStat().getWins() + "";
                    break;
                }
                case LOSSES: {
                    repl = t.getStat().getLosses() + "";
                    break;
                }
                case RANKING: {
                    repl = t.getStat().getRanking() + "";
                    break;
                }
                case RATING: {
                    repl = t.getStat().getRating() + "";
                    break;
                }
                default: {
                    continue block7;
                }
            }
            searchList[i] = mop.getReplaceString();
            replaceList[i] = repl;
            ++i;
        }
        return MessageFormatter.replaceEach(message.getMessage(), searchList, replaceList);
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        return MessageFormatter.replaceEach(text, searchList, replacementList, false, 0);
    }

    public void formatTeamNames(Set<MessageOptions.MessageOption> ops, ArenaTeam team, TeamNames tn) {
        if (ops.contains((Object)MessageOptions.MessageOption.TEAM) || ops.contains((Object)MessageOptions.MessageOption.WINNER) || ops.contains((Object)MessageOptions.MessageOption.LOSER)) {
            tn.name = this.formatTeamName(this.impl.getNodeMessage("common.team"), team);
        }
        if (ops.contains((Object)MessageOptions.MessageOption.TEAMSHORT) || ops.contains((Object)MessageOptions.MessageOption.WINNERSHORT) || ops.contains((Object)MessageOptions.MessageOption.LOSERSHORT)) {
            tn.shortName = this.formatTeamName(this.impl.getNodeMessage("common.teamshort"), team);
        }
        if (ops.contains((Object)MessageOptions.MessageOption.TEAMLONG) || ops.contains((Object)MessageOptions.MessageOption.WINNERLONG) || ops.contains((Object)MessageOptions.MessageOption.LOSERLONG)) {
            tn.longName = this.formatTeamName(this.impl.getNodeMessage("common.teamlong"), team);
        }
    }

    public String getFormattedMessage(Message message) {
        return MessageFormatter.replaceEach(message.getMessage(), this.searchList, this.replaceList);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        int tempIndex;
        if (text == null || text.length() == 0 || searchList == null || searchList.length == 0 || replacementList == null || replacementList.length == 0) {
            return text;
        }
        if (timeToLive < 0) {
            throw new IllegalStateException("TimeToLive of " + timeToLive + " is less than 0: " + text);
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].length() == 0 || replacementList[i] == null) continue;
            tempIndex = text.indexOf(searchList[i]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int greater;
            if (searchList[i] == null || replacementList[i] == null || (greater = replacementList[i].length() - searchList[i].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].length() == 0 || replacementList[i] == null) continue;
                tempIndex = text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        String result = buf.toString();
        if (!repeat) {
            return result;
        }
        return MessageFormatter.replaceEach(result, searchList, replacementList, true, timeToLive - 1);
    }

    public void printMap() {
        Log.info("!!!!!!!!!!!!!! " + this.commonIndex + "   " + this.teamIndex);
        for (int i = 0; i < this.searchList.length; ++i) {
            Log.info(i + " : " + this.replaceList[i] + "  ^^^ " + this.searchList[i]);
        }
    }

    public class TeamNames {
        public String longName = null;
        public String shortName = null;
        public String name = null;
    }
}

