/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.messaging;

import java.util.List;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.messaging.Message;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.serializers.MessageSerializer;
import mc.alk.arena.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHandler
extends MessageSerializer {
    public MessageHandler() {
        super(null, null);
    }

    public static String getSystemMessage(List<Object> vars, String string, Object ... varArgs) {
        Message msg = MessageHandler.getDefaultMessage("system." + string);
        if (msg != null) {
            String stringmsg = msg.getMessage();
            if (vars == null || vars.isEmpty() || !stringmsg.contains("{")) {
                return MessageHandler.getSystemMessage(string, varArgs);
            }
            for (Object o : vars) {
                if (o instanceof MatchParams) {
                    stringmsg = stringmsg.replaceAll("\\{matchname\\}", ((MatchParams)o).getName());
                    stringmsg = stringmsg.replaceAll("\\{cmd\\}", ((MatchParams)o).getCommand());
                    continue;
                }
                if (!(o instanceof ArenaTeam)) continue;
                stringmsg = stringmsg.replaceAll("\\{team\\}", ((ArenaTeam)o).getName());
            }
            try {
                return String.format(stringmsg, varArgs);
            }
            catch (Exception e) {
                String err = "&c[BA Message Error] system.+" + string;
                Log.err(err);
                for (Object o : varArgs) {
                    Log.err("Message Option: " + o);
                }
                Log.printStackTrace(e);
                return err;
            }
        }
        return null;
    }

    public static String getSystemMessage(MatchParams params, String string, Object ... varArgs) {
        Message msg = MessageHandler.getDefaultMessage("system." + string);
        if (msg != null) {
            String stringmsg = msg.getMessage();
            if (stringmsg.indexOf(123) == -1) {
                return MessageHandler.getSystemMessage(string, varArgs);
            }
            stringmsg = stringmsg.replaceAll("\\{matchname\\}", params.getName());
            stringmsg = stringmsg.replaceAll("\\{cmd\\}", params.getCommand());
            stringmsg = stringmsg.replaceAll("\\{prefix\\}", params.getPrefix());
            try {
                return String.format(stringmsg, varArgs);
            }
            catch (Exception e) {
                String err = "&c[BA Message Error] system.+" + string;
                Log.err(err);
                for (Object o : varArgs) {
                    Log.err("Message Option: " + o);
                }
                Log.printStackTrace(e);
                return err;
            }
        }
        return null;
    }

    public static String getSystemMessage(String string, Object ... varArgs) {
        Message msg = MessageHandler.getDefaultMessage("system." + string);
        if (msg != null) {
            try {
                String message = msg.getMessage();
                return message != null ? String.format(message, varArgs) : null;
            }
            catch (Exception e) {
                String err = "&c[BA Message Error] system." + string;
                Log.err(err);
                for (Object o : varArgs) {
                    Log.err("Message Option: " + o);
                }
                Log.printStackTrace(e);
                return err;
            }
        }
        return null;
    }
}

