/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers.messaging;

import java.util.Collection;
import java.util.Set;
import mc.alk.arena.competition.events.Event;
import mc.alk.arena.controllers.messaging.EventMessager;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservedArenaEventMessager
extends EventMessager {
    public ReservedArenaEventMessager(Event event) {
        super(event);
    }

    @Override
    public void sendEventCancelledDueToLackOfPlayers(Set<ArenaPlayer> competingPlayers) {
        try {
            this.impl.sendEventCancelledDueToLackOfPlayers(this.getChannel(MatchState.ONCANCEL), competingPlayers);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    @Override
    public void sendEventCancelled(Collection<ArenaTeam> teams) {
        try {
            this.impl.sendEventCancelled(this.getChannel(MatchState.ONCANCEL), teams);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void sendTeamJoinedEvent(ArenaTeam t) {
        try {
            this.impl.sendTeamJoinedEvent(this.getChannel(MatchState.ONJOIN), t);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    @Override
    public void sendEventDraw(Collection<ArenaTeam> drawers, Collection<ArenaTeam> losers) {
    }
}

