/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.events.matches;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.events.matches.MatchEvent;
import mc.alk.arena.objects.MatchResult;
import mc.alk.arena.objects.WinLossDraw;
import mc.alk.arena.objects.teams.ArenaTeam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchFindCurrentLeaderEvent
extends MatchEvent {
    final List<ArenaTeam> teams;
    MatchResult result = new MatchResult();
    final boolean matchEnding;

    public MatchFindCurrentLeaderEvent(Match match) {
        this(match, match.getTeams(), false);
    }

    public MatchFindCurrentLeaderEvent(Match match, List<ArenaTeam> teams) {
        this(match, teams, false);
    }

    public MatchFindCurrentLeaderEvent(Match match, List<ArenaTeam> teams, boolean matchEnding) {
        super(match);
        this.teams = teams;
        this.matchEnding = matchEnding;
    }

    public List<ArenaTeam> getTeams() {
        return this.teams;
    }

    public Set<ArenaTeam> getCurrentLeaders() {
        return this.result.getVictors();
    }

    public void setCurrentLeader(ArenaTeam currentLeader) {
        this.result.setVictor(currentLeader);
        this.result.setResult(WinLossDraw.WIN);
    }

    public void setCurrentLeaders(Collection<ArenaTeam> currentLeaders) {
        this.result.setVictors(currentLeaders);
        this.result.setResult(WinLossDraw.WIN);
    }

    public void setCurrentDrawers(Collection<ArenaTeam> currentLeaders) {
        this.result.setDrawers(currentLeaders);
        this.result.setResult(WinLossDraw.DRAW);
    }

    public void setCurrentLosers(Collection<ArenaTeam> currentLosers) {
        this.result.setLosers(currentLosers);
    }

    public MatchResult getResult() {
        return this.result;
    }

    public void setResult(MatchResult result) {
        this.result = result;
    }

    public boolean isMatchEnding() {
        return this.matchEnding;
    }

    public SortedMap<Integer, Collection<ArenaTeam>> getRanking() {
        return this.result.getRanking();
    }
}

