/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.executors;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.ArenaAlterController;
import mc.alk.arena.controllers.ArenaDebugger;
import mc.alk.arena.controllers.ArenaEditor;
import mc.alk.arena.executors.CustomCommandExecutor;
import mc.alk.arena.executors.MCCommand;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.exceptions.InvalidOptionException;
import mc.alk.arena.objects.options.SpawnOptions;
import mc.alk.arena.objects.pairs.ParamAlterOptionPair;
import mc.alk.arena.objects.pairs.TransitionOptionTuple;
import mc.alk.arena.objects.spawns.TimedSpawn;
import mc.alk.arena.serializers.ArenaSerializer;
import mc.alk.arena.serializers.SpawnSerializer;
import mc.alk.arena.util.MessageUtil;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ArenaEditorExecutor
extends CustomCommandExecutor {
    public static String idPrefix = "ar_";
    WorldEditPlugin wep;

    @MCCommand(cmds={"select", "sel"}, admin=true)
    public boolean arenaSelect(CommandSender sender, Arena arena) {
        ArenaEditor aac = BattleArena.getArenaEditor();
        aac.setCurrentArena(sender, arena);
        return MessageUtil.sendMessage(sender, "&2You have selected arena &6" + arena.getName());
    }

    @MCCommand(cmds={"ds", "deletespawn"}, admin=true, usage="/aa deleteSpawn <index>")
    public boolean arenaDeleteSpawn(CommandSender sender, ArenaEditor.CurrentSelection cs, Integer number) {
        if (number <= 0 || number > 10000) {
            return MessageUtil.sendMessage(sender, "&cYou need to specify an index within the range &61-10000");
        }
        Arena a = cs.getArena();
        TimedSpawn ts = a.deleteTimedSpawn((long)number);
        if (ts != null) {
            this.ac.updateArena(a);
            BattleArena.saveArenas();
            return MessageUtil.sendMessage(sender, "&6" + a.getName() + "&e has deleted index=&4D" + number + "&e that had spawn=" + ts);
        }
        return MessageUtil.sendMessage(sender, "&cThere was no spawn at that index");
    }

    @MCCommand(cmds={"as", "addspawn"}, admin=true, min=2, usage="/aa addspawn <mob/item/spawnGroup> [buffs or effects] [number] [fs=first spawn time] [rt=respawn time] [trigger=<trigger type>] [index|i=<index>]")
    public boolean arenaAddSpawn(Player sender, ArenaEditor.CurrentSelection cs, String[] args) {
        Long index = this.parseIndex((CommandSender)sender, cs.getArena(), args);
        if (index == -1L) {
            return true;
        }
        Arena a = cs.getArena();
        TimedSpawn spawn = SpawnSerializer.parseSpawn(Arrays.copyOfRange(args, 0, args.length - 1));
        if (spawn == null) {
            return MessageUtil.sendMessage((CommandSender)sender, "Couldnt recognize spawn " + args[1]);
        }
        Location l = sender.getLocation();
        spawn.getSpawn().setLocation(l);
        a.addTimedSpawn(index, spawn);
        this.ac.updateArena(a);
        ArenaSerializer.saveArenas(a.getArenaType().getPlugin());
        return MessageUtil.sendMessage((CommandSender)sender, "&6" + a.getName() + "&e now has spawn &6" + spawn + "&2  index=&5" + index);
    }

    @MCCommand(cmds={"ab", "addBlock"}, admin=true, usage="/aa addBlock [number] [fs=first spawn time] [rt=respawn time] [trigger=<trigger type>] [resetTo=<block>] [index]")
    public boolean arenaAddBlock(Player sender, ArenaEditor.CurrentSelection cs, String[] args) {
        Long index = this.parseIndex((CommandSender)sender, cs.getArena(), args);
        if (index == -1L) {
            return true;
        }
        SpawnOptions po = SpawnOptions.parseSpawnOptions(args);
        cs.setStartListening(index, po);
        return MessageUtil.sendMessage((CommandSender)sender, "&2Success: &eClick a block to add the block spawn");
    }

    private Long parseIndex(CommandSender sender, Arena arena, String[] args) {
        Long number = -1L;
        String last = args[args.length - 1];
        String split = "index=|i=";
        try {
            String[] s = last.split(split);
            if (s.length == 2) {
                number = Long.parseLong(s[1]);
            }
        }
        catch (Exception e) {
            MessageUtil.sendMessage(sender, "&cindex " + last + " was bad");
            return -1L;
        }
        if (number == -1L) {
            Long k;
            long nextIndex;
            Map<Long, TimedSpawn> spawns = arena.getTimedSpawns();
            if (spawns == null) {
                return 1L;
            }
            ArrayList<Long> keys = new ArrayList<Long>(spawns.keySet());
            Collections.sort(keys);
            Iterator i$ = keys.iterator();
            for (nextIndex = 1L; i$.hasNext() && (k = (Long)i$.next()) == nextIndex; ++nextIndex) {
            }
            number = nextIndex;
        }
        if (number <= 0L || number > 10000L) {
            MessageUtil.sendMessage(sender, "&cYou need to specify an index within the range &61-10000");
            return -1L;
        }
        return number;
    }

    @MCCommand(cmds={}, admin=true, perm="arena.alter")
    public boolean arenaGeneric(CommandSender sender, ArenaEditor.CurrentSelection cs, ArenaAlterController.ArenaOptionPair aop) {
        return ArenaEditorExecutor.setArenaOption(sender, cs.getArena(), aop);
    }

    @MCCommand(cmds={}, admin=true, perm="arena.alter")
    public boolean arenaGeneric(CommandSender sender, ArenaEditor.CurrentSelection cs, ParamAlterOptionPair gop) {
        return ArenaEditorExecutor.setArenaOption(sender, cs.getArena(), gop);
    }

    @MCCommand(cmds={}, admin=true, perm="arena.alter")
    public boolean arenaGeneric(CommandSender sender, ArenaEditor.CurrentSelection cs, TransitionOptionTuple top) {
        return ArenaEditorExecutor.setArenaOption(sender, cs.getArena(), top);
    }

    public static boolean setArenaOption(CommandSender sender, Arena arena, TransitionOptionTuple top) {
        try {
            ArenaAlterController.setArenaOption(sender, arena, top.state, top.op, top.value);
            if (top.value != null) {
                ArenaEditorExecutor.sendMessage(sender, "&2Arena " + arena.getDisplayName() + " options &6" + top.op + "&2 changed to &6" + top.value);
            } else {
                ArenaEditorExecutor.sendMessage(sender, "&2Arena " + arena.getDisplayName() + " options &6" + top.op + "&2 changed");
            }
            return true;
        }
        catch (IllegalStateException e) {
            return ArenaEditorExecutor.sendMessage(sender, "&c" + e.getMessage());
        }
        catch (InvalidOptionException e) {
            return ArenaEditorExecutor.sendMessage(sender, "&c" + e.getMessage());
        }
    }

    public static boolean setArenaOption(CommandSender sender, Arena arena, ArenaAlterController.ArenaOptionPair aop) {
        try {
            ArenaAlterController.setArenaOption(sender, arena, aop.ao, aop.value);
            return true;
        }
        catch (IllegalStateException e) {
            return ArenaEditorExecutor.sendMessage(sender, "&c" + e.getMessage());
        }
    }

    public static boolean setArenaOption(CommandSender sender, Arena arena, ParamAlterOptionPair gop) {
        try {
            ArenaAlterController.setArenaOption(sender, arena, gop.alterParamOption, gop.value);
            if (gop.value != null) {
                ArenaEditorExecutor.sendMessage(sender, "&2Arena " + arena.getDisplayName() + " options &6" + gop.alterParamOption.name() + "&2 changed to &6" + gop.value);
            } else {
                ArenaEditorExecutor.sendMessage(sender, "&2Arena " + arena.getDisplayName() + " options &6" + gop.alterParamOption.name() + "&2 changed");
            }
            return true;
        }
        catch (IllegalStateException e) {
            return ArenaEditorExecutor.sendMessage(sender, "&c" + e.getMessage());
        }
    }

    @MCCommand(cmds={"hidespawns"}, admin=true, usage="hidespawns")
    public boolean arenaHideSpawns(Player sender, ArenaEditor.CurrentSelection cs) {
        Arena arena = cs.getArena();
        ArenaDebugger ad = ArenaDebugger.getDebugger(arena);
        ad.hideSpawns(sender);
        ArenaDebugger.removeDebugger(ad);
        return ArenaEditorExecutor.sendMessage((CommandSender)sender, ChatColor.YELLOW + "You are hiding spawns for &6" + arena.getName());
    }

    @MCCommand(cmds={"showspawns"}, admin=true, usage="showspawns")
    public boolean arenaShowSpawns(Player sender, ArenaEditor.CurrentSelection cs) {
        Arena arena = cs.getArena();
        ArenaDebugger ad = ArenaDebugger.getDebugger(arena);
        ad.hideSpawns(sender);
        ad.showSpawns(sender);
        return ArenaEditorExecutor.sendMessage((CommandSender)sender, ChatColor.GREEN + "You are showing spawns for &6" + arena.getName());
    }

    @MCCommand(cmds={"listspawns"}, admin=true)
    public boolean arenaListSpawns(Player sender, ArenaEditor.CurrentSelection cs) {
        Arena arena = cs.getArena();
        ArenaEditorExecutor.sendMessage((CommandSender)sender, ChatColor.GREEN + "You are listing spawns for &6" + arena.getName());
        Map<Long, TimedSpawn> spawns = arena.getTimedSpawns();
        if (spawns == null) {
            return ArenaEditorExecutor.sendMessage((CommandSender)sender, ChatColor.RED + "Arena has no spawns");
        }
        ArrayList<Long> keys = new ArrayList<Long>(spawns.keySet());
        Collections.sort(keys);
        for (Long k : keys) {
            ArenaEditorExecutor.sendMessage((CommandSender)sender, "&5" + k + "&e: " + spawns.get(k).getDisplayName());
        }
        return true;
    }
}

