/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.executors;

import java.util.Arrays;
import java.util.List;
import mc.alk.arena.controllers.EventScheduler;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.executors.CustomCommandExecutor;
import mc.alk.arena.executors.MCCommand;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.pairs.EventPair;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;

public class BASchedulerExecutor
extends CustomCommandExecutor {
    EventScheduler es;

    public BASchedulerExecutor(EventScheduler es) {
        this.es = es;
    }

    @MCCommand(cmds={"add"}, admin=true)
    public boolean schedule(CommandSender sender, String eventType, String[] args) {
        MatchParams ep = ParamController.getMatchParamCopy(eventType);
        if (ep == null) {
            return BASchedulerExecutor.sendMessage(sender, "&cEvent type " + eventType + " not found!");
        }
        if (this.es.scheduleEvent(ep, Arrays.copyOfRange(args, 2, args.length))) {
            BASchedulerExecutor.sendMessage(sender, "&2Event scheduled!. &6/bas list&2 to see a list of scheduled events");
        } else {
            BASchedulerExecutor.sendMessage(sender, "&cEvent not scheduled!. There was some error scheduling this events");
        }
        return true;
    }

    @MCCommand(cmds={"delete", "del"}, admin=true)
    public boolean delete(CommandSender sender, Integer index) {
        List<EventPair> events = this.es.getEvents();
        if (events == null || events.isEmpty()) {
            return BASchedulerExecutor.sendMessage(sender, "&cNo &4BattleArena&c events have been scheduled");
        }
        if (events.size() < index || index <= 0) {
            return BASchedulerExecutor.sendMessage(sender, "&cIndex is out of range.  Valid Range: &61-" + events.size());
        }
        this.es.deleteEvent(index - 1);
        return BASchedulerExecutor.sendMessage(sender, "&2Event &6" + index + "&2 deleted");
    }

    @MCCommand(cmds={"list"}, admin=true)
    public boolean list(CommandSender sender) {
        List<EventPair> events = this.es.getEvents();
        if (events == null || events.isEmpty()) {
            return BASchedulerExecutor.sendMessage(sender, "&cNo &4BattleArena&c events have been scheduled");
        }
        for (int i = 0; i < events.size(); ++i) {
            EventPair ep = events.get(i);
            String[] args = ep.getArgs();
            String strargs = args == null ? "[]" : StringUtils.join((Object[])ep.getArgs(), (String)" ");
            BASchedulerExecutor.sendMessage(sender, "&2" + (i + 1) + "&e:&6" + ep.getEventParams().getName() + "&e args: &6" + strargs);
        }
        return BASchedulerExecutor.sendMessage(sender, "&6/bas delete <number>:&e to delete an event");
    }

    @MCCommand(cmds={"start"}, admin=true)
    public boolean start(CommandSender sender) {
        List<EventPair> events = this.es.getEvents();
        if (events == null || events.isEmpty()) {
            return BASchedulerExecutor.sendMessage(sender, "&cNo &4BattleArena&c events have been scheduled");
        }
        if (this.es.isRunning()) {
            return BASchedulerExecutor.sendMessage(sender, "&cScheduled events are already running!");
        }
        this.es.start();
        return BASchedulerExecutor.sendMessage(sender, "&2Scheduled events are now &astarted");
    }

    @MCCommand(cmds={"stop"}, admin=true)
    public boolean stop(CommandSender sender) {
        if (!this.es.isRunning()) {
            return BASchedulerExecutor.sendMessage(sender, "&cScheduled events are already stopped!");
        }
        this.es.stop();
        return BASchedulerExecutor.sendMessage(sender, "&2Scheduled events are now &4stopped!");
    }

    @MCCommand(cmds={"startNext"}, admin=true)
    public boolean startNext(CommandSender sender) {
        List<EventPair> events = this.es.getEvents();
        if (events == null || events.isEmpty()) {
            return BASchedulerExecutor.sendMessage(sender, "&cNo &4BattleArena&c events have been scheduled");
        }
        this.es.startNext();
        return BASchedulerExecutor.sendMessage(sender, "&2Next Scheduled event is now starting");
    }
}

