/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.executors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.ArenaClassController;
import mc.alk.arena.controllers.BAEventController;
import mc.alk.arena.controllers.PlayerController;
import mc.alk.arena.events.players.ArenaPlayerLeaveEvent;
import mc.alk.arena.executors.CustomCommandExecutor;
import mc.alk.arena.executors.MCCommand;
import mc.alk.arena.objects.ArenaClass;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.arenas.ArenaType;
import mc.alk.arena.serializers.InventorySerializer;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.MessageUtil;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BattleArenaExecutor
extends CustomCommandExecutor {
    @MCCommand(cmds={"listInv"}, admin=true)
    public boolean listSaves(CommandSender sender, OfflinePlayer p) {
        List<String> dates = InventorySerializer.getDates(p);
        if (dates == null) {
            return BattleArenaExecutor.sendMessage(sender, "There are no inventory saves for this player");
        }
        int i = 0;
        BattleArenaExecutor.sendMessage(sender, "Most recent inventory saves");
        for (String date : dates) {
            BattleArenaExecutor.sendMessage(sender, ++i + " : " + date);
        }
        return true;
    }

    @MCCommand(cmds={"listInv"}, admin=true)
    public boolean listSave(CommandSender sender, OfflinePlayer p, Integer index) {
        if (index < 0 || index > Defaults.NUM_INV_SAVES) {
            return BattleArenaExecutor.sendMessage(sender, "&c index must be between 1-" + Defaults.NUM_INV_SAVES);
        }
        InventoryUtil.PInv pinv = InventorySerializer.getInventory(p, index - 1);
        if (pinv == null) {
            return BattleArenaExecutor.sendMessage(sender, "&cThis index doesn't have an inventory!");
        }
        BattleArenaExecutor.sendMessage(sender, "&6" + p.getName() + " inventory at save " + index);
        boolean has = false;
        for (ItemStack is : pinv.armor) {
            if (is == null || is.getType() == Material.AIR) continue;
            BattleArenaExecutor.sendMessage(sender, "&a armor: &6" + InventoryUtil.getItemString(is));
            has = true;
        }
        for (ItemStack is : pinv.contents) {
            if (is == null || is.getType() == Material.AIR) continue;
            BattleArenaExecutor.sendMessage(sender, "&b inv: &6" + InventoryUtil.getItemString(is));
            has = true;
        }
        if (!has) {
            BattleArenaExecutor.sendMessage(sender, "&cThis index doesn't have any items");
        }
        return true;
    }

    @MCCommand(cmds={"giveInv"}, admin=true)
    public boolean restoreInv(CommandSender sender, ArenaPlayer p, Integer index, Player other) {
        if (index < 0 || index > Defaults.NUM_INV_SAVES) {
            return BattleArenaExecutor.sendMessage(sender, "&c index must be between 1-" + Defaults.NUM_INV_SAVES);
        }
        if (InventorySerializer.giveInventory(p, index - 1, other)) {
            return BattleArenaExecutor.sendMessage(sender, "&2Player inventory given to " + other.getDisplayName());
        }
        return BattleArenaExecutor.sendMessage(sender, "&cPlayer inventory could not be given to " + other.getDisplayName());
    }

    @MCCommand(cmds={"restoreInv"}, admin=true)
    public boolean restoreInv(CommandSender sender, ArenaPlayer p, Integer index) {
        if (index < 0 || index > Defaults.NUM_INV_SAVES) {
            return BattleArenaExecutor.sendMessage(sender, "&c index must be between 1-" + Defaults.NUM_INV_SAVES);
        }
        if (InventorySerializer.giveInventory(p, index - 1, p.getPlayer())) {
            return BattleArenaExecutor.sendMessage(sender, "&2Player inventory restored");
        }
        return BattleArenaExecutor.sendMessage(sender, "&cPlayer inventory could not be restored");
    }

    @MCCommand(cmds={"version"}, admin=true)
    public boolean showVersion(CommandSender sender, String[] args) {
        BattleArenaExecutor.sendMessage(sender, "&6" + BattleArena.getNameAndVersion());
        if (args.length > 1 && args[1].equalsIgnoreCase("all")) {
            HashMap<Plugin, ArrayList<ArenaType>> map = new HashMap<Plugin, ArrayList<ArenaType>>();
            for (ArenaType arenaType : ArenaType.getTypes()) {
                ArrayList<ArenaType> l = (ArrayList<ArenaType>)map.get(arenaType.getPlugin());
                if (l == null) {
                    l = new ArrayList<ArenaType>();
                    map.put(arenaType.getPlugin(), l);
                }
                l.add(arenaType);
            }
            for (Map.Entry entry : map.entrySet()) {
                BattleArenaExecutor.sendMessage(sender, "&6" + ((Plugin)entry.getKey()).getName() + " " + ((Plugin)entry.getKey()).getDescription().getVersion() + "&e games: &f" + StringUtils.join((Collection)((Collection)entry.getValue()), (String)", "));
            }
        } else {
            BattleArenaExecutor.sendMessage(sender, "&2For all game type versions, type &6/ba version all");
        }
        return true;
    }

    @MCCommand(cmds={"reload"}, admin=true, perm="arena.reload")
    public boolean arenaReload(CommandSender sender) {
        BAEventController baec = BattleArena.getBAEventController();
        if (this.ac.hasRunningMatches() || !this.ac.isQueueEmpty() || baec.hasOpenEvent()) {
            BattleArenaExecutor.sendMessage(sender, "&cYou can't reload the config while matches are running or people are waiting in the queue");
            return BattleArenaExecutor.sendMessage(sender, "&cYou can use &6/arena cancel all&c to cancel all matches and clear queues");
        }
        this.ac.stop();
        PlayerController.clearArenaPlayers();
        BattleArena.getSelf().reloadConfig();
        BattleArena.getSelf().reloadCompetitions();
        this.ac.resume();
        return BattleArenaExecutor.sendMessage(sender, "&6BattleArena&e configuration reloaded");
    }

    @MCCommand(cmds={"listClasses"}, admin=true)
    public boolean listArenaClasses(CommandSender sender) {
        Set<ArenaClass> classes = ArenaClassController.getClasses();
        BattleArenaExecutor.sendMessage(sender, "&2Registered classes");
        for (ArenaClass ac : classes) {
            if (ac.equals(ArenaClass.CHOSEN_CLASS) || ac.equals(ArenaClass.SELF_CLASS)) continue;
            BattleArenaExecutor.sendMessage(sender, "&6" + ac.getName() + "&2 : " + ac.getDisplayName());
        }
        return true;
    }

    @MCCommand(cmds={"kick"}, admin=true, perm="arena.kick")
    public boolean arenaKick(CommandSender sender, ArenaPlayer player) {
        ArenaPlayerLeaveEvent event = new ArenaPlayerLeaveEvent(player, player.getTeam(), ArenaPlayerLeaveEvent.QuitReason.KICKED);
        event.callEvent();
        if (event.getMessages() != null && !event.getMessages().isEmpty()) {
            MessageUtil.sendMessage(event.getPlayer(), event.getMessages());
        }
        return BattleArenaExecutor.sendMessage(sender, "&2You have kicked &6" + player.getName());
    }

    @MCCommand(cmds={"stats"}, admin=true, perm="arena.stats")
    public boolean stats(CommandSender sender) {
        return BattleArenaExecutor.sendMessage(sender, "&cNot implemented");
    }

    @MCCommand(cmds={"setAPIKey"}, admin=true, perm="arena.api")
    public boolean setAPIKey(CommandSender sender, String key) {
        BattleArena.getSelf().getBattlePluginsAPI().setAPIKey(key);
        return BattleArenaExecutor.sendMessage(sender, "&2Api-Key set to: &e" + key);
    }
}

