/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.executors;

import java.util.Arrays;
import mc.alk.arena.BattleArena;
import mc.alk.arena.competition.events.Event;
import mc.alk.arena.controllers.BAEventController;
import mc.alk.arena.controllers.TeamController;
import mc.alk.arena.controllers.messaging.MessageHandler;
import mc.alk.arena.executors.BAExecutor;
import mc.alk.arena.executors.MCCommand;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.EventParams;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.StateGraph;
import mc.alk.arena.objects.exceptions.InvalidEventException;
import mc.alk.arena.objects.exceptions.InvalidOptionException;
import mc.alk.arena.objects.joining.TeamJoinObject;
import mc.alk.arena.objects.options.EventOpenOptions;
import mc.alk.arena.objects.options.JoinOptions;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.PermissionsUtil;
import mc.alk.arena.util.TimeUtil;
import org.bukkit.command.CommandSender;

public class EventExecutor
extends BAExecutor {
    protected final BAEventController controller = BattleArena.getBAEventController();

    @MCCommand(cmds={"options"}, admin=true, usage="options", order=2)
    public boolean eventOptions(CommandSender sender, EventParams eventParams) {
        StateGraph tops = eventParams.getThisStateGraph();
        return EventExecutor.sendMessage(sender, tops.getOptionString());
    }

    @MCCommand(cmds={"cancel"}, admin=true, order=2)
    public boolean eventCancel(CommandSender sender, EventParams eventParams) {
        Event event = this.findUnique(sender, eventParams);
        return event == null || this.cancelEvent(sender, event);
    }

    protected Event findUnique(CommandSender sender, EventParams eventParams) {
        BAEventController.SizeEventPair result = this.controller.getUniqueEvent(eventParams);
        if (result.nEvents == 0) {
            EventExecutor.sendMessage(sender, "&cThere are no events open/running of this type");
        } else if (result.nEvents > 1) {
            EventExecutor.sendMessage(sender, "&cThere are multiple events ongoing, please specify the arena of the event. \n&6/" + eventParams.getCommand() + " ongoing &c for a list");
        }
        return result.event;
    }

    @MCCommand(cmds={"cancel"}, admin=true, order=4)
    public boolean eventCancel(CommandSender sender, ArenaPlayer player) {
        Event event = this.controller.getEvent(player);
        if (event == null) {
            return EventExecutor.sendMessage(sender, "&cThere was no event with " + player.getName() + " inside");
        }
        return this.cancelEvent(sender, event);
    }

    public boolean cancelEvent(CommandSender sender, Event event) {
        if (!event.isRunning() && !event.isOpen()) {
            return EventExecutor.sendMessage(sender, "&eA " + event.getCommand() + " is not running");
        }
        this.controller.cancelEvent(event);
        return EventExecutor.sendMessage(sender, "&eYou have canceled the &6" + event.getName());
    }

    @MCCommand(cmds={"start"}, admin=true, usage="start", order=2)
    public boolean eventStart(CommandSender sender, EventParams eventParams, String[] args) {
        boolean forceStart;
        Event event = this.controller.getOpenEvent(eventParams);
        if (event == null) {
            return EventExecutor.sendMessage(sender, "&cThere are no open events right now");
        }
        String name = event.getName();
        if (!event.isOpen()) {
            EventExecutor.sendMessage(sender, "&eYou need to open a " + name + " before starting one");
            return EventExecutor.sendMessage(sender, "&eType &6/" + event.getCommand() + " open <params>&e : to open one");
        }
        boolean bl = forceStart = args.length > 1 && args[1].equalsIgnoreCase("force");
        if (!forceStart && !event.hasEnoughTeams()) {
            int nteams = event.getNTeams();
            int neededTeams = event.getParams().getMinTeams();
            EventExecutor.sendMessage(sender, "&cThe " + name + " only has &6" + nteams + " &cteams and it needs &6" + neededTeams);
            return EventExecutor.sendMessage(sender, "&cIf you really want to start the bukkitEvent anyways. &6/" + event.getCommand() + " start force");
        }
        try {
            this.controller.startEvent(event);
            return EventExecutor.sendMessage(sender, "&2You have started the &6" + name);
        }
        catch (Exception e) {
            EventExecutor.sendMessage(sender, "&cError Starting the &6" + name);
            Log.printStackTrace(e);
            return EventExecutor.sendMessage(sender, "&c" + e.getMessage());
        }
    }

    @MCCommand(cmds={"info"}, usage="info", order=2)
    public boolean eventInfo(CommandSender sender, EventParams eventParams) {
        Event event = this.findUnique(sender, eventParams);
        if (event == null) {
            return true;
        }
        if (!event.isOpen() && !event.isRunning()) {
            return EventExecutor.sendMessage(sender, "&eThere is no open " + event.getCommand() + " right now");
        }
        int size = event.getNTeams();
        String teamOrPlayers = MessageUtil.getTeamsOrPlayers(eventParams.getMaxTeamSize());
        EventExecutor.sendMessage(sender, "&eThere are currently &6" + size + "&e " + teamOrPlayers);
        return EventExecutor.sendMessage(sender, event.getInfo());
    }

    @MCCommand(cmds={"check"}, usage="check", order=2)
    public boolean eventCheck(CommandSender sender, EventParams eventParams) {
        Event event = this.findUnique(sender, eventParams);
        if (event == null) {
            return true;
        }
        if (!event.isOpen()) {
            return EventExecutor.sendMessage(sender, "&eThere is no open &6" + event.getCommand() + "&e right now");
        }
        int size = event.getNTeams();
        String teamOrPlayers = MessageUtil.getTeamsOrPlayers(eventParams.getMaxTeamSize());
        return EventExecutor.sendMessage(sender, "&eThere are currently &6" + size + "&e " + teamOrPlayers + " that have joined");
    }

    @MCCommand(cmds={"join"})
    public boolean join(ArenaPlayer player, MatchParams mp, String[] args) {
        if (mp instanceof EventParams) {
            return this.eventJoin(player, (EventParams)mp, args);
        }
        return true;
    }

    @MCCommand(cmds={"join"}, order=2)
    public boolean eventJoin(ArenaPlayer player, EventParams eventParams, String[] args) {
        this.eventJoin(player, eventParams, args, false);
        return true;
    }

    public boolean eventJoin(ArenaPlayer p, EventParams eventParams, String[] args, boolean adminCommand) {
        Long time;
        JoinOptions jp;
        if (!adminCommand && !PermissionsUtil.hasMatchPerm((CommandSender)p.getPlayer(), eventParams, "join")) {
            EventExecutor.sendSystemMessage(p, "no_join_perms", eventParams.getCommand());
            return false;
        }
        if (this.isDisabled((CommandSender)p.getPlayer(), eventParams)) {
            return true;
        }
        Event event = this.controller.getOpenEvent(eventParams);
        if (event == null) {
            EventExecutor.sendSystemMessage(p, "no_event_open", new Object[0]);
            return false;
        }
        if (!event.canJoin()) {
            EventExecutor.sendSystemMessage(p, "you_cant_join_event_while", event.getCommand(), event.getState());
            return false;
        }
        if (!this.canJoin(p)) {
            return false;
        }
        if (event.waitingToJoin(p)) {
            EventExecutor.sendSystemMessage(p, "you_will_join_when_matched", new Object[0]);
            return false;
        }
        EventParams sq = event.getParams();
        StateGraph tops = sq.getStateOptions();
        if (!tops.playerReady(p, null)) {
            String notReadyMsg = tops.getRequiredString(MessageHandler.getSystemMessage("need_the_following", new Object[0]) + "\n");
            MessageUtil.sendMessage(p, notReadyMsg);
            return false;
        }
        ArenaTeam t = this.teamc.getSelfFormedTeam(p);
        if (t == null) {
            t = TeamController.createTeam(eventParams, p);
        }
        if (!this.canJoin(t, true)) {
            EventExecutor.sendSystemMessage(p, "teammate_cant_join", new Object[0]);
            return EventExecutor.sendMessage(p, "&6/team leave: &cto leave the team");
        }
        try {
            jp = JoinOptions.parseOptions(sq, p, Arrays.copyOfRange(args, 1, args.length));
        }
        catch (InvalidOptionException e) {
            return EventExecutor.sendMessage(p, e.getMessage());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            jp = null;
        }
        if (sq.getMaxTeamSize() < t.size()) {
            EventExecutor.sendSystemMessage(p, "event_invalid_team_size", sq.getMaxTeamSize(), t.size());
            return false;
        }
        if (!event.canJoin(t)) {
            return false;
        }
        if (!this.checkAndRemoveFee(sq, t)) {
            return false;
        }
        TeamJoinObject tqo = new TeamJoinObject(t, sq, jp);
        event.joining(tqo);
        if (sq.getSecondsTillStart() != null && (time = event.getTimeTillStart()) != null) {
            EventExecutor.sendSystemMessage(p, "event_will_start_in", TimeUtil.convertMillisToString(time));
        }
        return true;
    }

    @MCCommand(cmds={"teams"}, usage="teams", admin=true, order=2)
    public boolean eventTeams(CommandSender sender, EventParams eventParams) {
        Event event = this.findUnique(sender, eventParams);
        return event == null || this.eventTeams(sender, event);
    }

    private boolean eventTeams(CommandSender sender, Event event) {
        StringBuilder sb = new StringBuilder();
        for (ArenaTeam t : event.getTeams()) {
            sb.append("\n").append(t.getTeamInfo(null));
        }
        return EventExecutor.sendMessage(sender, sb.toString());
    }

    @MCCommand(cmds={"status"}, usage="status", order=4)
    public boolean eventStatus(CommandSender sender, EventParams eventParams) {
        Event event = this.findUnique(sender, eventParams);
        if (event == null) {
            return true;
        }
        StringBuilder sb = new StringBuilder(event.getStatus());
        this.appendTeamStatus(sender, event, sb);
        return EventExecutor.sendMessage(sender, sb.toString());
    }

    private void appendTeamStatus(CommandSender sender, Event event, StringBuilder sb) {
        if (PermissionsUtil.isAdmin(sender) || sender.hasPermission("arena.event.status")) {
            for (ArenaTeam t : event.getTeams()) {
                sb.append("\n").append(t.getTeamInfo(null));
            }
        }
    }

    @MCCommand(cmds={"result"}, usage="result", order=2)
    public boolean eventResult(CommandSender sender, EventParams eventParams) {
        Event event = this.findUnique(sender, eventParams);
        if (event == null) {
            return true;
        }
        StringBuilder sb = new StringBuilder(event.getResultString());
        if (sb.length() == 0) {
            return EventExecutor.sendMessage(sender, "&eThere are no results for a previous &6" + event.getDisplayName() + "&e right now");
        }
        return EventExecutor.sendMessage(sender, "&eResults for the &6" + event.getDisplayName() + "&e\n" + sb.toString());
    }

    protected void openEvent(Event event, EventOpenOptions eoo) throws InvalidEventException {
        if (eoo.hasOption(EventOpenOptions.EventOpenOption.SILENT)) {
            event.setSilent(true);
        }
        this.controller.addOpenEvent(event);
        if (eoo.hasOption(EventOpenOptions.EventOpenOption.AUTO)) {
            event.autoEvent();
        } else {
            event.openEvent();
        }
        if (eoo.hasOption(EventOpenOptions.EventOpenOption.FORCEJOIN)) {
            event.addAllOnline();
        }
    }
}

