/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.executors;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mc.alk.arena.BattleArena;
import mc.alk.arena.competition.events.Event;
import mc.alk.arena.controllers.EventController;
import mc.alk.arena.controllers.PlayerController;
import mc.alk.arena.controllers.TeamController;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.executors.BAExecutor;
import mc.alk.arena.executors.CustomCommandExecutor;
import mc.alk.arena.executors.MCCommand;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.teams.FormingTeam;
import mc.alk.arena.util.ServerUtil;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamExecutor
extends CustomCommandExecutor {
    private TeamController teamc = BattleArena.getTeamController();
    private BAExecutor bae;

    public TeamExecutor(BAExecutor bae) {
        this.bae = bae;
    }

    @MCCommand(cmds={"list"}, admin=true, usage="list")
    public boolean teamList(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        Collection<ArenaTeam> teams = TeamController.getSelfFormedTeams();
        for (ArenaTeam t : teams) {
            sb.append(t.getTeamInfo(null)).append("\n");
        }
        sb.append("&e# of players = &6").append(teams.size());
        return TeamExecutor.sendMessage(sender, sb.toString());
    }

    @MCCommand(cmds={"add"}, usage="add", perm="arena.team.add")
    public boolean teamJoin(ArenaPlayer player) {
        ArenaTeam t = this.teamc.getSelfFormedTeam(player);
        if (t != null && t.size() > 1) {
            return TeamExecutor.sendMessage(player, "&cYou are already part of a team with &6" + t.getOtherNames(player));
        }
        if (!this.teamc.inFormingTeam(player)) {
            TeamExecutor.sendMessage(player, ChatColor.RED + "You are not part of a forming team");
            return TeamExecutor.sendMessage(player, ChatColor.YELLOW + "Usage: &6/team create <player2> [player3]...");
        }
        FormingTeam ft = this.teamc.getFormingTeam(player);
        ft.sendJoinedPlayersMessage(ChatColor.YELLOW + player.getName() + " has joined the team");
        ft.joinTeam(player);
        TeamExecutor.sendMessage(player, ChatColor.YELLOW + "You have joined the team with");
        TeamExecutor.sendMessage(player, ChatColor.GOLD + ft.toString());
        if (ft.hasAllPlayers()) {
            ft.sendMessage("&2Your team is now complete.  you can now add an event or arena");
            this.teamc.removeFormingTeam(ft);
            this.teamc.addSelfFormedTeam(ft);
        }
        return true;
    }

    @MCCommand(cmds={"create"}, usage="create <player 1> <player 2>...<player x>", perm="arena.team.create")
    public boolean teamCreate(ArenaPlayer player, String[] args) {
        if (args.length < 2) {
            TeamExecutor.sendMessage(player, ChatColor.YELLOW + "create <player 1> <player 2>...<player x>");
            TeamExecutor.sendMessage(player, ChatColor.YELLOW + "You need to have at least 1 person in the team");
            return true;
        }
        if (!this.bae.canJoin(player)) {
            return true;
        }
        HashSet<String> players = new HashSet<String>();
        HashSet<Player> foundplayers = new HashSet<Player>();
        HashSet<String> unfoundplayers = new HashSet<String>();
        players.addAll(Arrays.asList(args).subList(1, args.length));
        if (players.contains(player.getName())) {
            return TeamExecutor.sendMessage(player, ChatColor.YELLOW + "You can not invite yourself to a team");
        }
        ServerUtil.findOnlinePlayers(players, foundplayers, unfoundplayers);
        if (foundplayers.size() < players.size()) {
            TeamExecutor.sendMessage(player, ChatColor.YELLOW + "The following teammates were not found or were not online");
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String n : unfoundplayers) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(n);
                first = false;
            }
            TeamExecutor.sendMessage(player, ChatColor.YELLOW + sb.toString());
            return true;
        }
        Set<ArenaPlayer> foundArenaPlayers = PlayerController.toArenaPlayerSet(foundplayers);
        for (ArenaPlayer p : foundArenaPlayers) {
            ArenaTeam t = this.teamc.getSelfFormedTeam(p);
            if (t != null || !this.bae.canJoin(p, false)) {
                TeamExecutor.sendMessage(player, "&6" + p.getName() + "&e is already part of a team or is in an Event");
                return TeamExecutor.sendMessage(player, "&eCreate team &4cancelled!");
            }
            if (!this.teamc.inFormingTeam(p)) continue;
            TeamExecutor.sendMessage(player, "&6" + p.getName() + "&e is already part of a forming team");
            return TeamExecutor.sendMessage(player, "&eCreate team &4cancelled!");
        }
        foundArenaPlayers.add(player);
        if (!this.ac.hasArenaSize(foundArenaPlayers.size())) {
            TeamExecutor.sendMessage(player, "&6[Warning]&eAn arena for that many players has not been created yet!");
        }
        FormingTeam ft = new FormingTeam(player, foundArenaPlayers);
        this.teamc.addFormingTeam(ft);
        TeamExecutor.sendMessage(player, ChatColor.YELLOW + "You are now forming a team. The others must accept by using &6/team add");
        for (ArenaPlayer p : ft.getPlayers()) {
            if (player.equals(p)) continue;
            TeamExecutor.sendMessage(p, "&eYou have been invited to a team with &6" + ft.getOtherNames(player));
            TeamExecutor.sendMessage(p, "&6/team add&e : to accept: &6/team decline&e to refuse ");
        }
        return true;
    }

    @MCCommand(cmds={"info"}, usage="info")
    public boolean teamInfo(ArenaPlayer player) {
        ArenaTeam team = TeamController.getTeam(player);
        if (team == null) {
            return TeamExecutor.sendMessage(player, "&eYou are not in a team");
        }
        return TeamExecutor.sendMessage(player, team.getTeamInfo(null));
    }

    @MCCommand(cmds={"info"}, min=2, admin=true, usage="info <player>", order=1)
    public boolean teamInfoOther(CommandSender sender, ArenaPlayer player) {
        ArenaTeam team = TeamController.getTeam(player);
        if (team == null) {
            return TeamExecutor.sendMessage(sender, "&ePlayer &6" + player.getName() + "&e is not in a team");
        }
        return TeamExecutor.sendMessage(sender, team.getTeamInfo(null));
    }

    @MCCommand(cmds={"disband", "leave"}, usage="disband")
    public boolean teamDisband(ArenaPlayer player) {
        FormingTeam ft = this.teamc.getFormingTeam(player);
        if (ft != null) {
            this.teamc.removeFormingTeam(ft);
            ft.sendToOtherMembers(player, "&eYour team has been disbanded by " + player.getName());
            TeamExecutor.sendMessage(player, "&2You have disbanded your team with " + ft.getName());
            return true;
        }
        ArenaTeam t = this.teamc.getSelfFormedTeam(player);
        if (t == null) {
            return TeamExecutor.sendMessage(player, "&eYou aren't part of a team");
        }
        if (HeroesController.enabled()) {
            HeroesController.removedFromTeam(t, player.getPlayer());
        }
        this.teamc.removeSelfFormedTeam(t);
        t.sendToOtherMembers(player, "&eYour team has been disbanded by " + player.getName());
        TeamExecutor.sendMessage(player, "&2You have disbanded your team with " + t.getName());
        return true;
    }

    @MCCommand(cmds={"delete"}, usage="delete")
    public boolean teamDelete(CommandSender sender, ArenaPlayer player) {
        ArenaTeam t = this.teamc.getSelfFormedTeam(player);
        if (t == null) {
            return TeamExecutor.sendMessage(sender, ChatColor.YELLOW + player.getName() + " is not part of a team");
        }
        Event ae = EventController.insideEvent(player);
        if (ae != null) {
            ae.leave(player);
        } else {
            this.teamc.removeSelfFormedTeam(t);
        }
        t.sendMessage(ChatColor.YELLOW + "The team has been disbanded ");
        return true;
    }

    @MCCommand(cmds={"decline"}, usage="decline")
    public boolean teamDecline(ArenaPlayer p) {
        FormingTeam t = this.teamc.getFormingTeam(p);
        if (t == null) {
            TeamExecutor.sendMessage(p, ChatColor.YELLOW + "You are not part of a forming team");
            return true;
        }
        t.sendMessage(ChatColor.YELLOW + "The team has been disbanded as " + p.getDisplayName() + " has declined");
        this.teamc.removeFormingTeam(t);
        return true;
    }
}

