/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.executors;

import java.util.Arrays;
import java.util.HashSet;
import mc.alk.arena.BattleArena;
import mc.alk.arena.competition.events.Event;
import mc.alk.arena.competition.events.tournament.TournamentEvent;
import mc.alk.arena.controllers.BAEventController;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.executors.EventExecutor;
import mc.alk.arena.executors.MCCommand;
import mc.alk.arena.objects.EventParams;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.exceptions.InvalidEventException;
import mc.alk.arena.objects.exceptions.InvalidOptionException;
import mc.alk.arena.objects.exceptions.NeverWouldJoinException;
import mc.alk.arena.objects.options.EventOpenOptions;
import mc.alk.arena.util.Log;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class TournamentExecutor
extends EventExecutor
implements CommandExecutor {
    @MCCommand(cmds={"open", "auto"}, admin=true)
    public boolean arenaAuto(CommandSender sender, MatchParams params, String[] args) {
        return this.open(sender, (EventParams)params, args);
    }

    public boolean open(CommandSender sender, EventParams eventParams, String[] args) {
        try {
            this.openIt(sender, eventParams, args);
        }
        catch (InvalidEventException e) {
            TournamentExecutor.sendMessage(sender, e.getMessage());
        }
        catch (Exception e) {
            TournamentExecutor.sendMessage(sender, e.getMessage());
            Log.printStackTrace(e);
        }
        return true;
    }

    public Event openIt(CommandSender sender, EventParams eventParams, String[] args) throws InvalidEventException {
        MatchParams sgp;
        EventOpenOptions eoo;
        BAEventController.SizeEventPair result = this.controller.getUniqueEvent(eventParams);
        Event event = result.event;
        if (event != null) {
            TournamentExecutor.sendMessage(sender, "&4There is already a tournament in progress");
            return null;
        }
        if (args.length < 2) {
            TournamentExecutor.sendMessage(sender, "&cIncorrect command: &6/tourney <open|auto> <matchType> [options...]");
            TournamentExecutor.sendMessage(sender, "&cExample: &6/tourney auto arena");
            return null;
        }
        MatchParams mp = ParamController.getMatchParamCopy(args[1]);
        if (mp == null) {
            TournamentExecutor.sendMessage(sender, "&6" + args[1] + "&c is not a valid match type!");
            TournamentExecutor.sendMessage(sender, "&cCommand: &6/tourney <open|auto> <matchType> [options...]");
            return null;
        }
        eventParams = ParamController.copyParams(eventParams);
        try {
            Arena arena;
            HashSet<Integer> ignoreArgs = new HashSet<Integer>(Arrays.asList(1));
            eoo = EventOpenOptions.parseOptions(args, ignoreArgs, mp);
            sgp = eoo.getParams();
            event = new TournamentEvent(eventParams, eoo);
            if (!TournamentExecutor.isPowerOfTwo(sgp.getMinTeams())) {
                TournamentExecutor.sendMessage(sender, "&cTournament nteams has to be a power of 2! like 2,4,8,16,etc. You have " + sgp.getMinTeams());
                TournamentExecutor.sendMessage(sender, "&c/tourney auto <type> nTeams=2");
                return null;
            }
            if (!TournamentExecutor.isPowerOfTwo(sgp.getMinTeamSize())) {
                TournamentExecutor.sendMessage(sender, "&cTournament teamSize has to be a power of 2! like 1,2,4,8,16,etc. You have " + sgp.getMinTeamSize());
                TournamentExecutor.sendMessage(sender, "&c/tourney auto <type> teamSize=1");
                return null;
            }
            if (sgp.getMaxTeams().equals(Integer.MAX_VALUE) || !sgp.getMinTeams().equals(sgp.getMaxTeams())) {
                TournamentExecutor.sendMessage(sender, "&cNumber of tournament teams must not be a range. Setting to &6nTeam=" + sgp.getMinTeams());
                sgp.setMaxTeams(sgp.getMinTeams());
            }
            if (sgp.getMaxTeamSize().equals(Integer.MAX_VALUE) || !sgp.getMaxTeamSize().equals(sgp.getMinTeamSize())) {
                TournamentExecutor.sendMessage(sender, "&cTournament teams must have a finite size. &eSetting to &6teamSize=" + sgp.getMinTeamSize());
                sgp.setMaxTeamSize(sgp.getMinTeamSize());
            }
            if ((arena = BattleArena.getBAController().getArenaByMatchParams(sgp)) == null) {
                TournamentExecutor.sendMessage(sender, "&cThere is no arena that will fit these parameters. nTeams=" + sgp.getNTeams() + " teamSize=" + sgp.getTeamSize());
            }
            this.openEvent(event, eoo);
        }
        catch (InvalidOptionException e) {
            TournamentExecutor.sendMessage(sender, e.getMessage());
            return null;
        }
        catch (NeverWouldJoinException e) {
            TournamentExecutor.sendMessage(sender, e.getMessage());
            return null;
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return null;
        }
        int max = eventParams.getMaxPlayers();
        String maxPlayers = max == Integer.MAX_VALUE ? "&6any&2 number of players" : max + "&2 players";
        TournamentExecutor.sendMessage(sender, "&2You have " + eoo.getOpenCmd() + "ed a &6" + event.getDisplayName() + " &2TeamSize=&6" + sgp.getTeamSize() + "&2 #Teams=&6" + sgp.getNTeams() + "&2 supporting " + maxPlayers);
        return event;
    }

    public static boolean isPowerOfTwo(int num) {
        return num > 0 && (num == 1 || (num & 1) == 0 && TournamentExecutor.isPowerOfTwo(num >> 1));
    }

    @MCCommand(cmds={"status"}, usage="status", order=1)
    public boolean eventStatus(CommandSender sender, EventParams eventParams, Integer round) {
        BAEventController.SizeEventPair result = this.controller.getUniqueEvent(eventParams);
        if (result.nEvents == 0) {
            return TournamentExecutor.sendMessage(sender, "&cThere are no events open/running of this type");
        }
        if (result.nEvents > 1) {
            return TournamentExecutor.sendMessage(sender, "&cThere are multiple events ongoing, please specify the arena of the event. \n&6/" + eventParams.getCommand() + " ongoing &c for a list");
        }
        if (!(result.event instanceof TournamentEvent)) {
            return TournamentExecutor.sendMessage(sender, "&cThis event isn't a tournament");
        }
        TournamentEvent te = (TournamentEvent)result.event;
        return TournamentExecutor.sendMessage(sender, te.getStatus(round));
    }
}

