/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners;

import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.MoneyController;
import mc.alk.arena.controllers.plugins.CombatTagInterface;
import mc.alk.arena.controllers.plugins.DisguiseInterface;
import mc.alk.arena.controllers.plugins.EssentialsController;
import mc.alk.arena.controllers.plugins.FactionsController;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.controllers.plugins.McMMOController;
import mc.alk.arena.controllers.plugins.MobArenaInterface;
import mc.alk.arena.controllers.plugins.PylamoController;
import mc.alk.arena.controllers.plugins.TagAPIController;
import mc.alk.arena.controllers.plugins.TrackerController;
import mc.alk.arena.controllers.plugins.VanishNoPacketInterface;
import mc.alk.arena.controllers.plugins.WorldGuardController;
import mc.alk.arena.objects.messaging.AnnouncementOptions;
import mc.alk.arena.objects.messaging.plugins.HerochatPlugin;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.PermissionsUtil;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class BAPluginListener
implements Listener {
    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        if (event.getPlugin().getName().equalsIgnoreCase("BattleTracker")) {
            this.loadBattleTracker();
        } else if (event.getPlugin().getName().equalsIgnoreCase("CombatTag")) {
            this.loadCombatTag();
        } else if (event.getPlugin().getName().equalsIgnoreCase("DisguiseCraft")) {
            this.loadDisguiseCraft();
        } else if (event.getPlugin().getName().equalsIgnoreCase("Essentials")) {
            this.loadEssentials();
        } else if (event.getPlugin().getName().equalsIgnoreCase("Factions")) {
            this.loadFactions();
        } else if (event.getPlugin().getName().equalsIgnoreCase("Herochat")) {
            this.loadHeroChat();
        } else if (event.getPlugin().getName().equalsIgnoreCase("Heroes")) {
            this.loadHeroes();
        } else if (event.getPlugin().getName().equalsIgnoreCase("LibsDisguises")) {
            this.loadLibsDisguise();
        } else if (event.getPlugin().getName().equalsIgnoreCase("MobArena")) {
            this.loadMcMMO();
        } else if (event.getPlugin().getName().equalsIgnoreCase("MobArena")) {
            this.loadMobArena();
        } else if (event.getPlugin().getName().equalsIgnoreCase("MultiInv")) {
            this.loadMultiInv();
        } else if (event.getPlugin().getName().equalsIgnoreCase("Multiverse-Core")) {
            this.loadMultiverseCore();
        } else if (event.getPlugin().getName().equalsIgnoreCase("Multiverse-Inventories")) {
            this.loadMultiverseInventory();
        } else if (event.getPlugin().getName().equalsIgnoreCase("PylamoRestorationSystem")) {
            this.loadPylamoRestoration();
        } else if (event.getPlugin().getName().equalsIgnoreCase("TagAPI")) {
            this.loadTagAPI();
        } else if (event.getPlugin().getName().equalsIgnoreCase("WorldEdit")) {
            this.loadWorldEdit();
        } else if (event.getPlugin().getName().equalsIgnoreCase("WorldGuard")) {
            this.loadWorldGuard();
        } else if (event.getPlugin().getName().equalsIgnoreCase("VanishNoPacket")) {
            this.loadVanishNoPacket();
        } else if (event.getPlugin().getName().equalsIgnoreCase("Vault")) {
            this.loadVault();
        } else {
            this.loadOthers();
        }
    }

    public void loadAll() {
        this.loadBattleTracker();
        this.loadCombatTag();
        this.loadDisguiseCraft();
        this.loadEssentials();
        this.loadFactions();
        this.loadHeroChat();
        this.loadHeroes();
        this.loadLibsDisguise();
        this.loadMcMMO();
        this.loadMobArena();
        this.loadMultiInv();
        this.loadMultiverseCore();
        this.loadMultiverseInventory();
        this.loadPylamoRestoration();
        this.loadTagAPI();
        this.loadWorldEdit();
        this.loadWorldGuard();
        this.loadVanishNoPacket();
        this.loadVault();
        this.loadOthers();
    }

    public void loadBattleTracker() {
        if (!TrackerController.enabled()) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin("BattleTracker");
            if (plugin != null) {
                TrackerController.setPlugin(plugin);
            } else {
                Log.info("[BattleArena] BattleTracker not detected, not tracking wins");
            }
        }
    }

    public void loadCombatTag() {
        Plugin plugin;
        if (!CombatTagInterface.enabled() && (plugin = Bukkit.getPluginManager().getPlugin("CombatTag")) != null) {
            CombatTagInterface.setPlugin(plugin);
            Log.info("[BattleArena] CombatTag detected, enabling limited tag support");
        }
    }

    public void loadDisguiseCraft() {
        Plugin plugin;
        if (!DisguiseInterface.hasDC() && (plugin = Bukkit.getPluginManager().getPlugin("DisguiseCraft")) != null) {
            DisguiseInterface.setDisguiseCraft(plugin);
            Log.info("[BattleArena] DisguiseCraft detected, enabling disguises");
        }
    }

    public void loadEssentials() {
        Plugin plugin;
        if (!EssentialsController.enabled() && (plugin = Bukkit.getPluginManager().getPlugin("Essentials")) != null) {
            if (EssentialsController.setPlugin(plugin)) {
                Log.info("[BattleArena] Essentials detected. God mode handling activated");
            } else {
                Log.info("[BattleArena] Essentials detected but could not hook properly");
            }
        }
    }

    public void loadFactions() {
        Plugin plugin;
        if (!FactionsController.enabled() && (plugin = Bukkit.getPluginManager().getPlugin("Factions")) != null) {
            if (FactionsController.setPlugin(true)) {
                Log.info("[BattleArena] Factions detected. Configurable power loss enabled (default no powerloss)");
            } else {
                Log.info("[BattleArena] Old Factions detected that does not have a PowerLossEvent");
            }
        }
    }

    public void loadHeroChat() {
        Plugin plugin;
        if (AnnouncementOptions.chatPlugin == null && (plugin = Bukkit.getPluginManager().getPlugin("Herochat")) != null) {
            AnnouncementOptions.setPlugin(new HerochatPlugin());
            Log.info("[BattleArena] Herochat detected, adding channel options");
        }
    }

    public void loadHeroes() {
        Plugin plugin;
        if (!HeroesController.enabled() && (plugin = Bukkit.getPluginManager().getPlugin("Heroes")) != null) {
            HeroesController.setPlugin(plugin);
            Log.info("[BattleArena] Heroes detected. Implementing heroes class options");
        }
    }

    public void loadLibsDisguise() {
        Plugin plugin;
        if (!DisguiseInterface.hasLibs() && (plugin = Bukkit.getPluginManager().getPlugin("LibsDisguises")) != null) {
            DisguiseInterface.setLibsDisguise(plugin);
            Log.info("[BattleArena] LibsDisguises detected. Implementing disguises");
        }
    }

    public void loadMcMMO() {
        Plugin plugin;
        if (!McMMOController.enabled() && (plugin = Bukkit.getPluginManager().getPlugin("mcMMO")) != null) {
            McMMOController.setEnable(true);
            Log.info("[BattleArena] mcMMO detected. Implementing disabled skills options");
        }
    }

    public void loadMobArena() {
        Plugin plugin;
        if (!MobArenaInterface.hasMobArena() && (plugin = Bukkit.getPluginManager().getPlugin("MobArena")) != null) {
            MobArenaInterface.setPlugin(plugin);
            Log.info("[BattleArena] MobArena detected.  Implementing no add when in MobArena");
        }
    }

    public void loadMultiInv() {
        Plugin plugin;
        if (!Defaults.PLUGIN_MULTI_INV && (plugin = Bukkit.getPluginManager().getPlugin("MultiInv")) != null) {
            Defaults.PLUGIN_MULTI_INV = true;
            Log.info("[BattleArena] MultiInv detected.  Implementing teleport/gamemode workarounds");
        }
    }

    public void loadMultiverseCore() {
        Plugin plugin;
        if (!Defaults.PLUGIN_MULITVERSE_CORE && (plugin = Bukkit.getPluginManager().getPlugin("Multiverse-Core")) != null) {
            Defaults.PLUGIN_MULITVERSE_CORE = true;
            Log.info("[BattleArena] Multiverse-Core detected. Implementing teleport/gamemode workarounds");
        }
    }

    public void loadMultiverseInventory() {
        Plugin plugin;
        if (!Defaults.PLUGIN_MULITVERSE_INV && (plugin = Bukkit.getPluginManager().getPlugin("Multiverse-Inventories")) != null) {
            Defaults.PLUGIN_MULITVERSE_INV = true;
            Log.info("[BattleArena] Multiverse-Inventories detected. Implementing teleport/gamemode workarounds");
        }
    }

    public void loadPylamoRestoration() {
        Plugin plugin;
        if (!PylamoController.enabled() && (plugin = Bukkit.getPluginManager().getPlugin("PylamoRestorationSystem")) != null) {
            PylamoController.setPlugin(plugin);
            Log.info(BattleArena.getPluginName() + " found PylamoRestorationSystem");
        }
    }

    public void loadWorldEdit() {
        Plugin plugin;
        if (!WorldGuardController.hasWorldEdit() && (plugin = Bukkit.getPluginManager().getPlugin("WorldEdit")) != null && WorldGuardController.setWorldEdit(plugin)) {
            Log.info("[BattleArena] WorldEdit detected.");
        }
    }

    public void loadWorldGuard() {
        Plugin plugin;
        if (!WorldGuardController.hasWorldGuard() && (plugin = Bukkit.getServer().getPluginManager().getPlugin("WorldGuard")) != null && WorldGuardController.setWorldGuard(plugin)) {
            Log.info("[BattleArena] WorldGuard detected. WorldGuard regions can now be used");
        }
    }

    public void loadTagAPI() {
        Plugin plugin;
        if (!TagAPIController.enabled() && (plugin = Bukkit.getPluginManager().getPlugin("TagAPI")) != null) {
            TagAPIController.setEnable(true);
            Log.info("[BattleArena] TagAPI detected. Implementing Team colored player names");
        }
    }

    public void loadVanishNoPacket() {
        Plugin plugin;
        if (!VanishNoPacketInterface.enabled() && (plugin = Bukkit.getPluginManager().getPlugin("VanishNoPacket")) != null) {
            VanishNoPacketInterface.setPlugin(plugin);
            Log.info("[BattleArena] VanishNoPacket detected. Invisibility fix is disabled for vanished players not in an arena");
        }
    }

    public void loadVault() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Vault");
        if (plugin != null) {
            RegisteredServiceProvider provider;
            if (!MoneyController.hasEconomy()) {
                try {
                    provider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
                    if (provider == null || provider.getProvider() == null) {
                        Log.warn(BattleArena.getPluginName() + " found no economy plugin. Attempts to use money in arenas might result in errors.");
                        return;
                    }
                    MoneyController.setEconomy((Economy)provider.getProvider());
                    Log.info(BattleArena.getPluginName() + " found economy plugin Vault. [Default]");
                }
                catch (Error e) {
                    Log.err(BattleArena.getPluginName() + " exception loading economy through Vault");
                    Log.printStackTrace(e);
                }
            }
            if (AnnouncementOptions.chat == null) {
                try {
                    provider = Bukkit.getServer().getServicesManager().getRegistration(Chat.class);
                    if (provider != null && provider.getProvider() != null) {
                        AnnouncementOptions.setVaultChat((Chat)provider.getProvider());
                    } else if (AnnouncementOptions.chatPlugin == null) {
                        Log.info("[BattleArena] Vault chat not detected, ignoring channel options");
                    }
                }
                catch (Error e) {
                    Log.err(BattleArena.getPluginName() + " exception loading chat through Vault");
                    Log.printStackTrace(e);
                }
            }
            PermissionsUtil.setPermission(plugin);
        }
    }

    private void loadOthers() {
        if (Bukkit.getPluginManager().getPlugin("AntiLootSteal") != null) {
            Defaults.PLUGIN_ANTILOOT = true;
        }
    }
}

