/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners;

import java.util.HashMap;
import java.util.Map;
import mc.alk.arena.controllers.PlayerController;
import mc.alk.arena.listeners.SignUpdateListener;
import mc.alk.arena.objects.ArenaClass;
import mc.alk.arena.objects.signs.ArenaCommandSign;
import mc.alk.arena.objects.signs.ArenaStatusSign;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.PermissionsUtil;
import mc.alk.arena.util.SignUtil;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class BASignListener
implements Listener {
    SignUpdateListener sul;
    Map<String, ArenaCommandSign> signLocs = new HashMap<String, ArenaCommandSign>();

    public BASignListener(SignUpdateListener sul) {
        this.sul = sul;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null || !event.getClickedBlock().getType().equals((Object)Material.SIGN_POST) && !event.getClickedBlock().getType().equals((Object)Material.WALL_SIGN)) {
            return;
        }
        if (PermissionsUtil.isAdmin((CommandSender)event.getPlayer()) && event.getAction() == Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock().getState() instanceof Sign) {
            String[] lines = ((Sign)event.getClickedBlock().getState()).getLines();
            if (!(lines[0].startsWith("&") || lines[0].startsWith("[") || lines[0].startsWith("\u00a7"))) {
                return;
            }
            ArenaCommandSign acs = this.signLocs.get(this.getKey(event.getClickedBlock().getLocation()));
            if (acs == null && (acs = SignUtil.getArenaCommandSign((Sign)event.getClickedBlock().getState(), ((Sign)event.getClickedBlock().getState()).getLines())) != null) {
                this.signLocs.put(this.getKey(event.getClickedBlock().getLocation()), acs);
            }
            if (acs == null) {
                return;
            }
            event.setCancelled(true);
            this.sul.addSign(acs);
            acs.performAction(PlayerController.toArenaPlayer(event.getPlayer()));
        }
    }

    @EventHandler
    public void onSignChange(SignChangeEvent event) {
        Block block = event.getBlock();
        Material type = block.getType();
        if (!(type.equals((Object)Material.SIGN) || type.equals((Object)Material.SIGN_POST) || type.equals((Object)Material.WALL_SIGN))) {
            return;
        }
        Player p = event.getPlayer();
        boolean admin = PermissionsUtil.isAdmin((CommandSender)p);
        String[] lines = event.getLines();
        ArenaClass ac = SignUtil.getArenaClassSign(lines);
        if (ac != null) {
            if (!admin) {
                BASignListener.cancelSignPlace(event, block);
                return;
            }
            this.makeArenaClassSign(event, ac, lines);
            return;
        }
        ArenaCommandSign acs = SignUtil.getArenaCommandSign((Sign)block.getState(), lines);
        if (acs != null) {
            if (!admin) {
                BASignListener.cancelSignPlace(event, block);
                return;
            }
            this.makeArenaCommandSign(event, acs, lines);
            return;
        }
        ArenaStatusSign ass = SignUtil.getArenaStatusSign(lines);
        if (ass != null) {
            if (!admin) {
                BASignListener.cancelSignPlace(event, block);
                return;
            }
            this.makeArenaStatusSign(event, ass, lines);
        }
    }

    private void makeArenaClassSign(SignChangeEvent event, ArenaClass ac, String[] lines) {
        if (ac == null) {
            return;
        }
        Block block = event.getBlock();
        for (int i = 1; i < lines.length; ++i) {
            if (lines[i].isEmpty()) continue;
            return;
        }
        try {
            event.setLine(0, MessageUtil.colorChat("[" + ac.getDisplayName() + "&0]"));
            MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&2Arena class sign created");
        }
        catch (Exception e) {
            MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&cError creating Arena Class Sign");
            Log.printStackTrace(e);
            BASignListener.cancelSignPlace(event, block);
        }
    }

    private void makeArenaCommandSign(SignChangeEvent event, ArenaCommandSign acs, String[] lines) {
        if (acs == null) {
            return;
        }
        Block block = event.getBlock();
        for (int i = 3; i < lines.length; ++i) {
            if (lines[i].isEmpty()) continue;
            return;
        }
        try {
            String match = acs.getMatchParams().getName().toLowerCase();
            match = Character.toUpperCase(match.charAt(0)) + match.substring(1);
            String str = acs.getMatchParams().getSignDisplayName() != null ? MessageUtil.colorChat(acs.getMatchParams().getSignDisplayName()) : MessageUtil.colorChat("[" + acs.getMatchParams().getColor() + match + "&0]");
            if (str.length() > 15) {
                str = MessageUtil.colorChat("[" + acs.getMatchParams().getColor() + acs.getMatchParams().getCommand().toLowerCase() + "&0]");
            }
            event.setLine(0, str);
            String cmd = acs.getCommand();
            cmd = Character.toUpperCase(cmd.charAt(0)) + cmd.substring(1);
            event.setLine(1, MessageUtil.colorChat(ChatColor.GREEN + cmd.toLowerCase()));
            MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&2Arena command sign created");
            this.sul.addSign(acs);
            this.signLocs.put(this.getKey(acs.getLocation()), acs);
        }
        catch (Exception e) {
            MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&cError creating Arena Command Sign");
            Log.printStackTrace(e);
            BASignListener.cancelSignPlace(event, block);
        }
    }

    private String getKey(Location location) {
        return location.getWorld().getName() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ();
    }

    private void makeArenaStatusSign(SignChangeEvent event, ArenaStatusSign acs, String[] lines) {
        if (acs == null) {
            return;
        }
        Block block = event.getBlock();
        for (int i = 3; i < lines.length; ++i) {
            if (lines[i].isEmpty()) continue;
            return;
        }
        try {
            String match = acs.getType().toLowerCase();
            match = Character.toUpperCase(match.charAt(0)) + match.substring(1);
            event.setLine(0, MessageUtil.colorChat(ChatColor.GOLD + "*" + acs.getMatchParams().getColor() + match));
            event.setLine(1, MessageUtil.colorChat(""));
            acs.setLocation(event.getBlock().getLocation());
            MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&2Arena status sign created");
        }
        catch (Exception e) {
            MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&cError creating Arena Status Sign");
            Log.printStackTrace(e);
            BASignListener.cancelSignPlace(event, block);
        }
    }

    public static void cancelSignPlace(SignChangeEvent event, Block block) {
        event.setCancelled(true);
        block.setType(Material.AIR);
        block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.SIGN, 1));
    }
}

