/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.competition;

import mc.alk.arena.BattleArena;
import mc.alk.arena.listeners.PlayerHolder;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.PVPState;
import mc.alk.arena.objects.StateGraph;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.events.EventPriority;
import mc.alk.arena.objects.options.StateOptions;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.DmgDeathUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.Util;
import mc.alk.arena.util.compat.IEventHelper;
import mc.alk.mc.updater.Version;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class DamageListener
implements ArenaListener {
    StateGraph transitionOptions;
    PlayerHolder holder;
    static IEventHelper handler;

    public DamageListener(PlayerHolder holder) {
        this.transitionOptions = holder.getParams().getStateGraph();
        this.holder = holder;
    }

    @ArenaEventHandler(suppressCastWarnings=true, priority=EventPriority.LOW)
    public void onEntityDamageEvent(EntityDamageEvent event) {
        ArenaPlayer target;
        ArenaPlayer damager = null;
        ArenaPlayer arenaPlayer = target = event.getEntity() instanceof Player ? BattleArena.toArenaPlayer((Player)event.getEntity()) : null;
        if (event instanceof EntityDamageByEntityEvent && event.getEntity() instanceof LivingEntity) {
            Entity damagerEntity = ((EntityDamageByEntityEvent)event).getDamager();
            damager = DmgDeathUtil.getPlayerCause(damagerEntity);
            if (!(damager == null || target != null && damager.getTeam() != null && target.getTeam() != null && target.getTeam().equals(damager.getTeam()))) {
                damager.setTarget((LivingEntity)event.getEntity());
            }
            if (!(target == null || !(damagerEntity instanceof LivingEntity) || target.getTarget() != null && !target.getTarget().isDead() || damager != null && damager.getTeam() != null && target.getTeam() != null && target.getTeam().equals(damager.getTeam()))) {
                target.setTarget((LivingEntity)damagerEntity);
            }
        }
        if (target == null) {
            return;
        }
        StateOptions to = this.transitionOptions.getOptions(this.holder.getState());
        if (to == null) {
            return;
        }
        PVPState pvp = to.getPVP();
        if (pvp == null) {
            return;
        }
        if (pvp == PVPState.INVINCIBLE) {
            target.setFireTicks(0);
            handler.setDamage(event, 0.0);
            event.setCancelled(true);
            return;
        }
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return;
        }
        switch (pvp) {
            case ON: {
                ArenaTeam targetTeam = this.holder.getTeam(target);
                if (targetTeam == null || !targetTeam.hasAliveMember(target)) {
                    return;
                }
                if (damager == null) {
                    return;
                }
                ArenaTeam t = this.holder.getTeam(damager);
                if (t != null && t.hasMember(target)) {
                    event.setCancelled(true);
                    break;
                }
                event.setCancelled(false);
                break;
            }
            case OFF: {
                if (damager == null) break;
                handler.setDamage(event, 0.0);
                event.setCancelled(true);
                break;
            }
        }
    }

    static {
        Class[] args = new Class[]{};
        try {
            Version version = Util.getCraftBukkitVersion();
            if (version.compareTo("v1_6_R1") >= 0) {
                Class<?> clazz = Class.forName("mc.alk.arena.util.compat.v1_6_R1.EventHelper");
                handler = (IEventHelper)clazz.getConstructor(args).newInstance(args);
            } else {
                Class<?> clazz = Class.forName("mc.alk.arena.util.compat.pre.EventHelper");
                handler = (IEventHelper)clazz.getConstructor(args).newInstance(args);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }
}

