/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.competition;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.events.players.ArenaPlayerEnterMatchEvent;
import mc.alk.arena.events.players.ArenaPlayerLeaveMatchEvent;
import mc.alk.arena.util.PlayerUtil;
import mc.alk.arena.util.ServerUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InArenaListener implements Listener
{
    INSTANCE;

    final Set<UUID> inArena = Collections.synchronizedSet(new HashSet());
    final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    AtomicBoolean registered = new AtomicBoolean();
    AtomicBoolean listening = new AtomicBoolean();
    Integer timerid = null;

    @EventHandler
    public void onArenaPlayerEnterEvent(ArenaPlayerEnterMatchEvent event) {
        this.inArena.add(event.getPlayer().getID());
        if (this.listening.getAndSet(true)) {
            return;
        }
        if (!this.registered.getAndSet(true)) {
            if (this.timerid != null) {
                Bukkit.getScheduler().cancelTask(this.timerid.intValue());
                this.timerid = null;
            }
            for (Listener l : this.listeners) {
                Bukkit.getPluginManager().registerEvents(l, (Plugin)BattleArena.getSelf());
            }
        }
    }

    @EventHandler
    public void onArenaPlayerLeaveEvent(ArenaPlayerLeaveMatchEvent event) {
        if (this.inArena.remove(event.getPlayer().getID()) && this.inArena.isEmpty()) {
            this.listening.set(false);
            if (this.timerid != null) {
                Scheduler.cancelTask(this.timerid);
            }
            this.timerid = Scheduler.scheduleSynchronousTask(new Runnable(){

                public void run() {
                    if (InArenaListener.this.registered.getAndSet(false)) {
                        for (Listener l : InArenaListener.this.listeners) {
                            HandlerList.unregisterAll((Listener)l);
                        }
                    }
                    InArenaListener.this.timerid = null;
                }
            }, 600L);
        }
    }

    public boolean isPlayerInArena(UUID id) {
        return this.inArena.contains(id);
    }

    public static boolean inArena(UUID id) {
        return InArenaListener.INSTANCE.inArena.contains(id);
    }

    public static boolean inArena(Player player) {
        return InArenaListener.INSTANCE.inArena.contains(PlayerUtil.getID(player));
    }

    public static boolean inQueue(UUID id) {
        return BattleArena.getBAController().getArenaMatchQueue().isInQue(id);
    }

    @Deprecated
    public static boolean inQueue(String name) {
        Player p = ServerUtil.findOnlinePlayer(name);
        return p != null && BattleArena.getBAController().getArenaMatchQueue().isInQue(PlayerUtil.getID(p));
    }

    public static void addListener(Listener listener) {
        InArenaListener.INSTANCE.listeners.add(listener);
    }
}

