/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.competition;

import mc.alk.arena.listeners.PlayerHolder;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.events.EventPriority;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.util.MessageUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerTeleportListener
implements ArenaListener {
    final PlayerHolder holder;

    public PlayerTeleportListener(PlayerHolder holder) {
        this.holder = holder;
    }

    @ArenaEventHandler(priority=EventPriority.HIGH)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled() || event.getPlayer().hasPermission("arena.teleport.bypass")) {
            return;
        }
        if (this.holder.hasOption(TransitionOption.NOTELEPORT)) {
            MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&cTeleports are disabled in this arena");
            event.setCancelled(true);
            return;
        }
        if (event.getFrom().getWorld().getUID() != event.getTo().getWorld().getUID() && this.holder.hasOption(TransitionOption.NOWORLDCHANGE)) {
            MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&cWorldChanges are disabled in this arena");
            event.setCancelled(true);
        }
    }
}

