/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.competition.plugins;

import com.herocraftonline.heroes.api.events.ExperienceChangeEvent;
import com.herocraftonline.heroes.api.events.SkillUseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mc.alk.arena.BattleArena;
import mc.alk.arena.events.players.ArenaPlayerEnterMatchEvent;
import mc.alk.arena.listeners.competition.InArenaListener;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.PlayerUtil;
import mc.alk.arena.util.ServerUtil;
import mc.alk.arena.util.plugins.HeroesUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HeroesListener implements Listener
{
    INSTANCE;

    final Set<UUID> cancelExpLoss = Collections.synchronizedSet(new HashSet());
    static HashSet<String> disabledSkills;

    public static void enable() {
        Bukkit.getPluginManager().registerEvents((Listener)INSTANCE, (Plugin)BattleArena.getSelf());
    }

    @EventHandler
    public void onArenaPlayerEnterEvent(ArenaPlayerEnterMatchEvent event) {
        HeroesUtil.addedToTeam(event.getTeam(), event.getPlayer().getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void cancelExperienceLoss(ExperienceChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.cancelExpLoss.contains(PlayerUtil.getID(event.getHero().getPlayer()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void skillDisabled(SkillUseEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (!InArenaListener.inArena(event.getPlayer())) {
            return;
        }
        if (event.getSkill().getName().equals("Revive")) {
            Player p;
            Player player = p = event.getArgs().length > 0 ? ServerUtil.findOnlinePlayer(event.getArgs()[0]) : null;
            if (p != null && !InArenaListener.inArena(p)) {
                MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&cYou can't revive a player who is not in the arena!");
                event.setCancelled(true);
            }
        }
        if (!HeroesListener.containsHeroesSkill(event.getSkill().getName())) {
            return;
        }
        event.setCancelled(true);
    }

    public static void setCancelExpLoss(Player player) {
        HeroesListener.INSTANCE.cancelExpLoss.add(PlayerUtil.getID(player));
    }

    public static void removeCancelExpLoss(Player player) {
        HeroesListener.INSTANCE.cancelExpLoss.remove(PlayerUtil.getID(player));
    }

    public static boolean containsHeroesSkill(String skill) {
        return disabledSkills.contains(skill.toLowerCase());
    }

    public static void addDisabledCommands(Collection<String> disabledCommands) {
        if (disabledSkills == null) {
            disabledSkills = new HashSet();
        }
        for (String s : disabledCommands) {
            disabledSkills.add(s.toLowerCase());
        }
    }

    static {
        disabledSkills = new HashSet();
    }
}

