/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.competition.plugins;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import mc.alk.arena.BattleArena;
import mc.alk.arena.events.players.ArenaPlayerEnterMatchEvent;
import mc.alk.arena.events.players.ArenaPlayerLeaveMatchEvent;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.PlayerUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.kitteh.tag.AsyncPlayerReceiveNameTagEvent;
import org.kitteh.tag.TagAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TagAPIListener implements Listener,
ArenaListener
{
    INSTANCE;

    final Map<UUID, ChatColor> playerName = new ConcurrentHashMap<UUID, ChatColor>();

    public static void enable() {
        Bukkit.getPluginManager().registerEvents((Listener)INSTANCE, (Plugin)BattleArena.getSelf());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onNameTag(AsyncPlayerReceiveNameTagEvent event) {
        UUID id = PlayerUtil.getID(event.getNamedPlayer());
        if (this.playerName.containsKey(id)) {
            event.setTag(this.playerName.get(id) + event.getPlayer().getName());
        }
    }

    @ArenaEventHandler
    public void onArenaPlayerEnterEvent(ArenaPlayerEnterMatchEvent event) {
        Player player = event.getPlayer().getPlayer();
        if (!player.isOnline() || !BattleArena.getSelf().isEnabled()) {
            return;
        }
        ArenaTeam team = event.getPlayer().getTeam();
        this.playerName.put(PlayerUtil.getID(player), team.getTeamChatColor());
        try {
            TagAPI.refreshPlayer((Player)player);
        }
        catch (ClassCastException e) {
        }
        catch (NoClassDefFoundError e) {
            Log.err("TagAPI has made class changes");
            Log.printStackTrace(e);
        }
    }

    @ArenaEventHandler
    public void onArenaPlayerLeaveMatchEvent(ArenaPlayerLeaveMatchEvent event) {
        Player player = event.getPlayer().getPlayer();
        if (!player.isOnline() || !BattleArena.getSelf().isEnabled()) {
            return;
        }
        if (this.playerName.remove(PlayerUtil.getID(player)) != null) {
            try {
                TagAPI.refreshPlayer((Player)player);
            }
            catch (ClassCastException e) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

