/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.custom;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import mc.alk.arena.listeners.custom.GeneralEventListener;
import mc.alk.arena.listeners.custom.RListener;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.util.Log;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArenaEventListener
extends GeneralEventListener {
    public ArenaEventListener(Class<? extends Event> bukkitEvent, EventPriority bukkitPriority) {
        super(bukkitEvent, bukkitPriority);
    }

    @Override
    protected synchronized void addMatchListener(RListener rl) {
        Integer count;
        TreeMap<RListener, Integer> l = (TreeMap<RListener, Integer>)this.listeners.get((Object)rl.getPriority());
        if (l == null) {
            l = new TreeMap<RListener, Integer>(new Comparator<RListener>(){

                @Override
                public int compare(RListener o1, RListener o2) {
                    return o1.getListener().equals(o2.getListener()) ? 0 : new Integer(o1.hashCode()).compareTo(o2.hashCode());
                }
            });
            this.listeners.put(rl.getPriority(), l);
        }
        if ((count = (Integer)l.get(rl)) == null) {
            l.put(rl, 1);
            this.handlers = null;
            this.bake();
        } else {
            l.put(rl, count + 1);
        }
    }

    @Override
    protected boolean removeMatchListener(RListener listener) {
        boolean removed;
        Map map = (Map)this.listeners.get((Object)listener.getPriority());
        if (map == null) {
            return false;
        }
        Integer count = (Integer)map.get(listener);
        if (count == null || count == 1) {
            map.remove(listener);
            this.handlers = null;
            removed = true;
        } else {
            map.put(listener, count - 1);
            removed = false;
        }
        return removed;
    }

    public void invokeEvent(Set<ArenaListener> listeners, Event event) {
        for (RListener rl : this.getRegisteredListeners()) {
            if (!listeners.contains(rl.getListener())) continue;
            try {
                rl.getMethod().getMethod().invoke((Object)rl.getListener(), event);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
    }

    @Override
    public void invokeEvent(Event event) {
        for (RListener rl : this.getRegisteredListeners()) {
            try {
                rl.getMethod().getMethod().invoke((Object)rl.getListener(), event);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
    }
}

