/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.custom;

import java.util.concurrent.atomic.AtomicBoolean;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.listeners.custom.RListener;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.TimingUtil;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEventListener
implements Listener {
    final Class<? extends Event> bukkitEvent;
    final EventPriority bukkitPriority;
    static long total = 0L;
    static long count = 0L;
    AtomicBoolean listening = new AtomicBoolean();
    AtomicBoolean registered = new AtomicBoolean();
    Integer timerid = null;
    EventExecutor executor = null;
    static TimingUtil timings;

    public BaseEventListener(Class<? extends Event> bukkitEvent, EventPriority bukkitPriority) {
        this.bukkitEvent = bukkitEvent;
        this.bukkitPriority = bukkitPriority;
    }

    public Class<? extends Event> getEvent() {
        return this.bukkitEvent;
    }

    public void stopListening() {
        this.listening.set(false);
        if (BattleArena.getSelf().isEnabled()) {
            final BaseEventListener bel = this;
            if (this.timerid != null) {
                Bukkit.getScheduler().cancelTask(this.timerid.intValue());
            }
            this.timerid = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)BattleArena.getSelf(), new Runnable(){

                public void run() {
                    if (BaseEventListener.this.registered.getAndSet(false)) {
                        HandlerList.unregisterAll((Listener)bel);
                    }
                    BaseEventListener.this.timerid = null;
                }
            }, 600L);
        }
    }

    public boolean isListening() {
        return this.listening.get();
    }

    public void startListening() {
        if (this.isListening() || Defaults.TESTSERVER) {
            return;
        }
        this.listening.set(true);
        if (this.timerid != null) {
            Bukkit.getScheduler().cancelTask(this.timerid.intValue());
            this.timerid = null;
        }
        if (this.executor == null) {
            if (Bukkit.getPluginManager().useTimings() || Defaults.DEBUG_TIMINGS) {
                if (timings == null) {
                    timings = new TimingUtil();
                }
                this.executor = new EventExecutor(){

                    public void execute(Listener listener, Event event) throws EventException {
                        long startTime = System.nanoTime();
                        if (!BaseEventListener.this.listening.get() || !BaseEventListener.this.bukkitEvent.isAssignableFrom(event.getClass())) {
                            return;
                        }
                        TimingUtil.TimingStat t = timings.getOrCreate(event.getClass().getSimpleName());
                        try {
                            BaseEventListener.this.invokeEvent(event);
                        }
                        catch (Throwable e) {
                            Log.printStackTrace(e);
                        }
                        ++t.count;
                        t.totalTime += System.nanoTime() - startTime;
                    }
                };
            } else {
                this.executor = new EventExecutor(){

                    public void execute(Listener listener, Event event) throws EventException {
                        if (!BaseEventListener.this.listening.get() || !BaseEventListener.this.bukkitEvent.isAssignableFrom(event.getClass())) {
                            return;
                        }
                        try {
                            BaseEventListener.this.invokeEvent(event);
                        }
                        catch (Throwable e) {
                            Log.printStackTrace(e);
                        }
                    }
                };
            }
        }
        if (Defaults.TESTSERVER) {
            return;
        }
        if (!this.registered.getAndSet(true)) {
            Bukkit.getPluginManager().registerEvent(this.bukkitEvent, (Listener)this, this.bukkitPriority, this.executor, (Plugin)BattleArena.getSelf());
        }
    }

    public abstract void invokeEvent(Event var1);

    public abstract boolean hasListeners();

    public abstract void removeAllListeners(RListener var1);
}

