/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.custom;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mc.alk.arena.listeners.custom.ArenaEventListener;
import mc.alk.arena.listeners.custom.BukkitEventListener;
import mc.alk.arena.listeners.custom.RListener;
import mc.alk.arena.listeners.custom.SpecificArenaPlayerEventListener;
import mc.alk.arena.listeners.custom.SpecificPlayerEventListener;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.events.ArenaEventMethod;
import org.bukkit.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BukkitEventHandler {
    BukkitEventListener bel;
    ArenaEventListener ael;
    SpecificPlayerEventListener spl;
    SpecificArenaPlayerEventListener sapl;

    public BukkitEventHandler(Class<? extends Event> bukkitEvent, ArenaEventMethod aem) {
        if (aem.getPlayerMethod() != null) {
            if (aem.isSpecificArenaPlayerMethod()) {
                this.sapl = new SpecificArenaPlayerEventListener(bukkitEvent, aem.getBukkitPriority(), aem.getPlayerMethod());
            } else {
                this.spl = new SpecificPlayerEventListener(bukkitEvent, aem.getBukkitPriority(), aem.getPlayerMethod());
            }
        } else if (aem.isBAEvent()) {
            this.ael = new ArenaEventListener(bukkitEvent, aem.getBukkitPriority());
        } else {
            this.bel = new BukkitEventListener(bukkitEvent, aem.getBukkitPriority(), null);
        }
    }

    public boolean hasListeners() {
        return this.ael != null && this.ael.hasListeners() || this.bel != null && this.bel.hasListeners() || this.sapl != null && this.sapl.hasListeners() || this.spl != null && this.spl.hasListeners();
    }

    public void addListener(RListener rl, Collection<UUID> players) {
        if (players != null && rl.isSpecificPlayerMethod()) {
            if (rl.isSpecificArenaPlayerMethod()) {
                this.sapl.addListener(rl, players);
            } else {
                this.spl.addListener(rl, players);
            }
        } else if (rl.getMethod().isBAEvent()) {
            this.ael.addListener(rl);
        } else {
            this.bel.addListener(rl);
        }
    }

    public void removeListener(RListener rl, Collection<UUID> players) {
        if (players != null && rl.isSpecificPlayerMethod()) {
            if (rl.isSpecificArenaPlayerMethod()) {
                this.sapl.removeListener(rl, players);
            } else {
                this.spl.removeListener(rl, players);
            }
        } else if (rl.getMethod().isBAEvent()) {
            this.ael.removeListener(rl);
        } else {
            this.bel.removeListener(rl);
        }
    }

    public void removeAllListener(RListener rl) {
        if (this.spl != null) {
            this.spl.removeAllListeners(rl);
        }
        if (this.sapl != null) {
            this.sapl.removeAllListeners(rl);
        }
        if (this.ael != null) {
            this.ael.removeAllListeners(rl);
        }
        if (this.bel != null) {
            this.bel.removeAllListeners(rl);
        }
    }

    public ArenaEventListener getMatchListener() {
        return this.ael;
    }

    public SpecificPlayerEventListener getSpecificPlayerListener() {
        return this.spl;
    }

    public SpecificArenaPlayerEventListener getSpecificArenaPlayerListener() {
        return this.sapl;
    }

    public void invokeArenaEvent(Set<ArenaListener> listeners, Event event) {
        if (this.ael != null) {
            this.ael.invokeEvent(listeners, event);
        }
    }
}

