/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.custom;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import mc.alk.arena.listeners.custom.BaseEventListener;
import mc.alk.arena.listeners.custom.RListener;
import mc.alk.arena.objects.events.EventPriority;
import org.bukkit.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GeneralEventListener
extends BaseEventListener {
    public final EnumMap<EventPriority, Map<RListener, Integer>> listeners = new EnumMap(EventPriority.class);
    protected volatile RListener[] handlers = null;

    public GeneralEventListener(Class<? extends Event> bukkitEvent, org.bukkit.event.EventPriority bukkitPriority) {
        super(bukkitEvent, bukkitPriority);
    }

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public EnumMap<EventPriority, Map<RListener, Integer>> getListeners() {
        return this.listeners;
    }

    public void addListener(RListener rl) {
        this.addMatchListener(rl);
    }

    public synchronized void removeListener(RListener rl) {
        this.removeMatchListener(rl);
    }

    @Override
    public synchronized void removeAllListeners(RListener rl) {
        this.removeMatchListener(rl);
    }

    protected abstract void addMatchListener(RListener var1);

    protected abstract boolean removeMatchListener(RListener var1);

    protected synchronized void bake() {
        if (this.handlers != null) {
            return;
        }
        ArrayList<RListener> entries = new ArrayList<RListener>();
        for (Map.Entry<EventPriority, Map<RListener, Integer>> entry : this.listeners.entrySet()) {
            entries.addAll(entry.getValue().keySet());
        }
        this.handlers = entries.toArray(new RListener[entries.size()]);
    }

    public RListener[] getRegisteredListeners() {
        RListener[] handlers;
        while (true) {
            handlers = this.handlers;
            if (this.handlers != null) break;
            this.bake();
        }
        return handlers;
    }
}

