/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.custom;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mc.alk.arena.Defaults;
import mc.alk.arena.events.BAEvent;
import mc.alk.arena.listeners.custom.BukkitEventHandler;
import mc.alk.arena.listeners.custom.RListener;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.events.ArenaEventMethod;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MapOfTreeSet;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.TimingUtil;
import mc.alk.arena.util.Util;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodController {
    static final EnumMap<EventPriority, HashMap<Type, BukkitEventHandler>> bukkitListeners = new EnumMap(EventPriority.class);
    static final HashMap<Class<? extends ArenaListener>, HashMap<Class<? extends Event>, List<ArenaEventMethod>>> bukkitEventMethods = new HashMap();
    static final HashMap<Class<? extends ArenaListener>, HashMap<Class<? extends BAEvent>, List<ArenaEventMethod>>> matchEventMethods = new HashMap();
    private final HashMap<Class<? extends Event>, List<RListener>> bukkitMethods = new HashMap();
    private final HashMap<Class<? extends BAEvent>, List<RListener>> matchMethods = new HashMap();
    static final Set<MethodController> controllers = new HashSet<MethodController>();
    static int controllerCount = 0;
    final Set<ArenaListener> listeners = new HashSet<ArenaListener>();
    final Object owner;
    final BAEventCaller baexecutor;
    static TimingUtil timings;
    MatchState curState = MatchState.NONE;

    public MethodController(Object owner) {
        this.owner = owner;
        ++controllerCount;
        if (Bukkit.getPluginManager().useTimings() || Defaults.DEBUG_TIMINGS) {
            if (timings == null) {
                timings = new TimingUtil();
            }
            this.baexecutor = new BAEventCaller(){

                public void callEvent(BAEvent event) {
                    TimingUtil.TimingStat t = timings.getOrCreate(((Object)((Object)event)).getClass().getSimpleName());
                    long startTime = System.nanoTime();
                    Class<?> clazz = ((Object)((Object)event)).getClass();
                    for (HashMap<Type, BukkitEventHandler> ls : bukkitListeners.values()) {
                        BukkitEventHandler beh = ls.get(clazz);
                        if (beh == null) continue;
                        beh.invokeArenaEvent(MethodController.this.listeners, event);
                    }
                    event.callEvent();
                    ++t.count;
                    t.totalTime += System.nanoTime() - startTime;
                }
            };
        } else {
            this.baexecutor = new BAEventCaller(){

                public void callEvent(BAEvent event) {
                    Class<?> clazz = ((Object)((Object)event)).getClass();
                    for (HashMap<Type, BukkitEventHandler> ls : bukkitListeners.values()) {
                        BukkitEventHandler beh = ls.get(clazz);
                        if (beh == null) continue;
                        beh.invokeArenaEvent(MethodController.this.listeners, event);
                    }
                    event.callEvent();
                }
            };
        }
    }

    public static EnumMap<EventPriority, HashMap<Type, BukkitEventHandler>> getEventListeners() {
        return bukkitListeners;
    }

    public void updateEvents(MatchState matchState, ArenaPlayer player) {
        ArrayList<UUID> players = new ArrayList<UUID>();
        players.add(player.getID());
        this.updateEvents((ArenaListener)null, matchState, (List<UUID>)players);
    }

    public void updateEvents(MatchState matchState, Collection<ArenaPlayer> players) {
        ArrayList<UUID> strplayers = new ArrayList<UUID>();
        for (ArenaPlayer ap : players) {
            strplayers.add(ap.getID());
        }
        this.updateEvents((ArenaListener)null, matchState, (List<UUID>)strplayers);
    }

    public void updateEvents(ArenaListener listener, MatchState matchState, Collection<ArenaPlayer> players) {
        ArrayList<UUID> strplayers = new ArrayList<UUID>();
        for (ArenaPlayer ap : players) {
            strplayers.add(ap.getID());
        }
        this.updateEvents(listener, matchState, (List<UUID>)strplayers);
    }

    public void updateEventsRange(ArenaListener listener, MatchState beginState, MatchState endState, List<UUID> players) {
        for (MatchState ms : MatchState.values()) {
            if (ms.ordinal() < beginState.ordinal()) continue;
            if (ms.ordinal() > endState.ordinal()) break;
            this.updateEvents(listener, ms, players);
        }
    }

    public void updateEvents(ArenaListener listener, MatchState matchState, List<UUID> players) {
        try {
            Set<Class<? extends Event>> keys = this.bukkitMethods.keySet();
            for (Class clazz : keys) {
                this.updateEvent(listener, matchState, players, clazz);
            }
            Set<Class<? extends BAEvent>> mkeys = this.matchMethods.keySet();
            for (Class clazz : mkeys) {
                this.updateBAEvent(listener, matchState, players, clazz);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void updateSpecificEvents(MatchState matchState, ArenaPlayer player, Class<? extends Event> ... events) {
        try {
            ArrayList<UUID> players = new ArrayList<UUID>();
            players.add(player.getID());
            for (Class<? extends Event> event : events) {
                this.updateEvent(null, matchState, players, event);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    private void updateEvent(ArenaListener listener, MatchState matchState, Collection<UUID> players, Class<? extends Event> event) {
        List<RListener> rls = this.bukkitMethods.get(event);
        if (rls == null || rls.isEmpty()) {
            return;
        }
        for (RListener rl : rls) {
            if (listener != null && !rl.getListener().equals(listener)) continue;
            ArenaEventMethod mem = rl.getMethod();
            if (mem.getBeginState() == matchState) {
                BukkitEventHandler bel = this.getCreate(event, mem);
                bel.addListener(rl, players);
                continue;
            }
            if (mem.getEndState() != matchState) continue;
            for (HashMap<Type, BukkitEventHandler> ls : bukkitListeners.values()) {
                BukkitEventHandler bel = ls.get(event);
                if (bel == null) continue;
                bel.removeListener(rl, players);
            }
        }
    }

    private BukkitEventHandler getCreateBA(Class<? extends BAEvent> event, ArenaEventMethod mem) {
        BukkitEventHandler gel;
        HashMap<Type, BukkitEventHandler> gels = bukkitListeners.get(mem.getBukkitPriority());
        if (gels == null) {
            gels = new HashMap();
            bukkitListeners.put(mem.getBukkitPriority(), gels);
        }
        if ((gel = gels.get(event)) == null) {
            gel = new BukkitEventHandler(event, mem);
            gels.put(event, gel);
        }
        return gel;
    }

    private void updateBAEvent(ArenaListener listener, MatchState matchState, Collection<UUID> players, Class<? extends BAEvent> event) {
        List<RListener> rls = this.matchMethods.get(event);
        if (rls == null || rls.isEmpty()) {
            return;
        }
        for (RListener rl : rls) {
            if (listener != null && !rl.getListener().equals(listener)) continue;
            ArenaEventMethod mem = rl.getMethod();
            if (mem.getBeginState() == matchState) {
                BukkitEventHandler bel = this.getCreateBA(event, mem);
                bel.addListener(rl, players);
                continue;
            }
            if (mem.getEndState() != matchState) continue;
            for (HashMap<Type, BukkitEventHandler> ls : bukkitListeners.values()) {
                BukkitEventHandler bel = ls.get(event);
                if (bel == null) continue;
                bel.removeListener(rl, players);
            }
        }
    }

    private BukkitEventHandler getCreate(Class<? extends Event> event, ArenaEventMethod mem) {
        BukkitEventHandler gel;
        HashMap<Type, BukkitEventHandler> gels = bukkitListeners.get(mem.getBukkitPriority());
        if (gels == null) {
            gels = new HashMap();
            bukkitListeners.put(mem.getBukkitPriority(), gels);
        }
        if ((gel = gels.get(event)) == null) {
            gel = new BukkitEventHandler(event, mem);
            gels.put(event, gel);
        }
        return gel;
    }

    public static List<ArenaEventMethod> getMethods(ArenaListener ael, Event event) {
        return MethodController.getMethods(ael, event.getClass());
    }

    private static List<ArenaEventMethod> getMethods(ArenaListener ael, Class<? extends Event> eventClass) {
        HashMap<Class<? extends Event>, List<ArenaEventMethod>> typeMap = bukkitEventMethods.get(ael.getClass());
        if (typeMap == null) {
            return null;
        }
        return typeMap.get(eventClass);
    }

    private static Map<Class<? extends Event>, List<ArenaEventMethod>> getBukkitMethods(ArenaListener ael) {
        return bukkitEventMethods.get(ael.getClass());
    }

    private static Map<Class<? extends BAEvent>, List<ArenaEventMethod>> getMatchMethods(ArenaListener ael) {
        return matchEventMethods.get(ael.getClass());
    }

    private static void addMethods(Class<? extends ArenaListener> alClass) {
        Method[] methodArray;
        HashMap bukkitTypeMap = new HashMap();
        HashMap matchTypeMap = new HashMap();
        for (Method method : methodArray = alClass.getMethods()) {
            ArrayList<ArenaEventMethod> mths;
            Method getEntityMethod;
            Method getLivingMethod;
            Method getPlayerMethod;
            boolean baEvent;
            Class<?> bukkitEvent;
            Class<?>[] classes;
            mc.alk.arena.objects.events.EventPriority priority;
            EventPriority bukkitPriority;
            boolean suppressWarnings;
            boolean supressCastWarnings;
            MatchState cancelState;
            MatchState endState;
            MatchState beginState;
            block34: {
                ArenaEventHandler aeh = method.getAnnotation(ArenaEventHandler.class);
                if (aeh == null) continue;
                beginState = aeh.begin();
                endState = aeh.end();
                cancelState = MatchState.NONE;
                boolean needsPlayer = aeh.needsPlayer();
                String entityMethod = aeh.entityMethod();
                supressCastWarnings = aeh.suppressCastWarnings();
                suppressWarnings = aeh.suppressWarnings();
                bukkitPriority = aeh.bukkitPriority();
                priority = aeh.priority();
                classes = method.getParameterTypes();
                if (classes.length == 0 || !Event.class.isAssignableFrom(classes[0])) {
                    System.err.println("Bukkit Event was null for method " + method);
                    continue;
                }
                bukkitEvent = classes[0];
                baEvent = BAEvent.class.isAssignableFrom(bukkitEvent);
                getPlayerMethod = null;
                getLivingMethod = null;
                getEntityMethod = null;
                if (needsPlayer) {
                    ArrayList<Method> playerMethods = new ArrayList<Method>();
                    ArrayList<Method> entityMethods = new ArrayList<Method>();
                    for (Method m : bukkitEvent.getMethods()) {
                        if (!entityMethod.isEmpty() && m.getName().equals(entityMethod)) {
                            getPlayerMethod = m;
                            break;
                        }
                        Class<?> t = m.getReturnType();
                        if (Player.class.isAssignableFrom(t) || HumanEntity.class.isAssignableFrom(t) || ArenaPlayer.class.isAssignableFrom(t)) {
                            playerMethods.add(m);
                            getPlayerMethod = m;
                            continue;
                        }
                        if (!Entity.class.isAssignableFrom(t)) continue;
                        entityMethods.add(m);
                        getLivingMethod = m;
                    }
                    if (getPlayerMethod == null) {
                        if (!playerMethods.isEmpty()) {
                            if (playerMethods.size() > 1) {
                                for (Method m : playerMethods) {
                                    if (!m.getName().equals("getPlayer")) continue;
                                    System.out.println(alClass + ". Method " + method.getName() + " has multiple methods that return a player");
                                    System.out.println(alClass + ". defaulting to getPlayer()");
                                    System.out.println(alClass + ". To specify use @ArenaEventHandler(entityMethod=\"methodWhichYouWantToUse\")");
                                    System.out.println(alClass + ". to suppress this warning @ArenaEventHandler(suppressWarnings=true)");
                                    getPlayerMethod = m;
                                }
                                if (getPlayerMethod == null) {
                                    System.err.println(alClass + ". Method " + method.getName() + " has multiple methods that return a player");
                                    System.err.println(alClass + ". Use @ArenaEventHandler(entityMethod=\"methodWhichYouWantToUse\")");
                                    return;
                                }
                            } else {
                                getPlayerMethod = (Method)playerMethods.get(0);
                            }
                        } else if (!entityMethods.isEmpty()) {
                            if (bukkitEvent == EntityDeathEvent.class) {
                                try {
                                    getEntityMethod = EntityDeathEvent.class.getMethod("getEntity", new Class[0]);
                                    break block34;
                                }
                                catch (Exception e) {
                                    Log.printStackTrace(e);
                                    continue;
                                }
                            }
                            if (entityMethods.size() > 1 && !EntityDamageEvent.class.isAssignableFrom(bukkitEvent)) {
                                System.err.println(alClass + ". Method " + method.getName() + " has multiple methods that return an entity");
                                System.err.println(alClass + ". Use @MatchEventHandler(entityMethod=\"methodWhichYouWantToUse\")");
                                return;
                            }
                            getEntityMethod = (Method)entityMethods.get(0);
                        }
                    }
                }
            }
            for (int i = 1; i < classes.length; ++i) {
                boolean noEntityMethod;
                boolean needsTeamOrPlayer;
                Class<?> c = classes[i];
                boolean bl = needsTeamOrPlayer = Player.class.isAssignableFrom(c) || ArenaTeam.class.isAssignableFrom(c);
                if (!needsTeamOrPlayer) continue;
                boolean bl2 = noEntityMethod = getEntityMethod == null && getLivingMethod == null && getPlayerMethod == null;
                if (noEntityMethod) {
                    System.err.println("[BattleArena] " + alClass + ". Method " + method.getName() + " needs a player or team, but the bukkitEvent " + bukkitEvent.getCanonicalName() + "returns no player, and no entities. Class=" + alClass);
                    return;
                }
                if (getLivingMethod != null && !supressCastWarnings && !suppressWarnings) {
                    if (EntityDamageByEntityEvent.class.isAssignableFrom(bukkitEvent)) continue;
                    Log.warn("[BattleArena] Warning. " + alClass + ". Method " + method.getName() + " needs a player or team, but the bukkitEvent " + bukkitEvent.getCanonicalName() + " returns only a living entity. Cast to Player will be attempted at runtime");
                    continue;
                }
                if (getEntityMethod == null || supressCastWarnings || suppressWarnings || EntityDamageByEntityEvent.class.isAssignableFrom(bukkitEvent)) continue;
                Log.warn("[BattleArena] Warning. " + alClass + ". Method " + method.getName() + " needs a player or team, but the bukkitEvent " + bukkitEvent.getCanonicalName() + " returns only an Entity. Cast to Player will be attempted at runtime");
            }
            if (getPlayerMethod == null) {
                getPlayerMethod = getLivingMethod;
            }
            if (getPlayerMethod == null) {
                getPlayerMethod = getEntityMethod;
            }
            List<ArenaEventMethod> list = mths = baEvent ? (ArrayList<ArenaEventMethod>)matchTypeMap.get(bukkitEvent) : (List)bukkitTypeMap.get(bukkitEvent);
            if (mths == null) {
                mths = new ArrayList<ArenaEventMethod>();
                if (baEvent) {
                    matchTypeMap.put(bukkitEvent, mths);
                } else {
                    bukkitTypeMap.put(bukkitEvent, mths);
                }
            }
            if (getPlayerMethod != null) {
                if (beginState == MatchState.NONE) {
                    beginState = MatchState.ONENTER;
                }
                if (endState == MatchState.NONE) {
                    endState = MatchState.ONLEAVE;
                }
                if (cancelState == MatchState.NONE) {
                    cancelState = MatchState.ONCANCEL;
                }
                mths.add(new ArenaEventMethod(method, bukkitEvent, getPlayerMethod, beginState, endState, cancelState, priority, bukkitPriority, baEvent));
            } else {
                if (beginState == MatchState.NONE) {
                    beginState = MatchState.ONCREATE;
                }
                if (endState == MatchState.NONE) {
                    endState = MatchState.ONFINISH;
                }
                if (cancelState == MatchState.NONE) {
                    cancelState = MatchState.ONCANCEL;
                }
                mths.add(new ArenaEventMethod(method, bukkitEvent, beginState, endState, cancelState, priority, bukkitPriority, baEvent));
            }
            Collections.sort(mths, new Comparator<ArenaEventMethod>(){

                @Override
                public int compare(ArenaEventMethod o1, ArenaEventMethod o2) {
                    return o1.getPriority().compareTo(o2.getPriority());
                }
            });
        }
        bukkitEventMethods.put(alClass, bukkitTypeMap);
        matchEventMethods.put(alClass, matchTypeMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeListener(ArenaListener listener, HashMap<?, List<RListener>> methods) {
        HashMap<?, List<RListener>> hashMap = methods;
        synchronized (hashMap) {
            for (List<RListener> rls : methods.values()) {
                Iterator<RListener> iter = rls.iterator();
                while (iter.hasNext()) {
                    RListener rl = iter.next();
                    if (rl.getListener() != listener) continue;
                    iter.remove();
                    for (HashMap<Type, BukkitEventHandler> ls : bukkitListeners.values()) {
                        BukkitEventHandler bel = ls.get(rl.getMethod().getBAEvent());
                        if (bel == null) continue;
                        bel.removeAllListener(rl);
                    }
                }
            }
            return true;
        }
    }

    public boolean removeListener(ArenaListener listener) {
        this.listeners.remove(listener);
        this.removeListener(listener, this.bukkitMethods);
        this.removeListener(listener, this.matchMethods);
        return true;
    }

    public void addListener(ArenaListener listener) {
        this.listeners.add(listener);
        this.addAllEvents(listener);
    }

    public void addAllEvents(ArenaListener listener) {
        Map<Class<? extends BAEvent>, List<ArenaEventMethod>> map2;
        Map<Class<? extends Event>, List<ArenaEventMethod>> map;
        if (!bukkitEventMethods.containsKey(listener.getClass()) && !matchEventMethods.containsKey(listener.getClass())) {
            MethodController.addMethods(listener.getClass());
        }
        if ((map = MethodController.getBukkitMethods(listener)) != null) {
            for (Class<? extends Event> clazz : map.keySet()) {
                this.addEventMethod(listener, map, clazz);
            }
        }
        if ((map2 = MethodController.getMatchMethods(listener)) != null) {
            for (Class<? extends BAEvent> clazz : map2.keySet()) {
                this.addBAEventMethod(listener, map2, clazz);
            }
        }
    }

    public void addSpecificEvents(ArenaListener listener, List<Class<? extends Event>> events) {
        if (!bukkitEventMethods.containsKey(listener.getClass()) && !matchEventMethods.containsKey(listener.getClass())) {
            MethodController.addMethods(listener.getClass());
        }
        Map<Class<? extends Event>, List<ArenaEventMethod>> map = MethodController.getBukkitMethods(listener);
        Map<Class<? extends BAEvent>, List<ArenaEventMethod>> map2 = MethodController.getMatchMethods(listener);
        for (Class<? extends Event> clazz : events) {
            if (BAEvent.class.isAssignableFrom(clazz)) {
                this.addBAEventMethod(listener, map2, clazz);
                continue;
            }
            this.addEventMethod(listener, map, clazz);
        }
    }

    private void addEventMethod(ArenaListener listener, Map<Class<? extends Event>, List<ArenaEventMethod>> map, Class<? extends Event> clazz) {
        List<ArenaEventMethod> list = map.get(clazz);
        if (list == null || list.isEmpty()) {
            return;
        }
        List<RListener> rls = this.bukkitMethods.get(clazz);
        if (rls == null) {
            rls = new ArrayList<RListener>();
            this.bukkitMethods.put(clazz, rls);
        }
        for (ArenaEventMethod mem : list) {
            rls.add(new RListener(listener, mem));
        }
        Collections.sort(rls, new RListener.RListenerPriorityComparator());
    }

    private void addBAEventMethod(ArenaListener listener, Map<Class<? extends BAEvent>, List<ArenaEventMethod>> map, Class<? extends BAEvent> clazz) {
        List<ArenaEventMethod> list = map.get(clazz);
        if (list == null || list.isEmpty()) {
            return;
        }
        List<RListener> rls = this.matchMethods.get(clazz);
        if (rls == null) {
            rls = new ArrayList<RListener>();
            this.matchMethods.put(clazz, rls);
        }
        for (ArenaEventMethod mem : list) {
            RListener rl = new RListener(listener, mem);
            rls.add(rl);
        }
        Collections.sort(rls, new RListener.RListenerPriorityComparator());
    }

    public void deconstruct() {
        --controllerCount;
    }

    public static boolean showAllListeners(String player) {
        return MethodController.showAllListeners((CommandSender)Bukkit.getConsoleSender(), player);
    }

    public static boolean showAllListeners(CommandSender sender, String limitToPlayer) {
        MessageUtil.sendMessage(sender, "&2# &e-!! controller=&5" + controllers.size() + "&e : &5" + controllerCount + "&e !!- &2#");
        EnumMap<EventPriority, HashMap<Type, BukkitEventHandler>> gels = MethodController.getEventListeners();
        for (EventPriority bp : gels.keySet()) {
            MessageUtil.sendMessage(sender, "&4#### &e----!! Bukkit Priority=&5" + bp + "&e !!---- &4####");
            HashMap<Type, BukkitEventHandler> types = gels.get(bp);
            for (BukkitEventHandler bel : types.values()) {
                Collection rls;
                Object p;
                String has;
                String str;
                MapOfTreeSet<UUID, RListener> lists2;
                if (bel.getSpecificPlayerListener() != null) {
                    lists2 = bel.getSpecificPlayerListener().getListeners();
                    str = StringUtils.join(bel.getSpecificPlayerListener().getPlayers(), (String)", ");
                    String string = has = bel.hasListeners() ? "&2true" : "&cfalse";
                    if (!lists2.isEmpty()) {
                        MessageUtil.sendMessage(sender, "---- Event &e" + bel.getSpecificPlayerListener().getEvent().getSimpleName() + "&e:" + has + "&e, players=" + str);
                    }
                    for (UUID uUID : lists2.keySet()) {
                        p = null;
                        if (limitToPlayer != null && p != null && !p.getName().equalsIgnoreCase(limitToPlayer)) continue;
                        rls = (Collection)lists2.get(uUID);
                        for (RListener rl : rls) {
                            MessageUtil.sendMessage(sender, "!! " + (Object)((Object)rl.getPriority()) + "  " + p + "  Listener  " + rl.getListener().getClass().getSimpleName() + " hash=" + Util.toString(rl.getListener()));
                        }
                    }
                }
                if (bel.getSpecificArenaPlayerListener() != null) {
                    lists2 = bel.getSpecificArenaPlayerListener().getListeners();
                    str = StringUtils.join(bel.getSpecificArenaPlayerListener().getPlayers(), (String)", ");
                    String string = has = bel.hasListeners() ? "&2true" : "&cfalse";
                    if (!lists2.isEmpty()) {
                        MessageUtil.sendMessage(sender, "---- ArenaPlayerEvent &e" + bel.getSpecificArenaPlayerListener().getEvent().getSimpleName() + "&e:" + has + "&e, players=" + str);
                    }
                    for (UUID uUID : lists2.keySet()) {
                        p = null;
                        if (limitToPlayer != null && p != null && !p.getName().equalsIgnoreCase(limitToPlayer)) continue;
                        rls = (Collection)lists2.get(uUID);
                        for (RListener rl : rls) {
                            MessageUtil.sendMessage(sender, "!!! " + (Object)((Object)rl.getPriority()) + "  " + p + "  Listener  " + rl.getListener().getClass().getSimpleName() + " hash=" + Util.toString(rl.getListener()));
                        }
                    }
                }
                if (bel.getMatchListener() == null) continue;
                EnumMap<mc.alk.arena.objects.events.EventPriority, Map<RListener, Integer>> lists = bel.getMatchListener().getListeners();
                for (mc.alk.arena.objects.events.EventPriority ep : lists.keySet()) {
                    for (Map.Entry entry : lists.get((Object)ep).entrySet()) {
                        MessageUtil.sendMessage(sender, "! " + (Object)((Object)ep) + "  -  " + entry.getKey() + "  count=" + entry.getValue());
                    }
                }
            }
        }
        return true;
    }

    public void callEvent(BAEvent event) {
        this.baexecutor.callEvent(event);
    }

    public Collection<ArenaListener> getArenaListeners() {
        return this.listeners;
    }

    static interface BAEventCaller {
        public void callEvent(BAEvent var1);
    }
}

