/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.custom;

import java.lang.reflect.Method;
import mc.alk.arena.BattleArena;
import mc.alk.arena.listeners.custom.RListener;
import mc.alk.arena.listeners.custom.SpecificPlayerEventListener;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.util.Log;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpecificArenaPlayerEventListener
extends SpecificPlayerEventListener {
    public SpecificArenaPlayerEventListener(Class<? extends Event> bukkitEvent, EventPriority bukkitPriority, Method getPlayerMethod) {
        super(bukkitEvent, bukkitPriority, getPlayerMethod);
    }

    @Override
    public void invokeEvent(Event event) {
        this.doMethods(event, this.getEntityFromMethod(event, this.getPlayerMethod));
    }

    private void doMethods(Event event, ArenaPlayer p) {
        RListener[] lmethods = (RListener[])this.listeners.getSafe(p.getID());
        if (lmethods == null) {
            return;
        }
        for (RListener lmethod : lmethods) {
            try {
                lmethod.getMethod().getMethod().invoke((Object)lmethod.getListener(), event);
            }
            catch (Exception e) {
                Log.err("[" + BattleArena.getNameAndVersion() + " Error] method=" + lmethod.getMethod().getMethod().getName() + ",  types.length=" + lmethod.getMethod().getMethod().getParameterTypes().length + ",  p=" + p + ",  listener=" + lmethod);
                Log.printStackTrace(e);
            }
        }
    }

    private ArenaPlayer getEntityFromMethod(Event event, Method method) {
        try {
            Object o = method.invoke((Object)event, new Object[0]);
            if (o instanceof ArenaPlayer) {
                return (ArenaPlayer)o;
            }
            return null;
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return null;
        }
    }
}

