/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.listeners.custom;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.UUID;
import mc.alk.arena.BattleArena;
import mc.alk.arena.listeners.custom.BaseEventListener;
import mc.alk.arena.listeners.custom.RListener;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.util.DmgDeathUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MapOfTreeSet;
import mc.alk.arena.util.PlayerUtil;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpecificPlayerEventListener
extends BaseEventListener {
    protected final MapOfTreeSet<UUID, RListener> listeners = new MapOfTreeSet(RListener.class, new RListener.RListenerPriorityComparator());
    final Method getPlayerMethod;

    public SpecificPlayerEventListener(Class<? extends Event> bukkitEvent, EventPriority bukkitPriority, Method getPlayerMethod) {
        super(bukkitEvent, bukkitPriority);
        this.getPlayerMethod = getPlayerMethod;
    }

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public MapOfTreeSet<UUID, RListener> getListeners() {
        return this.listeners;
    }

    public Collection<UUID> getPlayers() {
        return this.listeners.keySet();
    }

    public void addListener(RListener rl, Collection<UUID> players) {
        for (UUID player : players) {
            this.addSPListener(player, rl);
        }
    }

    public synchronized void removeListener(RListener rl, Collection<UUID> players) {
        for (UUID player : players) {
            this.removeSPListener(player, rl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeAllListeners(RListener rl) {
        MapOfTreeSet<UUID, RListener> mapOfTreeSet = this.listeners;
        synchronized (mapOfTreeSet) {
            for (UUID name : this.listeners.keySet()) {
                this.listeners.remove(name, rl);
            }
        }
    }

    public void addSPListener(UUID p, RListener spl) {
        if (!this.isListening()) {
            this.startListening();
        }
        this.listeners.add(p, spl);
    }

    public boolean removeSPListener(UUID p, RListener spl) {
        boolean removed = this.listeners.remove(p, spl);
        if (removed && !this.hasListeners() && this.isListening()) {
            this.stopListening();
        }
        return removed;
    }

    @Override
    public void invokeEvent(Event event) {
        if (event.getClass() == EntityDamageByEntityEvent.class) {
            this.doEntityDamageByEntityEvent((EntityDamageByEntityEvent)event);
            return;
        }
        if (event.getClass() == EntityDeathEvent.class) {
            this.doEntityDeathEvent((EntityDeathEvent)event);
            return;
        }
        if (event instanceof EntityDamageEvent) {
            this.doEntityDamageEvent((EntityDamageEvent)event);
            return;
        }
        Entity entity = this.getEntityFromMethod(event, this.getPlayerMethod);
        if (!(entity instanceof Player)) {
            return;
        }
        this.doMethods(event, (Player)entity);
    }

    private void doMethods(Event event, Player p) {
        RListener[] lmethods = this.listeners.getSafe(PlayerUtil.getID(p));
        if (lmethods == null) {
            return;
        }
        for (RListener lmethod : lmethods) {
            try {
                lmethod.getMethod().getMethod().invoke((Object)lmethod.getListener(), event);
            }
            catch (Exception e) {
                Log.err("[" + BattleArena.getNameAndVersion() + " Error] method=" + lmethod.getMethod().getMethod() + ",  types.length=" + lmethod.getMethod().getMethod().getParameterTypes().length + ",  p=" + p + ",  listener=" + lmethod);
                Log.printStackTrace(e);
            }
        }
    }

    private void doEntityDeathEvent(EntityDeathEvent event) {
        if (event.getEntity() instanceof Player && this.listeners.containsKey(PlayerUtil.getID((Player)event.getEntity()))) {
            this.doMethods((Event)event, (Player)event.getEntity());
            return;
        }
        ArenaPlayer ap = DmgDeathUtil.getPlayerCause(event.getEntity().getLastDamageCause());
        if (ap == null) {
            return;
        }
        if (this.listeners.containsKey(ap.getID())) {
            this.doMethods((Event)event, ap.getPlayer());
        }
    }

    private void doEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        Projectile proj;
        if (event.getEntity() instanceof Player && this.listeners.containsKey(PlayerUtil.getID((Player)event.getEntity()))) {
            this.doMethods((Event)event, (Player)event.getEntity());
            return;
        }
        if (event.getDamager() instanceof Player && this.listeners.containsKey(PlayerUtil.getID((Player)event.getDamager()))) {
            this.doMethods((Event)event, (Player)event.getDamager());
            return;
        }
        Player player = null;
        if (event.getDamager() instanceof Projectile && (proj = (Projectile)event.getDamager()).getShooter() instanceof Player) {
            player = (Player)proj.getShooter();
        }
        if (player != null) {
            this.doMethods((Event)event, player);
        }
    }

    private void doEntityDamageEvent(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            this.doMethods((Event)event, (Player)event.getEntity());
            return;
        }
        EntityDamageEvent lastDamage = event.getEntity().getLastDamageCause();
        ArenaPlayer damager = DmgDeathUtil.getPlayerCause(lastDamage);
        if (damager != null) {
            this.doMethods((Event)event, damager.getPlayer());
        }
    }

    private Entity getEntityFromMethod(Event event, Method method) {
        try {
            Object o = method.invoke((Object)event, new Object[0]);
            if (o instanceof Entity) {
                return (Entity)o;
            }
            return null;
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return null;
        }
    }
}

