/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mc.alk.arena.objects.CommandLineString;
import mc.alk.arena.objects.spawns.EntitySpawn;
import mc.alk.arena.objects.spawns.SpawnInstance;
import mc.alk.arena.util.InventoryUtil;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaClass {
    public static final Integer DEFAULT = Integer.MAX_VALUE;
    public static final ArenaClass CHOSEN_CLASS = new ArenaClass("CHOSENCLASS", "chosenClass", null, null);
    public static final ArenaClass SELF_CLASS = new ArenaClass("SELFCLASS", "selfClass", null, null);
    final String name;
    final String displayName;
    final List<ItemStack> items;
    final List<PotionEffect> effects;
    List<SpawnInstance> mobs;
    String disguiseName;
    List<CommandLineString> commands;
    boolean valid = false;

    public ArenaClass(String name) {
        this(name, name, new ArrayList<ItemStack>(), new ArrayList<PotionEffect>());
        this.valid = false;
    }

    public ArenaClass(String name, String displayName, List<ItemStack> items, List<PotionEffect> effects) {
        this.name = name;
        CopyOnWriteArrayList<ItemStack> listitems = new CopyOnWriteArrayList<ItemStack>();
        ArrayList<ItemStack> armoritems = new ArrayList<ItemStack>();
        if (items != null) {
            for (ItemStack is : items) {
                if (InventoryUtil.isArmor(is)) {
                    armoritems.add(is);
                    continue;
                }
                listitems.add(is);
            }
        }
        this.items = listitems;
        this.items.addAll(armoritems);
        this.effects = effects;
        this.displayName = displayName;
        this.valid = true;
    }

    public String getName() {
        return this.name;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public List<PotionEffect> getEffects() {
        return this.effects;
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.name;
    }

    public String getDisguiseName() {
        return this.disguiseName;
    }

    public void setDisguiseName(String disguiseName) {
        this.disguiseName = disguiseName;
    }

    public String toString() {
        return "[ArenaClass " + this.getName() + "]";
    }

    public boolean valid() {
        return this.valid;
    }

    public void setMobs(List<SpawnInstance> mobs) {
        this.mobs = mobs;
    }

    public List<SpawnInstance> getMobs() {
        return this.mobs;
    }

    public List<CommandLineString> getDoCommands() {
        return this.commands;
    }

    public void setDoCommands(List<CommandLineString> commands) {
        this.commands = commands;
    }

    public List<SpawnInstance> getMobsClone() {
        ArrayList<SpawnInstance> l = new ArrayList<SpawnInstance>();
        for (SpawnInstance si : this.mobs) {
            if (si instanceof EntitySpawn) {
                l.add(new EntitySpawn((EntitySpawn)si));
                continue;
            }
            l.add(si);
        }
        return l;
    }
}

