/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.objects.ArenaSize;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.StateGraph;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.arenas.ArenaType;
import mc.alk.arena.objects.options.JoinOptions;
import mc.alk.arena.objects.options.StateOptions;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.util.MinMax;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaParams {
    ArenaType arenaType;
    Boolean rated;
    String name;
    String displayName;
    String cmd;
    Integer timeBetweenRounds;
    Integer secondsTillMatch;
    Integer matchTime;
    Integer secondsToLoot;
    Integer forceStartTime;
    StateGraph stateGraph;
    StateGraph mergedStateGraph;
    String tableName;
    ArenaParams parent;
    MinMax nTeams;
    MinMax teamSize;
    Boolean closeWaitroomWhileRunning;
    Boolean cancelIfNotEnoughPlayers;
    Integer arenaCooldown;
    Integer allowedTeamSizeDifference;
    Integer nLives;
    Boolean removePlayersOnLeave;
    private Map<Integer, MatchParams> teamParams;

    public ArenaParams() {
    }

    public ArenaParams(ArenaType at) {
        this.arenaType = at;
    }

    public ArenaParams(ArenaParams ap) {
        this(ap.getType());
        this.copy(ap);
    }

    public void copy(ArenaParams ap) {
        if (this == ap) {
            return;
        }
        this.arenaType = ap.arenaType;
        this.rated = ap.rated;
        this.cmd = ap.cmd;
        this.name = ap.name;
        this.timeBetweenRounds = ap.timeBetweenRounds;
        this.secondsTillMatch = ap.secondsTillMatch;
        this.secondsToLoot = ap.secondsToLoot;
        this.tableName = ap.tableName;
        this.closeWaitroomWhileRunning = ap.closeWaitroomWhileRunning;
        this.cancelIfNotEnoughPlayers = ap.cancelIfNotEnoughPlayers;
        this.arenaCooldown = ap.arenaCooldown;
        this.allowedTeamSizeDifference = ap.allowedTeamSizeDifference;
        this.matchTime = ap.matchTime;
        this.forceStartTime = ap.forceStartTime;
        this.nLives = ap.nLives;
        this.displayName = ap.displayName;
        this.mergedStateGraph = null;
        if (ap.stateGraph != null) {
            this.stateGraph = new StateGraph(ap.stateGraph);
        }
        if (ap.nTeams != null) {
            this.nTeams = new MinMax(ap.nTeams);
        }
        if (ap.teamSize != null) {
            this.teamSize = new MinMax(ap.teamSize);
        }
        this.teamParams = ap.teamParams;
        this.parent = ap.parent;
        this.removePlayersOnLeave = ap.removePlayersOnLeave;
    }

    public void flatten() {
        if (this.parent == null) {
            return;
        }
        if (this.arenaType == null) {
            this.arenaType = this.parent.getType();
        }
        if (this.rated == null) {
            this.rated = this.parent.isRated();
        }
        if (this.cmd == null) {
            this.cmd = this.parent.getCommand();
        }
        if (this.name == null) {
            this.name = this.parent.getName();
        }
        if (this.timeBetweenRounds == null) {
            this.timeBetweenRounds = this.parent.getTimeBetweenRounds();
        }
        if (this.secondsTillMatch == null) {
            this.secondsTillMatch = this.parent.getSecondsTillMatch();
        }
        if (this.matchTime == null) {
            this.matchTime = this.parent.getMatchTime();
        }
        if (this.forceStartTime == null) {
            this.forceStartTime = this.parent.getForceStartTime();
        }
        if (this.secondsToLoot == null) {
            this.secondsToLoot = this.parent.getSecondsToLoot();
        }
        if (this.tableName == null) {
            this.tableName = this.parent.getDBTableName();
        }
        if (this.nLives == null) {
            this.nLives = this.parent.getNLives();
        }
        if (this.removePlayersOnLeave == null) {
            this.removePlayersOnLeave = this.parent.getRemovePlayersOnLeave();
        }
        if (this.closeWaitroomWhileRunning == null) {
            this.closeWaitroomWhileRunning = this.parent.isWaitroomClosedWhenRunning();
        }
        if (this.cancelIfNotEnoughPlayers == null) {
            this.cancelIfNotEnoughPlayers = this.parent.isCancelIfNotEnoughPlayers();
        }
        if (this.arenaCooldown == null) {
            this.arenaCooldown = this.parent.getArenaCooldown();
        }
        if (this.allowedTeamSizeDifference == null) {
            this.allowedTeamSizeDifference = this.parent.getAllowedTeamSizeDifference();
        }
        if (this.displayName == null) {
            this.displayName = this.parent.getDisplayName();
        }
        this.stateGraph = this.mergeChildWithParent(this, this.parent);
        if (this.nTeams == null && this.parent.getNTeams() != null) {
            this.nTeams = new MinMax(this.parent.getNTeams());
        }
        if (this.teamSize == null && this.parent.getTeamSize() != null) {
            this.teamSize = new MinMax(this.parent.getTeamSize());
        }
        if (this.teamParams != null && this.parent.getTeamParams() != null) {
            HashMap<Integer, MatchParams> tp = new HashMap<Integer, MatchParams>(this.teamParams);
            tp.putAll(this.parent.getTeamParams());
            this.parent = null;
            this.teamParams = null;
            for (Map.Entry<Integer, MatchParams> e : tp.entrySet()) {
                MatchParams ap = ParamController.copyParams(e.getValue());
                ap.setParent(this);
                ap.flatten();
                tp.put(e.getKey(), ap);
            }
            this.teamParams = tp;
        } else if (this.parent.getTeamParams() != null) {
            HashMap<Integer, MatchParams> tp = new HashMap<Integer, MatchParams>(this.parent.getTeamParams());
            this.parent = null;
            this.teamParams = null;
            for (Map.Entry<Integer, MatchParams> e : tp.entrySet()) {
                MatchParams ap = ParamController.copyParams(e.getValue());
                ap.setParent(this);
                ap.flatten();
                tp.put(e.getKey(), ap);
            }
            this.teamParams = tp;
        } else if (this.teamParams != null) {
            HashMap<Integer, MatchParams> tp = new HashMap<Integer, MatchParams>(this.teamParams);
            this.parent = null;
            this.teamParams = null;
            for (Map.Entry<Integer, MatchParams> e : tp.entrySet()) {
                MatchParams ap = ParamController.copyParams(e.getValue());
                ap.setParent(this);
                ap.flatten();
                tp.put(e.getKey(), ap);
            }
            this.teamParams = tp;
        }
        this.mergedStateGraph = this.stateGraph;
        this.parent = null;
    }

    private StateGraph mergeChildWithParent(ArenaParams cap, ArenaParams pap) {
        StateGraph mt;
        StateGraph stateGraph = mt = cap.stateGraph == null ? new StateGraph() : new StateGraph(cap.stateGraph);
        if (pap != null) {
            StateGraph.mergeChildWithParent(mt, this.mergeChildWithParent(pap, pap.parent));
        }
        return mt;
    }

    public StateGraph getThisStateGraph() {
        return this.stateGraph;
    }

    public void setStateGraph(StateGraph stateGraph) {
        this.stateGraph = stateGraph;
        this.clearMerged();
    }

    public MinMax getThisTeamSize() {
        return this.teamSize;
    }

    public MinMax getThisNTeams() {
        return this.nTeams;
    }

    public String getPlayerRange() {
        return ArenaSize.rangeString(this.getMinPlayers(), this.getMaxPlayers());
    }

    public ArenaType getType() {
        return this.arenaType;
    }

    public void setType(ArenaType type) {
        this.arenaType = type;
    }

    public boolean intersect(ArenaParams params) {
        if (!this.getType().matches(params.getType())) {
            return false;
        }
        if (this.getNTeams() != null && params.getNTeams() != null && !this.getNTeams().intersect(params.getNTeams())) {
            return false;
        }
        return this.getTeamSize() != null && params.getTeamSize() != null && !this.getTeamSize().intersect(params.getTeamSize());
    }

    public boolean matches(JoinOptions jo) {
        return this.matches(jo.getMatchParams());
    }

    public boolean matches(ArenaParams ap) {
        if (this.arenaType != null && ap.arenaType != null && !this.arenaType.matches(ap.arenaType)) {
            return false;
        }
        MinMax nt = this.getNTeams();
        MinMax nt2 = ap.getNTeams();
        if (nt != null && nt2 != null && !nt.intersect(nt2)) {
            return false;
        }
        MinMax ts = this.getTeamSize();
        MinMax ts2 = ap.getTeamSize();
        return ts == null || ts2 == null || ts.intersect(ts2);
    }

    public Collection<String> getInvalidMatchReasons(ArenaParams ap) {
        ArrayList<String> reasons = new ArrayList<String>();
        if (this.arenaType == null) {
            reasons.add("ArenaType is null");
        }
        if (ap.arenaType == null) {
            reasons.add("Passed params have an arenaType of null");
        } else {
            reasons.addAll(this.arenaType.getInvalidMatchReasons(ap.getType()));
        }
        if (this.getNTeams() != null && ap.getNTeams() != null && !this.getNTeams().intersect(ap.getNTeams())) {
            reasons.add("Arena accepts numTeams=" + this.getNTeams() + ". you requested " + ap.getNTeams());
        }
        if (this.getTeamSize() != null && ap.getTeamSize() != null && !this.getTeamSize().intersect(ap.getTeamSize())) {
            reasons.add("Arena accepts teamSize=" + this.getTeamSize() + ". you requested " + ap.getTeamSize());
        }
        return reasons;
    }

    public boolean valid() {
        return !(this.arenaType == null || this.nTeams != null && !this.nTeams.valid() || this.teamSize != null && !this.teamSize.valid());
    }

    public Collection<String> getInvalidReasons() {
        ArrayList<String> reasons = new ArrayList<String>();
        if (this.arenaType == null) {
            reasons.add("ArenaType is null");
        }
        if (this.nTeams != null && !this.nTeams.valid()) {
            reasons.add("Min Teams is greater than Max Teams " + this.nTeams.min + ":" + this.nTeams.max);
        }
        if (this.teamSize != null && !this.teamSize.valid()) {
            reasons.add("Min Team Size is greater than Max Team Size " + this.teamSize.min + ":" + this.teamSize.max);
        }
        return reasons;
    }

    public String getCommand() {
        return this.cmd != null ? this.cmd : (this.parent != null ? this.parent.getCommand() : null);
    }

    public void setRated(boolean rated) {
        this.rated = rated;
    }

    public Boolean isRated() {
        return this.rated != null ? this.rated : (this.parent != null ? this.parent.isRated() : null);
    }

    public void setSecondsToLoot(Integer i) {
        this.secondsToLoot = i;
    }

    public Integer getSecondsToLoot() {
        return this.secondsToLoot != null ? this.secondsToLoot : (this.parent != null ? this.parent.getSecondsToLoot() : null);
    }

    public void setSecondsTillMatch(Integer i) {
        this.secondsTillMatch = i;
    }

    public Integer getSecondsTillMatch() {
        return this.secondsTillMatch != null ? this.secondsTillMatch : (this.parent != null ? this.parent.getSecondsTillMatch() : null);
    }

    public void setTimeBetweenRounds(Integer i) {
        this.timeBetweenRounds = i;
    }

    public Integer getTimeBetweenRounds() {
        return this.timeBetweenRounds != null ? this.timeBetweenRounds : (this.parent != null ? this.parent.getTimeBetweenRounds() : null);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDBTableName() {
        return this.tableName != null ? this.tableName : (this.parent != null ? this.parent.getDBTableName() : null);
    }

    public String getName() {
        return this.name != null ? this.name : (this.parent != null ? this.parent.getName() : null);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toPrettyString() {
        return this.getDisplayName() + ":" + this.arenaType + ",numTeams=" + this.getNTeams() + ",teamSize=" + this.getTeamSize();
    }

    private ChatColor getColor(Object o) {
        return o == null ? ChatColor.GOLD : ChatColor.WHITE;
    }

    public String toSummaryString() {
        return "&2&f" + this.name + "&2:&f" + this.arenaType + "&2,numTeams=" + this.getColor(this.nTeams) + this.getNTeams() + "&2,teamSize=" + this.getColor(this.teamSize) + this.getTeamSize() + "\n" + "&5forceStartTime=" + this.getColor(this.forceStartTime) + this.getForceStartTime() + "&5, timeUntilMatch=" + this.getColor(this.secondsTillMatch) + this.getSecondsTillMatch() + "&5, matchTime=" + this.getColor(this.matchTime) + this.getMatchTime() + "&5, secondsToLoot=" + this.getColor(this.secondsToLoot) + this.getSecondsToLoot() + "\n" + "&crated=" + this.getColor(this.rated) + this.isRated() + "&c, nLives=" + this.getColor(this.nLives) + this.getNLives() + "&e";
    }

    public String getOptionsSummaryString() {
        return this.getStateGraph().getOptionString(this.stateGraph);
    }

    public String toString() {
        return this.name + ":" + this.arenaType + ",numTeams=" + this.getNTeams() + ",teamSize=" + this.getTeamSize() + " options=\n" + (this.getThisStateGraph() == null ? "" : this.getThisStateGraph().getOptionString());
    }

    public boolean isDuelOnly() {
        return this.getStateGraph().hasOptionAt(MatchState.DEFAULTS, TransitionOption.DUELONLY);
    }

    public boolean isAlwaysOpen() {
        return this.getStateGraph().hasOptionAt(MatchState.DEFAULTS, TransitionOption.ALWAYSOPEN);
    }

    public void setParent(ArenaParams parent) {
        this.parent = parent;
        this.clearMerged();
    }

    protected void clearMerged() {
        this.mergedStateGraph = null;
        if (this.teamParams != null) {
            for (MatchParams mp : this.teamParams.values()) {
                mp.clearMerged();
            }
        }
    }

    public ArenaParams getParent() {
        return this.parent;
    }

    public Integer getMinTeamSize() {
        return this.teamSize != null ? this.teamSize.min : (this.parent != null ? this.parent.getMinTeamSize() : null);
    }

    public Integer getMaxTeamSize() {
        return this.teamSize != null ? this.teamSize.max : (this.parent != null ? this.parent.getMaxTeamSize() : null);
    }

    public Integer getMinTeams() {
        return this.nTeams != null ? this.nTeams.min : (this.parent != null ? this.parent.getMinTeams() : null);
    }

    public Integer getMaxTeams() {
        return this.nTeams != null ? this.nTeams.max : (this.parent != null ? this.parent.getMaxTeams() : null);
    }

    public Integer getMaxPlayers() {
        MinMax nt = this.getNTeams();
        MinMax ts = this.getTeamSize();
        if (nt == null || ts == null) {
            return null;
        }
        return nt.max == Integer.MAX_VALUE || ts.max == Integer.MAX_VALUE ? Integer.MAX_VALUE : nt.max * ts.max;
    }

    public Integer getMinPlayers() {
        MinMax nt = this.getNTeams();
        MinMax ts = this.getTeamSize();
        if (nt == null || ts == null) {
            return null;
        }
        return nt.min == Integer.MAX_VALUE || ts.min == Integer.MAX_VALUE ? Integer.MAX_VALUE : nt.min * ts.min;
    }

    public void setNTeams(int size) {
        this.setNTeams(new MinMax(size));
    }

    public void setNTeams(MinMax mm) {
        if (mm == null) {
            this.nTeams = null;
        } else if (this.nTeams == null) {
            this.nTeams = new MinMax(mm);
        } else {
            this.nTeams.min = mm.min;
            this.nTeams.max = mm.max;
        }
    }

    public MinMax getNTeams() {
        return this.nTeams != null ? this.nTeams : (this.parent != null ? this.parent.getNTeams() : null);
    }

    public MinMax getTeamSize() {
        return this.teamSize != null ? this.teamSize : (this.parent != null ? this.parent.getTeamSize() : null);
    }

    public void setTeamSize(int size) {
        this.setTeamSize(new MinMax(size));
    }

    public void setTeamSize(MinMax mm) {
        if (mm == null) {
            this.teamSize = null;
        } else if (this.teamSize == null) {
            this.teamSize = new MinMax(mm);
        } else {
            this.teamSize.min = mm.min;
            this.teamSize.max = mm.max;
        }
    }

    public void setMinTeamSize(int n) {
        if (this.teamSize == null) {
            this.teamSize = new MinMax(n);
        } else {
            this.teamSize.min = n;
        }
    }

    public void setMaxTeamSize(int n) {
        if (this.teamSize == null) {
            this.teamSize = new MinMax(n);
        } else {
            this.teamSize.max = n;
        }
    }

    public void setMinTeams(int n) {
        if (this.nTeams == null) {
            this.nTeams = new MinMax(n);
        } else {
            this.nTeams.min = n;
        }
    }

    public void setMaxTeams(int n) {
        if (this.nTeams == null) {
            this.nTeams = new MinMax(n);
        } else {
            this.nTeams.max = n;
        }
    }

    public boolean matchesTeamSize(int i) {
        return this.teamSize != null ? this.teamSize.contains(i) : this.parent != null && this.parent.matchesTeamSize(i);
    }

    public boolean hasOptionAt(CompetitionState state, TransitionOption op) {
        return this.getStateGraph().hasOptionAt(state, op);
    }

    public boolean hasOptionAt(CompetitionState state, StateOption op) {
        return this.getStateGraph().hasOptionAt(state, op);
    }

    public boolean hasEntranceFee() {
        return this.hasOptionAt((CompetitionState)MatchState.PREREQS, TransitionOption.MONEY);
    }

    public Double getEntranceFee() {
        return this.getDoubleOption(MatchState.PREREQS, TransitionOption.MONEY);
    }

    public Double getDoubleOption(CompetitionState state, TransitionOption option) {
        return this.getStateGraph().getDoubleOption(state, option);
    }

    public boolean hasAnyOption(TransitionOption option) {
        return this.getStateGraph().hasAnyOption((StateOption)option);
    }

    public List<ItemStack> getWinnerItems() {
        return this.getGiveItems(MatchState.WINNERS);
    }

    public List<ItemStack> getLoserItems() {
        return this.getGiveItems(MatchState.LOSERS);
    }

    public List<ItemStack> getGiveItems(CompetitionState state) {
        StateOptions tops = this.getStateOptions(state);
        return tops != null && tops.hasOption(TransitionOption.GIVEITEMS) ? tops.getGiveItems() : null;
    }

    public List<PotionEffect> getEffects(CompetitionState state) {
        StateOptions tops = this.getStateOptions(state);
        return tops != null && tops.hasOption(TransitionOption.ENCHANTS) ? tops.getEffects() : null;
    }

    public boolean needsWaitroom() {
        return this.getStateGraph().hasAnyOption(TransitionOption.TELEPORTMAINWAITROOM, TransitionOption.TELEPORTWAITROOM);
    }

    public boolean needsSpectate() {
        return this.getStateGraph().hasAnyOption((StateOption)TransitionOption.TELEPORTSPECTATE);
    }

    public boolean needsLobby() {
        return this.getStateGraph().hasAnyOption(TransitionOption.TELEPORTMAINLOBBY, TransitionOption.TELEPORTLOBBY);
    }

    public Boolean isWaitroomClosedWhenRunning() {
        return this.closeWaitroomWhileRunning != null ? this.closeWaitroomWhileRunning : (this.parent != null ? this.parent.isWaitroomClosedWhenRunning() : null);
    }

    public void setWaitroomClosedWhileRunning(Boolean value) {
        this.closeWaitroomWhileRunning = value;
    }

    public Boolean isCancelIfNotEnoughPlayers() {
        return this.cancelIfNotEnoughPlayers != null ? this.cancelIfNotEnoughPlayers : (this.parent != null ? this.parent.isCancelIfNotEnoughPlayers() : null);
    }

    public void setCancelIfNotEnoughPlayers(Boolean value) {
        this.cancelIfNotEnoughPlayers = value;
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName : (this.parent != null ? this.parent.getDisplayName() : this.getName());
    }

    public String getThisDisplayName() {
        return this.displayName;
    }

    public int getQueueCount() {
        return BattleArena.getBAController().getArenaMatchQueue().getQueueCount(this);
    }

    public void setArenaCooldown(int cooldown) {
        this.arenaCooldown = cooldown;
    }

    public Integer getArenaCooldown() {
        return this.arenaCooldown != null ? this.arenaCooldown : (this.parent != null ? this.parent.getArenaCooldown() : null);
    }

    public void setAllowedTeamSizeDifference(int difference) {
        this.allowedTeamSizeDifference = difference;
    }

    public Integer getAllowedTeamSizeDifference() {
        return this.allowedTeamSizeDifference != null ? this.allowedTeamSizeDifference : (this.parent != null ? this.parent.getAllowedTeamSizeDifference() : null);
    }

    public Integer getForceStartTime() {
        return this.forceStartTime != null ? this.forceStartTime : (this.parent != null ? this.parent.getForceStartTime() : null);
    }

    public void setForceStartTime(Integer forceStartTime) {
        this.forceStartTime = forceStartTime;
    }

    public Integer getMatchTime() {
        return this.matchTime == null && this.parent != null ? this.parent.getMatchTime() : this.matchTime;
    }

    public void setMatchTime(Integer matchTime) {
        this.matchTime = matchTime;
    }

    public void setNLives(Integer nlives) {
        this.nLives = nlives;
    }

    public Integer getNLives() {
        return this.nLives == null && this.parent != null ? this.parent.getNLives() : this.nLives;
    }

    public Boolean getRemovePlayersOnLeave() {
        return this.removePlayersOnLeave == null && this.parent != null ? this.parent.getRemovePlayersOnLeave() : this.removePlayersOnLeave;
    }

    public void setRemovePlayersOnLeave(Boolean removePlayersOnLeave) {
        this.removePlayersOnLeave = removePlayersOnLeave;
    }

    public Map<Integer, MatchParams> getTeamParams() {
        return this.teamParams == null && this.parent != null ? this.parent.getTeamParams() : this.teamParams;
    }

    public MatchParams getTeamParams(int index) {
        MatchParams mp;
        if (this.teamParams != null && (mp = this.teamParams.get(index)) != null) {
            return mp;
        }
        if (this.parent != null) {
            return this.parent.getTeamParams(index);
        }
        return null;
    }

    public Map<Integer, MatchParams> getThisTeamParams() {
        return this.teamParams;
    }

    public void setTeamParams(Map<Integer, MatchParams> teamParams) {
        this.teamParams = teamParams;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public StateGraph getStateOptions() {
        return this.getStateGraph();
    }

    public StateGraph getStateGraph() {
        if (this.mergedStateGraph != null) {
            return this.mergedStateGraph;
        }
        this.mergedStateGraph = this.stateGraph == null && this.parent != null ? this.parent.getStateGraph() : this.mergeChildWithParent(this, this.parent);
        return this.mergedStateGraph;
    }

    public StateOptions getStateOptions(CompetitionState state) {
        return this.getStateGraph().getOptions(state);
    }
}

