/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.List;
import java.util.Stack;
import java.util.UUID;
import mc.alk.arena.competition.Competition;
import mc.alk.arena.controllers.containers.AreaContainer;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.controllers.plugins.TrackerController;
import mc.alk.arena.objects.ArenaClass;
import mc.alk.arena.objects.ArenaLocation;
import mc.alk.arena.objects.LocationType;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.meta.PlayerMetaData;
import mc.alk.arena.objects.spawns.EntitySpawn;
import mc.alk.arena.objects.spawns.FixedLocation;
import mc.alk.arena.objects.spawns.SpawnInstance;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.objects.stats.ArenaStat;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.PermissionsUtil;
import mc.alk.arena.util.PlayerUtil;
import mc.alk.arena.util.ServerUtil;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.PlayerInventory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaPlayer {
    static int count = 0;
    final int id = count++;
    Player player;
    final Stack<Competition> competitions = new Stack();
    Arena arena;
    ArenaClass preferredClass;
    ArenaClass currentClass;
    SpawnLocation oldLocation;
    ArenaTeam arenaTeam;
    ArenaLocation curLocation = new ArenaLocation(AreaContainer.HOMECONTAINER, null, LocationType.HOME);
    List<SpawnInstance> mobs;
    boolean isReady;
    final PlayerMetaData meta = new PlayerMetaData();
    final UUID uuid;
    LivingEntity curTarget;

    public ArenaPlayer(Player player) {
        this.player = player;
        this.uuid = PlayerUtil.getID(this);
    }

    public ArenaPlayer(UUID id) {
        this.uuid = id;
    }

    public String getName() {
        return this.player.getName();
    }

    public void reset() {
        this.isReady = false;
        this.currentClass = null;
        this.preferredClass = null;
        if (this.mobs != null) {
            this.despawnMobs();
            this.mobs.clear();
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof ArenaPlayer && ((ArenaPlayer)obj).id == this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isOnline() {
        return this.player.isOnline();
    }

    public double getHealth() {
        return PlayerUtil.getHealth(this.player);
    }

    public void setHealth(double health) {
        PlayerUtil.setHealth(this.player, health);
    }

    public int getFoodLevel() {
        return PlayerUtil.getHunger(this.player);
    }

    public void setFoodLevel(int hunger) {
        PlayerUtil.setHunger(this.player, hunger);
    }

    public String getDisplayName() {
        return this.player.getDisplayName();
    }

    public void sendMessage(String colorChat) {
        this.player.sendMessage(colorChat);
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public EntityDamageEvent getLastDamageCause() {
        return this.player.getLastDamageCause();
    }

    public void setFireTicks(int i) {
        this.player.setFireTicks(i);
    }

    public boolean isDead() {
        return this.player.isDead();
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean isReady) {
        this.isReady = isReady;
    }

    public PlayerInventory getInventory() {
        return this.player.getInventory();
    }

    public boolean hasPermission(String perm) {
        return this.player.hasPermission(perm);
    }

    public ArenaClass getCurrentClass() {
        return this.currentClass;
    }

    public void setCurrentClass(ArenaClass arenaClass) {
        this.currentClass = arenaClass;
    }

    public ArenaClass getPreferredClass() {
        return this.preferredClass;
    }

    public void setPreferredClass(ArenaClass arenaClass) {
        this.preferredClass = arenaClass;
    }

    public int getPriority() {
        return PermissionsUtil.getPriority(this.player);
    }

    public int getLevel() {
        return HeroesController.enabled() ? HeroesController.getLevel(this.player) : this.player.getLevel();
    }

    public Competition getCompetition() {
        return this.competitions.isEmpty() ? null : this.competitions.peek();
    }

    public void addCompetition(Competition competition) {
        if (!this.competitions.contains(competition)) {
            this.competitions.push(competition);
        }
    }

    public boolean removeCompetition(Competition competition) {
        return this.competitions.remove(competition);
    }

    public ArenaTeam getTeam() {
        if (this.arenaTeam != null) {
            return this.arenaTeam;
        }
        return this.competitions.isEmpty() ? null : this.competitions.peek().getTeam(this);
    }

    public void setTeam(ArenaTeam team) {
        this.arenaTeam = team;
    }

    public void markOldLocation() {
        if (this.oldLocation == null) {
            this.oldLocation = new FixedLocation(this.getLocation());
        }
    }

    public void clearOldLocation() {
        this.oldLocation = null;
    }

    public SpawnLocation getOldLocation() {
        return this.oldLocation;
    }

    public void setCurLocation(ArenaLocation type) {
        this.curLocation = type;
    }

    public ArenaLocation getCurLocation() {
        return this.curLocation;
    }

    public void despawnMobs() {
        if (this.mobs != null) {
            for (SpawnInstance es : this.mobs) {
                es.despawn();
            }
        }
    }

    public void setMobs(List<SpawnInstance> mobs) {
        this.mobs = mobs;
    }

    public void spawnMobs() {
        if (this.mobs == null) {
            return;
        }
        for (SpawnInstance es : this.mobs) {
            es.despawn();
            es.setLocation(this.getLocation());
            es.spawn();
            if (!(es instanceof EntitySpawn)) continue;
            ((EntitySpawn)es).setOwner(this);
        }
    }

    public PlayerMetaData getMetaData() {
        return this.meta;
    }

    public ArenaStat getStat(MatchParams type) {
        return TrackerController.loadRecord(type, this);
    }

    public Player regetPlayer() {
        return ServerUtil.findPlayerExact(this.getName());
    }

    public String toString() {
        return "[" + this.getName() + "]";
    }

    public UUID getID() {
        return this.uuid;
    }

    public void setTarget(LivingEntity entity) {
        this.curTarget = entity;
        if (this.mobs == null) {
            return;
        }
        for (SpawnInstance es : this.mobs) {
            if (!(es instanceof EntitySpawn)) continue;
            ((EntitySpawn)es).setTarget(entity);
        }
    }

    public LivingEntity getTarget() {
        return this.curTarget;
    }
}

