/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.ArrayList;
import java.util.Collection;
import mc.alk.arena.objects.CompetitionSize;
import mc.alk.arena.util.MinMax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaSize
implements CompetitionSize {
    int minTeamSize = 1;
    int maxTeamSize = Integer.MAX_VALUE;
    int minTeams = 2;
    int maxTeams = Integer.MAX_VALUE;

    public ArenaSize() {
    }

    public ArenaSize(CompetitionSize size) {
        this.minTeamSize = size.getMinTeamSize();
        this.maxTeamSize = size.getMaxTeamSize();
        this.minTeams = size.getMinTeams();
        this.maxTeams = size.getMaxTeams();
    }

    @Override
    public int getMinPlayers() {
        return this.minTeams * this.minTeamSize;
    }

    @Override
    public int getMaxPlayers() {
        return this.maxTeams == Integer.MAX_VALUE || this.maxTeamSize == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.maxTeams * this.maxTeamSize;
    }

    @Override
    public boolean matchesTeamSize(int i) {
        return this.minTeamSize <= i && i <= this.maxTeamSize;
    }

    public boolean matches(ArenaSize size) {
        return ArenaSize.matchesTeamSize(this, size) && ArenaSize.matchesNTeams(this, size);
    }

    public static boolean matchesTeamSize(ArenaSize size1, ArenaSize size2) {
        return size1 == null && size2 == null || size1 != null && size2 != null && size1.matchesTeamSize(size2);
    }

    public static boolean matchesNTeams(ArenaSize size1, ArenaSize size2) {
        return size1 == null && size2 == null || size1 != null && size2 != null && size1.matchesNTeams(size2);
    }

    public static boolean lower(MinMax child, MinMax parent) {
        return child == null || parent == null || child.max < parent.max;
    }

    @Override
    public void setTeamSize(int size) {
        this.minTeamSize = this.maxTeamSize = size;
    }

    @Override
    public void setTeamSizes(MinMax mm) {
        this.minTeamSize = mm.min;
        this.maxTeamSize = mm.max;
    }

    @Override
    public void setNTeams(MinMax mm) {
        this.minTeams = mm.min;
        this.maxTeams = mm.max;
    }

    @Override
    public int getMinTeams() {
        return this.minTeams;
    }

    @Override
    public int getMaxTeams() {
        return this.maxTeams;
    }

    @Override
    public void setMinTeams(int nteams) {
        this.minTeams = nteams;
    }

    @Override
    public void setMaxTeams(int nteams) {
        this.maxTeams = nteams;
    }

    @Override
    public void setMinTeamSize(int size) {
        this.minTeamSize = size;
    }

    @Override
    public void setMaxTeamSize(int size) {
        this.maxTeamSize = size;
    }

    @Override
    public int getMinTeamSize() {
        return this.minTeamSize;
    }

    @Override
    public int getMaxTeamSize() {
        return this.maxTeamSize;
    }

    @Override
    public boolean matchesNTeams(CompetitionSize csize) {
        int max;
        int min = Math.max(csize.getMinTeams(), this.minTeams);
        return min <= (max = Math.min(csize.getMaxTeams(), this.maxTeams));
    }

    @Override
    public boolean matchesNTeams(int nteams) {
        return this.minTeams <= nteams && nteams <= this.maxTeams;
    }

    @Override
    public boolean matchesTeamSize(CompetitionSize csize) {
        int max;
        int min = Math.max(csize.getMinTeamSize(), this.minTeamSize);
        return min <= (max = Math.min(csize.getMaxTeamSize(), this.maxTeamSize));
    }

    public static boolean intersect(CompetitionSize size1, CompetitionSize size2) {
        return size1.intersect(size2);
    }

    @Override
    public boolean intersect(CompetitionSize csize) {
        this.minTeams = Math.max(csize.getMinTeams(), this.minTeams);
        this.maxTeams = Math.min(csize.getMaxTeams(), this.maxTeams);
        this.minTeamSize = Math.max(csize.getMinTeamSize(), this.minTeamSize);
        this.maxTeamSize = Math.min(csize.getMaxTeamSize(), this.maxTeamSize);
        return this.minTeams <= this.maxTeams && this.minTeamSize <= this.maxTeamSize;
    }

    public boolean intersectMax(CompetitionSize csize) {
        this.maxTeams = Math.min(csize.getMaxTeams(), this.maxTeams);
        this.maxTeamSize = Math.min(csize.getMaxTeamSize(), this.maxTeamSize);
        return this.minTeams <= this.maxTeams && this.minTeamSize <= this.maxTeamSize;
    }

    @Override
    public boolean intersectTeamSize(int size) {
        if (this.minTeamSize > size || this.maxTeamSize < size) {
            return false;
        }
        this.minTeamSize = size;
        this.maxTeamSize = size;
        return true;
    }

    public static String toString(int size) {
        return size == Integer.MAX_VALUE ? "infinite" : String.valueOf(size);
    }

    public static int toInt(String size) {
        return size.equalsIgnoreCase("infinite") ? Integer.MAX_VALUE : Integer.valueOf(size);
    }

    public static int toInt(String size, int defValue) {
        if (size == null || size.isEmpty()) {
            return defValue;
        }
        return size.equalsIgnoreCase("infinite") ? Integer.MAX_VALUE : Integer.valueOf(size);
    }

    public String toString() {
        return "[" + ArenaSize.rangeString(this.minTeamSize, this.maxTeamSize) + " <-> " + ArenaSize.rangeString(this.minTeams, this.maxTeams) + "]";
    }

    public static String rangeString(int min, int max) {
        if (max == Integer.MAX_VALUE) {
            return min + "+";
        }
        if (min == max) {
            return min + "";
        }
        return min + "-" + max;
    }

    public boolean valid() {
        return this.minTeamSize <= this.maxTeamSize && this.minTeams <= this.maxTeams;
    }

    public Collection<String> getInvalidReasons() {
        ArrayList<String> reasons = new ArrayList<String>();
        if (this.minTeamSize <= 0) {
            reasons.add("Min Team Size is <= 0");
        }
        if (this.maxTeamSize <= 0) {
            reasons.add("Max Team Size is <= 0");
        }
        if (this.minTeamSize > this.maxTeamSize) {
            reasons.add("Min Team Size is greater than Max Team Size " + this.minTeamSize + ":" + this.maxTeamSize);
        }
        if (this.minTeams > this.maxTeams) {
            reasons.add("Min Teams is greater than Max Teams" + this.minTeams + ":" + this.maxTeams);
        }
        return reasons;
    }
}

