/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

public class CommandLineString {
    String raw;
    SenderType sender;
    String command;

    public static CommandLineString parse(String line) throws IllegalArgumentException {
        try {
            CommandLineString cls = new CommandLineString();
            int index = line.indexOf(32);
            cls.sender = SenderType.valueOf(line.substring(0, index).toUpperCase());
            cls.command = line.substring(index).trim();
            cls.raw = line;
            return cls;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Format for commands must be: <player or console> <commands> ... <commands>");
        }
    }

    public boolean isConsoleSender() {
        return this.sender == SenderType.CONSOLE;
    }

    public SenderType getSenderType() {
        return this.sender;
    }

    public String getCommand(String playerName) {
        return this.command.contains("player") ? this.command.replaceAll("player", playerName) : this.command;
    }

    public String getRawCommand() {
        return this.raw;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SenderType {
        CONSOLE,
        PLAYER;

    }
}

