/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.options.DuelOptions;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.teams.TeamFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Duel {
    final MatchParams mp;
    final ArenaTeam challenger;
    final HashMap<ArenaPlayer, Boolean> challengedPlayers = new HashMap();
    final DuelOptions options;
    Double totalMoney = null;

    public Duel(MatchParams mp, ArenaTeam challenger, DuelOptions options) {
        this.mp = mp;
        this.challenger = challenger;
        this.options = options;
        for (ArenaPlayer ap : options.getChallengedPlayers()) {
            this.challengedPlayers.put(ap, false);
        }
    }

    public boolean isChallenged(ArenaPlayer ap) {
        return this.challengedPlayers.containsKey(ap);
    }

    public boolean hasChallenger(ArenaPlayer player) {
        return this.challenger.hasMember(player);
    }

    public void accept(ArenaPlayer player) {
        this.challengedPlayers.put(player, true);
    }

    public Double getTotalMoney() {
        return this.totalMoney;
    }

    public void setTotalMoney(Double totalMoney) {
        this.totalMoney = totalMoney;
    }

    public boolean isReady() {
        for (Boolean r : this.challengedPlayers.values()) {
            if (r.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public ArenaTeam getChallengerTeam() {
        return this.challenger;
    }

    public ArenaTeam makeChallengedTeam() {
        return TeamFactory.createCompositeTeam(1, this.mp, this.challengedPlayers.keySet());
    }

    public MatchParams getMatchParams() {
        return this.mp;
    }

    public Collection<ArenaPlayer> getChallengedPlayers() {
        return this.challengedPlayers.keySet();
    }

    public Object getDuelOptionValue(DuelOptions.DuelOption option) {
        return this.options.getOptionValue(option);
    }

    public DuelOptions getOptions() {
        return this.options;
    }

    public Set<ArenaPlayer> getAllPlayers() {
        HashSet<ArenaPlayer> players = new HashSet<ArenaPlayer>();
        players.addAll(this.challengedPlayers.keySet());
        players.addAll(this.challenger.getPlayers());
        return players;
    }
}

