/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.ArrayList;
import java.util.List;
import mc.alk.arena.objects.ArenaParams;
import mc.alk.arena.objects.JoinType;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.arenas.ArenaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventParams
extends MatchParams {
    Integer secondsTillStart;
    Integer announcementInterval;
    List<String> openOptions;
    EventParams eparent;

    public EventParams(MatchParams mp) {
        super(mp);
    }

    @Override
    public void copy(ArenaParams ap) {
        if (this == ap) {
            return;
        }
        super.copy(ap);
        if (ap instanceof EventParams) {
            EventParams ep = (EventParams)ap;
            this.secondsTillStart = ep.secondsTillStart;
            this.announcementInterval = ep.announcementInterval;
            this.eparent = ep.eparent;
            if (ep.openOptions != null) {
                this.openOptions = new ArrayList<String>(ep.openOptions);
            }
        }
    }

    @Override
    public void flatten() {
        if (this.eparent != null) {
            if (this.secondsTillStart == null) {
                this.secondsTillStart = this.eparent.getSecondsTillStart();
            }
            if (this.announcementInterval == null) {
                this.announcementInterval = this.eparent.getAnnouncementInterval();
            }
            if (this.openOptions == null) {
                this.openOptions = this.eparent.getPlayerOpenOptions();
            }
            this.eparent = null;
        }
        super.flatten();
    }

    public EventParams(ArenaType at) {
        super(at);
    }

    public Integer getSecondsTillStart() {
        return this.secondsTillStart == null && this.eparent != null ? this.eparent.getSecondsTillStart() : this.secondsTillStart;
    }

    public void setSecondsTillStart(Integer secondsTillStart) {
        this.secondsTillStart = secondsTillStart;
    }

    public Integer getAnnouncementInterval() {
        return this.announcementInterval == null && this.eparent != null ? this.eparent.getAnnouncementInterval() : this.announcementInterval;
    }

    public void setAnnouncementInterval(Integer announcementInterval) {
        this.announcementInterval = announcementInterval;
    }

    @Override
    public JoinType getJoinType() {
        return JoinType.JOINPHASE;
    }

    public void setPlayerOpenOptions(List<String> playerOpenOptions) {
        this.openOptions = playerOpenOptions;
    }

    public List<String> getPlayerOpenOptions() {
        return this.openOptions != null ? this.openOptions : (this.eparent != null ? this.eparent.getPlayerOpenOptions() : null);
    }

    @Override
    public void setParent(ArenaParams parent) {
        super.setParent(parent);
        this.eparent = parent instanceof EventParams ? (EventParams)parent : null;
    }
}

