/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mc.alk.arena.controllers.RoomController;
import mc.alk.arena.controllers.containers.GameManager;
import mc.alk.arena.objects.ArenaParams;
import mc.alk.arena.objects.JoinType;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.arenas.ArenaType;
import mc.alk.arena.objects.messaging.AnnouncementOptions;
import mc.alk.arena.objects.modules.ArenaModule;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.objects.victoryconditions.VictoryType;
import mc.alk.arena.util.MessageUtil;
import org.bukkit.ChatColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchParams
extends ArenaParams
implements Comparable<MatchParams> {
    String prefix;
    String signDisplayName;
    VictoryType vc;
    Integer intervalTime;
    AnnouncementOptions ao;
    Integer numConcurrentCompetitions;
    Set<ArenaModule> modules;
    Boolean useBTPvP;
    Boolean useBTMessages;
    Boolean useBTTeamRating;
    MatchParams mparent;

    public MatchParams() {
    }

    public MatchParams(ArenaType at) {
        super(at);
    }

    public MatchParams(MatchParams mp) {
        super(mp);
    }

    @Override
    public void copy(ArenaParams ap) {
        if (this == ap) {
            return;
        }
        super.copy(ap);
        if (ap instanceof MatchParams) {
            MatchParams mp = (MatchParams)ap;
            this.prefix = mp.prefix;
            this.vc = mp.vc;
            this.intervalTime = mp.intervalTime;
            this.ao = mp.ao;
            this.numConcurrentCompetitions = mp.numConcurrentCompetitions;
            this.mparent = mp.mparent;
            this.useBTMessages = mp.useBTMessages;
            this.useBTPvP = mp.useBTPvP;
            this.useBTTeamRating = mp.useBTTeamRating;
            this.signDisplayName = mp.signDisplayName;
            if (mp.modules != null) {
                this.modules = new HashSet<ArenaModule>(mp.modules);
            }
        }
    }

    @Override
    public void flatten() {
        if (this.mparent != null) {
            if (this.prefix == null) {
                this.prefix = this.mparent.getPrefix();
            }
            if (this.vc == null) {
                this.vc = this.mparent.getVictoryType();
            }
            if (this.intervalTime == null) {
                this.intervalTime = this.mparent.getIntervalTime();
            }
            if (this.ao == null) {
                this.ao = this.mparent.getAnnouncementOptions();
            }
            if (this.numConcurrentCompetitions == null) {
                this.numConcurrentCompetitions = this.mparent.getNConcurrentCompetitions();
            }
            if (this.useBTMessages == null) {
                this.useBTMessages = this.mparent.getUseTrackerMessages();
            }
            if (this.useBTPvP == null) {
                this.useBTPvP = this.mparent.getUseTrackerPvP();
            }
            if (this.useBTTeamRating == null) {
                this.useBTTeamRating = this.mparent.isTeamRating();
            }
            if (this.signDisplayName == null) {
                this.signDisplayName = this.mparent.getSignDisplayName();
            }
            this.modules = this.getModules();
            this.mparent = null;
        }
        super.flatten();
    }

    public void setVictoryType(VictoryType type) {
        this.vc = type;
    }

    public VictoryType getVictoryType() {
        return this.vc == null && this.mparent != null ? this.mparent.getVictoryType() : this.vc;
    }

    public String getPrefix() {
        return this.prefix == null && this.mparent != null ? this.mparent.getPrefix() : this.prefix;
    }

    public String getSignDisplayName() {
        return this.signDisplayName == null && this.mparent != null ? this.mparent.getSignDisplayName() : this.signDisplayName;
    }

    public void setSignDisplayName(String signDisplayName) {
        this.signDisplayName = signDisplayName;
    }

    public void setPrefix(String str) {
        this.prefix = str;
    }

    public void setCommand(String str) {
        this.cmd = str;
    }

    @Override
    public int compareTo(MatchParams other) {
        Integer hash = this.hashCode();
        return hash.compareTo(other.hashCode());
    }

    public void setVictoryCondition(VictoryType victoryCondition) {
        this.vc = victoryCondition;
    }

    public Integer getIntervalTime() {
        return this.intervalTime == null && this.mparent != null ? this.mparent.getIntervalTime() : this.intervalTime;
    }

    public void setIntervalTime(Integer intervalTime) {
        this.intervalTime = intervalTime;
    }

    public int hashCode() {
        return this.arenaType == null ? super.hashCode() : this.arenaType.ordinal() << 25;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof MatchParams && this.hashCode() == other.hashCode();
    }

    public void setAnnouncementOptions(AnnouncementOptions announcementOptions) {
        this.ao = announcementOptions;
    }

    public AnnouncementOptions getAnnouncementOptions() {
        return this.ao;
    }

    @Override
    public String toString() {
        return super.toString() + ",vc=" + this.vc;
    }

    public ChatColor getColor() {
        return MessageUtil.getFirstColor(this.prefix);
    }

    public void setNConcurrentCompetitions(int number) {
        this.numConcurrentCompetitions = number;
    }

    public Integer getNConcurrentCompetitions() {
        return this.numConcurrentCompetitions != null ? this.numConcurrentCompetitions : (this.mparent != null ? this.mparent.getNConcurrentCompetitions() : null);
    }

    public JoinType getJoinType() {
        return JoinType.QUEUE;
    }

    public void addModule(ArenaModule am) {
        if (this.modules == null) {
            this.modules = new HashSet<ArenaModule>();
        }
        this.modules.add(am);
    }

    public Set<ArenaModule> getModules() {
        HashSet<ArenaModule> ms;
        HashSet<ArenaModule> hashSet = ms = this.modules == null ? new HashSet<ArenaModule>() : new HashSet<ArenaModule>(this.modules);
        if (this.mparent != null) {
            ms.addAll(this.mparent.getModules());
        }
        return ms;
    }

    public void setUseTrackerPvP(Boolean enable) {
        this.useBTPvP = enable;
    }

    public Boolean getUseTrackerPvP() {
        return this.useBTPvP != null ? this.useBTPvP : (this.mparent != null ? this.mparent.getUseTrackerPvP() : null);
    }

    public Boolean getUseTrackerMessages() {
        return this.useBTMessages != null ? this.useBTMessages : (this.mparent != null ? this.mparent.getUseTrackerMessages() : null);
    }

    public void setUseTrackerMessages(Boolean enable) {
        this.useBTMessages = enable;
    }

    @Override
    public boolean valid() {
        return super.valid() && (!this.getStateGraph().hasAnyOption((StateOption)TransitionOption.TELEPORTLOBBY) || RoomController.hasLobby(this.getType()));
    }

    @Override
    public Collection<String> getInvalidReasons() {
        ArrayList<String> reasons = new ArrayList<String>();
        if (this.getStateGraph().hasAnyOption((StateOption)TransitionOption.TELEPORTLOBBY) && !RoomController.hasLobby(this.getType())) {
            reasons.add("Needs a Lobby");
        }
        reasons.addAll(super.getInvalidReasons());
        return reasons;
    }

    @Override
    public void setParent(ArenaParams parent) {
        super.setParent(parent);
        this.mparent = parent instanceof MatchParams ? (MatchParams)parent : null;
    }

    public GameManager getGameManager() {
        return GameManager.getGameManager(this);
    }

    public void setTeamRating(Boolean b) {
        this.useBTTeamRating = b;
    }

    public Boolean isTeamRating() {
        return this.useBTTeamRating != null ? this.useBTTeamRating : (this.mparent != null ? this.mparent.isTeamRating() : null);
    }
}

