/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import mc.alk.arena.objects.CompetitionResult;
import mc.alk.arena.objects.WinLossDraw;
import mc.alk.arena.objects.teams.ArenaTeam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchResult
implements CompetitionResult {
    Set<ArenaTeam> victors = new HashSet<ArenaTeam>();
    Set<ArenaTeam> losers = new HashSet<ArenaTeam>();
    Set<ArenaTeam> drawers = new HashSet<ArenaTeam>();
    WinLossDraw wld = WinLossDraw.UNKNOWN;
    SortedMap<Integer, Collection<ArenaTeam>> ranks;

    public MatchResult() {
    }

    public MatchResult(CompetitionResult r) {
        this.wld = r.getResult();
        this.victors.addAll(r.getVictors());
        this.losers.addAll(r.getLosers());
        this.drawers.addAll(r.getDrawers());
    }

    @Override
    public void setResult(WinLossDraw wld) {
        this.wld = wld;
    }

    @Override
    public void setVictor(ArenaTeam vic) {
        this.victors.clear();
        this.victors.add(vic);
        this.wld = WinLossDraw.WIN;
    }

    @Override
    public void setVictors(Collection<ArenaTeam> victors) {
        this.victors.clear();
        this.victors.addAll(victors);
        this.wld = WinLossDraw.WIN;
    }

    @Override
    public void setDrawers(Collection<ArenaTeam> drawers) {
        this.drawers.clear();
        this.drawers.addAll(drawers);
        this.wld = WinLossDraw.DRAW;
    }

    @Override
    public void setLosers(Collection<ArenaTeam> losers) {
        this.losers.clear();
        this.losers.addAll(losers);
    }

    @Override
    public void addLosers(Collection<ArenaTeam> losers) {
        this.losers.addAll(losers);
    }

    @Override
    public void addLoser(ArenaTeam loser) {
        this.losers.add(loser);
    }

    @Override
    public Set<ArenaTeam> getVictors() {
        return this.victors;
    }

    @Override
    public Set<ArenaTeam> getLosers() {
        return this.losers;
    }

    @Override
    public void removeLosers(Collection<ArenaTeam> teams) {
        this.losers.removeAll(teams);
    }

    @Override
    public void removeDrawers(Collection<ArenaTeam> teams) {
        this.drawers.removeAll(teams);
    }

    @Override
    public void removeVictors(Collection<ArenaTeam> teams) {
        this.victors.removeAll(teams);
    }

    @Override
    public Set<ArenaTeam> getDrawers() {
        return this.drawers;
    }

    public String toString() {
        return "[" + (Object)((Object)this.wld) + ",victor=" + this.victors + ",losers=" + this.losers + ",drawers=" + this.drawers + "]" + this.toPrettyString();
    }

    @Override
    public String toPrettyString() {
        if (this.victors.isEmpty()) {
            return "&eThere are no victors yet";
        }
        StringBuilder sb = new StringBuilder();
        for (ArenaTeam t : this.victors) {
            sb.append(t.getTeamSummary()).append(" ");
        }
        sb.append(" &ewins vs ");
        for (ArenaTeam t : this.losers) {
            sb.append(t.getTeamSummary()).append(" ");
        }
        return sb.toString();
    }

    @Override
    public boolean isUnknown() {
        return this.wld == WinLossDraw.UNKNOWN;
    }

    @Override
    public boolean isDraw() {
        return this.wld == WinLossDraw.DRAW;
    }

    @Override
    public boolean isWon() {
        return this.hasVictor();
    }

    @Override
    public boolean isLost() {
        return this.wld == WinLossDraw.LOSS;
    }

    @Override
    public boolean isFinished() {
        return this.wld == WinLossDraw.WIN || this.wld == WinLossDraw.DRAW;
    }

    @Override
    public boolean hasVictor() {
        return this.wld == WinLossDraw.WIN;
    }

    @Override
    public WinLossDraw getResult() {
        return this.wld;
    }

    @Override
    public SortedMap<Integer, Collection<ArenaTeam>> getRanking() {
        return this.ranks;
    }

    @Override
    public void setRanking(SortedMap<Integer, Collection<ArenaTeam>> ranks) {
        this.ranks = ranks;
    }
}

