/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.ArrayList;
import java.util.List;
import mc.alk.arena.controllers.StateController;
import mc.alk.arena.objects.CompetitionTransition;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.options.TransitionOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MatchState implements CompetitionTransition
{
    NONE("None"),
    DEFAULTS("defaults"),
    ONENTER("onEnter"),
    ONLEAVE("onLeave"),
    ONENTERARENA("onEnterArena"),
    ONLEAVEARENA("onLeaveArena"),
    INQUEUE("inQueue"),
    INCOURTYARD("inCourtyard"),
    INLOBBY("inLobby"),
    INWAITROOM("inWaitroom"),
    INSPECTATE("inSpectate"),
    INARENA("inArena"),
    ONCREATE("onCreate"),
    PREREQS("preReqs"),
    ONJOIN("onJoin"),
    INJOIN("inJoin"),
    ONOPEN("onOpen"),
    INOPEN("inOpen"),
    ONBEGIN("onBegin"),
    ONPRESTART("onPreStart"),
    INPRESTART("inPrestart"),
    ONSTART("onStart"),
    INGAME("inGame"),
    ONVICTORY("onVictory"),
    INVICTORY("inVictory"),
    ONCOMPLETE("onComplete"),
    ONCANCEL("onCancel"),
    ONFINISH("onFinish"),
    ONSPAWN("onSpawn"),
    ONDEATH("onDeath"),
    WINNERS("winners"),
    DRAWERS("drawers"),
    LOSERS("losers"),
    ONMATCHINTERVAL("onMatchInterval"),
    ONMATCHTIMEEXPIRED("onMatchTimeExpired"),
    ONCOUNTDOWNTOEVENT("onCountdownToEvent"),
    ONENTERQUEUE("onEnterQueue");

    final String name;
    final int globalOrdinal;

    private MatchState(String name) {
        this.name = name;
        this.globalOrdinal = StateController.register(this);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int globalOrdinal() {
        return this.globalOrdinal;
    }

    public static MatchState fromString(String str) {
        str = str.toUpperCase();
        try {
            return MatchState.valueOf(str);
        }
        catch (Exception e) {
            if (str.equals("ONCOUNTDOWNTOEVENT")) {
                return ONCOUNTDOWNTOEVENT;
            }
            if (str.equals("WINNER")) {
                return WINNERS;
            }
            if (str.equals("INSTART")) {
                return INGAME;
            }
            return null;
        }
    }

    public boolean isRunning() {
        return this == ONSTART;
    }

    public static List<MatchState> getStates(MatchState beginState, MatchState endState) {
        ArrayList<MatchState> list = new ArrayList<MatchState>();
        boolean start = false;
        for (MatchState state : MatchState.values()) {
            if (state == endState) break;
            if (state == beginState) {
                start = true;
            }
            if (!start) continue;
            list.add(state);
        }
        return list;
    }

    public MatchState getCorrectState(StateOption option) {
        if (!(option instanceof TransitionOption)) {
            return this;
        }
        TransitionOption op = (TransitionOption)option;
        switch (this) {
            case NONE: {
                break;
            }
            case DEFAULTS: {
                break;
            }
            case ONENTER: {
                break;
            }
            case ONLEAVE: {
                break;
            }
            case ONENTERARENA: {
                break;
            }
            case ONLEAVEARENA: {
                break;
            }
            case INQUEUE: {
                break;
            }
            case INCOURTYARD: {
                break;
            }
            case INLOBBY: {
                break;
            }
            case INWAITROOM: {
                break;
            }
            case INSPECTATE: {
                break;
            }
            case INARENA: {
                break;
            }
            case ONCREATE: {
                break;
            }
            case PREREQS: {
                break;
            }
            case ONJOIN: {
                if (!op.isState()) break;
                return INOPEN;
            }
            case INJOIN: {
                break;
            }
            case ONOPEN: {
                if (!op.isState()) break;
                return INOPEN;
            }
            case INOPEN: {
                if (!op.isTransition()) break;
                return INOPEN;
            }
            case ONBEGIN: {
                break;
            }
            case ONPRESTART: {
                if (!op.isState()) break;
                return INPRESTART;
            }
            case INPRESTART: {
                if (!op.isTransition()) break;
                return ONPRESTART;
            }
            case ONSTART: {
                if (!op.isState()) break;
                return INGAME;
            }
            case INGAME: {
                if (!op.isTransition()) break;
                return ONSTART;
            }
            case ONVICTORY: {
                if (!op.isState()) break;
                return INVICTORY;
            }
            case INVICTORY: {
                if (!op.isTransition()) break;
                return ONVICTORY;
            }
            case ONCOMPLETE: {
                break;
            }
            case ONCANCEL: {
                break;
            }
            case ONFINISH: {
                break;
            }
            case ONSPAWN: {
                break;
            }
            case ONDEATH: {
                break;
            }
            case WINNERS: {
                break;
            }
            case DRAWERS: {
                break;
            }
            case LOSERS: {
                break;
            }
            case ONMATCHINTERVAL: {
                break;
            }
            case ONMATCHTIMEEXPIRED: {
                break;
            }
            case ONCOUNTDOWNTOEVENT: {
                break;
            }
        }
        return this;
    }
}

