/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionResult;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchResult;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.options.JoinOptions;
import mc.alk.arena.objects.teams.ArenaTeam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matchup {
    static int count = 0;
    final int id = count++;
    public CompetitionResult result = new MatchResult();
    public List<ArenaTeam> teams = new ArrayList<ArenaTeam>();
    List<ArenaListener> listeners = new ArrayList<ArenaListener>();
    MatchParams params = null;
    Match match = null;
    final JoinOptions joinOptions;

    public Matchup(MatchParams params, ArenaTeam team, ArenaTeam team2, JoinOptions joinOptions) {
        this.params = params;
        this.teams.add(team);
        this.teams.add(team2);
        this.joinOptions = joinOptions;
    }

    public Matchup(MatchParams params, Collection<ArenaTeam> teams, JoinOptions joinOptions) {
        this.teams = new ArrayList<ArenaTeam>(teams);
        this.params = ParamController.copyParams(params);
        this.joinOptions = joinOptions;
    }

    public MatchParams getMatchParams() {
        return this.params;
    }

    public void setResult(CompetitionResult result) {
        this.result = result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ArenaTeam t : this.teams) {
            sb.append("t=").append(t).append(",");
        }
        return sb.toString() + " result=" + this.result;
    }

    public List<ArenaTeam> getTeams() {
        return this.teams;
    }

    public ArenaTeam getTeam(int i) {
        return this.teams.get(i);
    }

    public CompetitionResult getResult() {
        return this.result;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Matchup && this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        return this.id;
    }

    public void addArenaListener(ArenaListener transitionListener) {
        this.listeners.add(transitionListener);
    }

    public List<ArenaListener> getArenaListeners() {
        return this.listeners;
    }

    public void addMatch(Match match) {
        this.match = match;
    }

    public Match getMatch() {
        return this.match;
    }

    public Integer getPriority() {
        Integer priority = Integer.MAX_VALUE;
        for (ArenaTeam t : this.teams) {
            if (t.getPriority() >= priority) continue;
            priority = t.getPriority();
        }
        return priority;
    }

    public boolean hasMember(ArenaPlayer p) {
        for (ArenaTeam t : this.teams) {
            if (!t.hasMember(p)) continue;
            return true;
        }
        return false;
    }

    public ArenaTeam getTeam(ArenaPlayer p) {
        for (ArenaTeam t : this.teams) {
            if (!t.hasMember(p)) continue;
            return t;
        }
        return null;
    }

    public int size() {
        int size = 0;
        for (ArenaTeam t : this.teams) {
            size += t.size();
        }
        return size;
    }

    public JoinOptions getJoinOptions() {
        return this.joinOptions;
    }

    public Arena getArena() {
        return this.joinOptions.getArena();
    }

    public void setArena(Arena arena) {
        this.joinOptions.setArena(arena);
    }
}

