/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.MoneyController;
import mc.alk.arena.controllers.plugins.EssentialsController;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.listeners.BAPlayerListener;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.serializers.InventorySerializer;
import mc.alk.arena.util.EffectUtil;
import mc.alk.arena.util.ExpUtil;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.PermissionsUtil;
import mc.alk.arena.util.PlayerUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerSave {
    final ArenaPlayer player;
    Integer experience;
    Double health;
    Double healthp;
    Integer hunger;
    Integer magic;
    Double magicp;
    InventoryUtil.PInv items;
    InventoryUtil.PInv matchItems;
    GameMode gamemode;
    Boolean godmode;
    Location location;
    Collection<PotionEffect> effects;
    Boolean flight;
    String arenaClass;
    String oldTeam;
    private Object scoreboard;
    Double money;

    public PlayerSave(ArenaPlayer player) {
        this.player = player;
    }

    public String getName() {
        return this.player.getName();
    }

    public Integer getExp() {
        return this.experience;
    }

    public void setExp(Integer exp) {
        this.experience = exp;
    }

    public Double getHealth() {
        return this.health;
    }

    public void setHealth(Double health) {
        this.health = health;
    }

    public Double getHealthp() {
        return this.healthp;
    }

    public void setHealthp(Double healthp) {
        this.healthp = healthp;
    }

    public Integer getHunger() {
        return this.hunger;
    }

    public void setHunger(Integer hunger) {
        this.hunger = hunger;
    }

    public Integer getMagic() {
        return this.magic;
    }

    public void setMagic(Integer magic) {
        this.magic = magic;
    }

    public Double getMagicp() {
        return this.magicp;
    }

    public void setMagicp(Double magicp) {
        this.magicp = magicp;
    }

    public InventoryUtil.PInv getItems() {
        return this.items;
    }

    public void setItems(InventoryUtil.PInv items) {
        this.items = items;
    }

    public GameMode getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(GameMode gamemode) {
        this.gamemode = gamemode;
    }

    public Boolean getGodmode() {
        return this.godmode;
    }

    public void setGodmode(Boolean godmode) {
        this.godmode = godmode;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Collection<PotionEffect> getEffects() {
        return this.effects;
    }

    public void setEffects(Collection<PotionEffect> effects) {
        this.effects = effects;
    }

    public Boolean getFlight() {
        return this.flight;
    }

    public void setFlight(Boolean flight) {
        this.flight = flight;
    }

    public String getArenaClass() {
        return this.arenaClass;
    }

    public void setArenaClass(String arenaClass) {
        this.arenaClass = arenaClass;
    }

    public String getOldTeam() {
        return this.oldTeam;
    }

    public void setOldTeam(String oldTeam) {
        this.oldTeam = oldTeam;
    }

    public Double getMoney() {
        return this.money;
    }

    public void setMoney(Double money) {
        this.money = money;
    }

    public InventoryUtil.PInv getMatchItems() {
        return this.matchItems;
    }

    public int storeExperience() {
        Player p = this.player.getPlayer();
        int exp = ExpUtil.getTotalExperience(p);
        if (exp == 0) {
            return 0;
        }
        this.experience = this.experience == null ? exp : this.experience + exp;
        ExpUtil.setTotalExperience(p, 0);
        try {
            p.updateInventory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exp;
    }

    public void restoreExperience() {
        if (this.experience == null) {
            return;
        }
        Player p = this.player.getPlayer();
        ExpUtil.setTotalExperience(p.getPlayer(), this.experience);
        this.experience = null;
    }

    public Integer removeExperience() {
        Integer exp = this.experience;
        this.experience = null;
        return exp;
    }

    public void storeHealth() {
        if (this.health != null) {
            return;
        }
        this.health = this.player.getHealth();
        if (Defaults.DEBUG_STORAGE) {
            Log.info("storing health=" + this.health + " for player=" + this.player.getName());
        }
    }

    public void restoreHealth() {
        if (this.health == null || this.health <= 0.0) {
            return;
        }
        if (Defaults.DEBUG_STORAGE) {
            Log.info("restoring health=" + this.health + " for player=" + this.player.getName());
        }
        PlayerUtil.setHealth(this.player.getPlayer(), this.health);
        this.health = null;
    }

    public Double removeHealth() {
        Double rhealth = this.health;
        this.health = null;
        return rhealth;
    }

    public void storeHunger() {
        if (this.hunger != null) {
            return;
        }
        this.hunger = this.player.getFoodLevel();
    }

    public void restoreHunger() {
        if (this.hunger == null || this.hunger <= 0) {
            return;
        }
        PlayerUtil.setHunger(this.player.getPlayer(), this.hunger);
        this.hunger = null;
    }

    public Integer removeHunger() {
        Integer ret = this.hunger;
        this.hunger = null;
        return ret;
    }

    public void storeEffects() {
        if (this.effects != null) {
            return;
        }
        this.effects = new ArrayList<PotionEffect>(this.player.getPlayer().getActivePotionEffects());
    }

    public void restoreEffects() {
        if (this.effects == null) {
            return;
        }
        EffectUtil.enchantPlayer(this.player.getPlayer(), this.effects);
        this.effects = null;
    }

    public Collection<PotionEffect> removeEffects() {
        Collection<PotionEffect> ret = this.effects;
        this.effects = null;
        return ret;
    }

    public void storeMagic() {
        if (!HeroesController.enabled() || this.magic != null) {
            return;
        }
        this.magic = HeroesController.getMagicLevel(this.player.getPlayer());
    }

    public void restoreMagic() {
        if (!HeroesController.enabled() || this.magic == null) {
            return;
        }
        HeroesController.setMagicLevel(this.player.getPlayer(), this.magic);
        this.magic = null;
    }

    public Integer removeMagic() {
        Integer ret = this.magic;
        this.magic = null;
        return ret;
    }

    public void storeItems() {
        if (this.items != null) {
            return;
        }
        InventoryUtil.closeInventory(this.player.getPlayer());
        this.items = new InventoryUtil.PInv(this.player.getInventory());
        InventorySerializer.saveInventory(this.player.getID(), this.items);
    }

    public void restoreItems() {
        if (this.items == null) {
            return;
        }
        InventoryUtil.addToInventory(this.player.getPlayer(), this.items);
        this.items = null;
    }

    public InventoryUtil.PInv removeItems() {
        InventoryUtil.PInv ret = this.items;
        this.items = null;
        return ret;
    }

    public void storeMatchItems() {
        UUID id = this.player.getID();
        InventoryUtil.closeInventory(this.player.getPlayer());
        InventoryUtil.PInv pinv = new InventoryUtil.PInv(this.player.getInventory());
        if (this.matchItems == null) {
            InventorySerializer.saveInventory(id, pinv);
        }
        this.matchItems = pinv;
        BAPlayerListener.restoreMatchItemsOnReenter(this.player, pinv);
    }

    public void restoreMatchItems() {
        if (this.matchItems == null) {
            return;
        }
        InventoryUtil.addToInventory(this.player.getPlayer(), this.matchItems);
        this.matchItems = null;
    }

    public InventoryUtil.PInv removeMatchItems() {
        InventoryUtil.PInv ret = this.matchItems;
        this.matchItems = null;
        return ret;
    }

    public void storeGamemode() {
        if (this.gamemode != null) {
            return;
        }
        PermissionsUtil.givePlayerInventoryPerms(this.player.getPlayer());
        this.gamemode = this.player.getPlayer().getGameMode();
    }

    public void storeFlight() {
        if (!EssentialsController.enabled() || this.flight != null) {
            return;
        }
        Boolean b = EssentialsController.isFlying(this.player);
        if (b.booleanValue()) {
            this.flight = true;
        }
    }

    public void restoreFlight() {
        if (this.flight == null) {
            return;
        }
        EssentialsController.setFlight(this.player.getPlayer(), this.flight);
        this.flight = null;
    }

    public void storeGodmode() {
        if (!EssentialsController.enabled() || this.godmode != null) {
            return;
        }
        Boolean b = EssentialsController.isGod(this.player);
        if (b.booleanValue()) {
            this.godmode = true;
        }
    }

    public void restoreGodmode() {
        if (this.godmode == null) {
            return;
        }
        EssentialsController.setGod(this.player.getPlayer(), this.godmode);
        this.godmode = null;
    }

    public void restoreGamemode() {
        if (this.gamemode == null) {
            return;
        }
        PlayerUtil.setGameMode(this.player.getPlayer(), this.gamemode);
        this.gamemode = null;
    }

    public GameMode removeGamemode() {
        GameMode ret = this.gamemode;
        this.gamemode = null;
        return ret;
    }

    public void storeArenaClass() {
        if (!HeroesController.enabled() || this.arenaClass != null) {
            return;
        }
        this.arenaClass = HeroesController.getHeroClassName(this.player.getPlayer());
    }

    public void restoreArenaClass() {
        if (!HeroesController.enabled() || this.arenaClass == null) {
            return;
        }
        HeroesController.setHeroClass(this.player.getPlayer(), this.arenaClass);
    }

    public void storeScoreboard() {
        if (this.scoreboard != null) {
            return;
        }
        this.scoreboard = PlayerUtil.getScoreboard(this.player.getPlayer());
    }

    public Object getScoreboard() {
        return this.scoreboard;
    }

    public void restoreScoreboard() {
        if (this.scoreboard == null) {
            return;
        }
        PlayerUtil.setScoreboard(this.player.getPlayer(), this.scoreboard);
    }

    public void restoreMoney() {
        if (this.money == null) {
            return;
        }
        MoneyController.add(this.player.getName(), this.money);
        this.money = null;
    }

    public UUID getID() {
        return this.player.getID();
    }
}

